/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.utils;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.LogHelper;

public final class HttpDownloader {
    public static final int INTERVAL = 500;
    public final AtomicInteger writed = new AtomicInteger(0);
    private volatile String filename = null;
    public final Thread thread = new Thread(() -> {
        try {
            this.filename = IOHelper.getFileName(file);
            HttpDownloader.downloadFile(url, file, this.writed::set);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    });

    public HttpDownloader(URL url, Path file) {
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public String getFilename() {
        return this.filename;
    }

    public static void downloadFile(URL url, Path file, Consumer<Integer> chanheTrack) throws IOException {
        try (BufferedInputStream in = new BufferedInputStream(url.openStream());
             OutputStream fout = IOHelper.newOutput(file, false);){
            int count;
            byte[] data = new byte[IOHelper.BUFFER_SIZE];
            long timestamp = System.currentTimeMillis();
            int writed_local = 0;
            while ((count = in.read(data, 0, IOHelper.BUFFER_SIZE)) != -1) {
                fout.write(data, 0, count);
                writed_local += count;
                if (System.currentTimeMillis() - timestamp <= 500L) continue;
                chanheTrack.accept(writed_local);
                LogHelper.debug("Downloaded %d", writed_local);
            }
            chanheTrack.accept(writed_local);
        }
    }

    public static void downloadZip(URL url, Path dir) throws IOException {
        try (ZipInputStream input = IOHelper.newZipInput(url);){
            ZipEntry entry = input.getNextEntry();
            while (entry != null) {
                if (!entry.isDirectory()) {
                    String name = entry.getName();
                    LogHelper.subInfo("Downloading file: '%s'", name);
                    IOHelper.transfer((InputStream)input, dir.resolve(IOHelper.toPath(name)));
                }
                entry = input.getNextEntry();
            }
        }
    }
}

