/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.utils.helper;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import pro.gravit.utils.helper.IOHelper;

public class JarHelper {
    public static void zipWalk(ZipInputStream input, ZipWalkCallback callback) throws IOException {
        ZipEntry e = input.getNextEntry();
        while (e != null) {
            callback.process(input, e);
            e = input.getNextEntry();
        }
    }

    public static void jarWalk(ZipInputStream input, JarWalkCallback callback) throws IOException {
        ZipEntry e = input.getNextEntry();
        while (e != null) {
            String filename = e.getName();
            if (filename.endsWith(".class")) {
                String classFull = filename.replaceAll("/", ".").substring(0, filename.length() - ".class".length());
                String clazz = classFull.substring(classFull.lastIndexOf(46) + 1);
                callback.process(input, e, classFull, clazz);
            }
            e = input.getNextEntry();
        }
    }

    public static Map<String, String> jarMap(ZipInputStream input, boolean overwrite) throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        JarHelper.jarMap(input, map, overwrite);
        return map;
    }

    public static void jarMap(ZipInputStream input, Map<String, String> map, boolean overwrite) throws IOException {
        JarHelper.jarWalk(input, (in, e, classFull, clazz) -> {
            if (overwrite) {
                map.put(clazz, classFull);
            } else {
                map.putIfAbsent(clazz, classFull);
            }
        });
    }

    public static Map<String, String> jarMap(Path file, boolean overwrite) throws IOException {
        try (ZipInputStream inputStream = IOHelper.newZipInput(file);){
            Map<String, String> map = JarHelper.jarMap(inputStream, overwrite);
            return map;
        }
    }

    public static void jarMap(Path file, Map<String, String> map, boolean overwrite) throws IOException {
        try (ZipInputStream inputStream = IOHelper.newZipInput(file);){
            JarHelper.jarMap(inputStream, map, overwrite);
        }
    }

    public static Map<String, String> jarMap(Class<?> clazz, boolean overwrite) throws IOException {
        Path file = IOHelper.getCodeSource(clazz);
        return JarHelper.jarMap(file, overwrite);
    }

    public static void jarMap(Class<?> clazz, Map<String, String> map, boolean overwrite) throws IOException {
        Path file = IOHelper.getCodeSource(clazz);
        JarHelper.jarMap(file, map, overwrite);
    }

    public static String getClassFile(Class<?> clazz) {
        return JarHelper.getClassFile(clazz.getName());
    }

    public static String getClassFile(String classname) {
        return classname.replace('.', '/').concat(".class");
    }

    public static byte[] getClassBytes(Class<?> clazz) throws IOException {
        return JarHelper.getClassBytes(clazz, clazz.getClassLoader());
    }

    public static byte[] getClassBytes(Class<?> clazz, ClassLoader classLoader) throws IOException {
        return IOHelper.read(classLoader.getResourceAsStream(JarHelper.getClassFile(clazz)));
    }

    public static InputStream getClassBytesStream(Class<?> clazz) throws IOException {
        return JarHelper.getClassBytesStream(clazz, clazz.getClassLoader());
    }

    public static InputStream getClassBytesStream(Class<?> clazz, ClassLoader classLoader) throws IOException {
        return classLoader.getResourceAsStream(JarHelper.getClassFile(clazz));
    }

    @FunctionalInterface
    public static interface JarWalkCallback {
        public void process(ZipInputStream var1, ZipEntry var2, String var3, String var4);
    }

    @FunctionalInterface
    public static interface ZipWalkCallback {
        public void process(ZipInputStream var1, ZipEntry var2) throws IOException;
    }
}

