/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.utils;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import pro.gravit.utils.ProviderMap;
import pro.gravit.utils.TypeSerializeInterface;
import pro.gravit.utils.helper.LogHelper;

public class UniversalJsonAdapter<R>
implements JsonSerializer<R>,
JsonDeserializer<R> {
    public final ProviderMap<R> providerMap;
    public final String name;
    public final String PROP_NAME;
    public final boolean printErrorIfUnknownType;

    public UniversalJsonAdapter(ProviderMap<R> providerMap) {
        this.providerMap = providerMap;
        this.name = providerMap.getName();
        this.PROP_NAME = "type";
        this.printErrorIfUnknownType = true;
    }

    public UniversalJsonAdapter(ProviderMap<R> providerMap, String PROP_NAME) {
        this.providerMap = providerMap;
        this.name = providerMap.getName();
        this.PROP_NAME = PROP_NAME;
        this.printErrorIfUnknownType = true;
    }

    public UniversalJsonAdapter(ProviderMap<R> providerMap, String name, String PROP_NAME, boolean printErrorIfUnknownType) {
        this.providerMap = providerMap;
        this.name = name;
        this.PROP_NAME = PROP_NAME;
        this.printErrorIfUnknownType = printErrorIfUnknownType;
    }

    public UniversalJsonAdapter(ProviderMap<R> providerMap, String name, boolean printErrorIfUnknownType) {
        this.providerMap = providerMap;
        this.name = name;
        this.PROP_NAME = "type";
        this.printErrorIfUnknownType = printErrorIfUnknownType;
    }

    public R deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        String typename = json.getAsJsonObject().getAsJsonPrimitive(this.PROP_NAME).getAsString();
        Class<R> cls = this.providerMap.getClass(typename);
        if (cls == null) {
            if (this.printErrorIfUnknownType) {
                LogHelper.error("%s %s not found", this.name, typename);
            }
            return null;
        }
        return (R)context.deserialize(json, cls);
    }

    public JsonElement serialize(R src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject jo = context.serialize(src).getAsJsonObject();
        String classPath = this.providerMap.getName(src.getClass());
        if (classPath == null && src instanceof TypeSerializeInterface) {
            classPath = ((TypeSerializeInterface)src).getType();
        }
        if (classPath == null) {
            if (this.printErrorIfUnknownType) {
                LogHelper.warning("Class %s type null", src.getClass());
            }
        } else {
            jo.add(this.PROP_NAME, (JsonElement)new JsonPrimitive(classPath));
        }
        return jo;
    }
}

