/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.utils.helper;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.ECKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.VerifyHelper;

public final class SecurityHelper {
    public static final String EC_ALGO = "EC";
    public static final String EC_CURVE = "secp256k1";
    public static final String EC_SIGN_ALGO = "SHA256withECDSA";
    public static final String EC_CIPHER_ALGO = "ECIES";
    public static final int TOKEN_LENGTH = 16;
    public static final int AES_KEY_LENGTH = 8;
    public static final int TOKEN_STRING_LENGTH = 32;
    public static final int RSA_KEY_LENGTH_BITS = 2048;
    public static final int RSA_KEY_LENGTH = 256;
    public static final int CRYPTO_MAX_LENGTH = 2048;
    public static final String HEX = "0123456789abcdef";
    public static final byte[] NUMBERS = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
    public static final SecureRandom secureRandom = new SecureRandom();
    private static final char[] VOWELS = new char[]{'e', 'u', 'i', 'o', 'a'};
    private static final char[] CONS = new char[]{'r', 't', 'p', 's', 'd', 'f', 'g', 'h', 'k', 'l', 'c', 'v', 'b', 'n', 'm'};

    private SecurityHelper() {
    }

    public static byte[] digest(DigestAlgorithm algo, byte[] bytes) {
        return SecurityHelper.newDigest(algo).digest(bytes);
    }

    public static byte[] digest(DigestAlgorithm algo, InputStream input) throws IOException {
        byte[] buffer = IOHelper.newBuffer();
        MessageDigest digest = SecurityHelper.newDigest(algo);
        int length = input.read(buffer);
        while (length != -1) {
            digest.update(buffer, 0, length);
            length = input.read(buffer);
        }
        return digest.digest();
    }

    public static byte[] digest(DigestAlgorithm algo, Path file) throws IOException {
        try (InputStream input = IOHelper.newInput(file);){
            byte[] byArray = SecurityHelper.digest(algo, input);
            return byArray;
        }
    }

    public static byte[] digest(DigestAlgorithm algo, String s) {
        return SecurityHelper.digest(algo, IOHelper.encode(s));
    }

    public static byte[] digest(DigestAlgorithm algo, URL url) throws IOException {
        try (InputStream input = IOHelper.newInput(url);){
            byte[] byArray = SecurityHelper.digest(algo, input);
            return byArray;
        }
    }

    public static KeyPair genECKeyPair(SecureRandom random) {
        try {
            KeyPairGenerator generator = KeyPairGenerator.getInstance(EC_ALGO);
            generator.initialize(new ECGenParameterSpec(EC_CURVE), random);
            return generator.genKeyPair();
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException e) {
            throw new InternalError(e);
        }
    }

    public static boolean isValidSign(byte[] bytes, byte[] sign, ECPublicKey publicKey) throws SignatureException {
        Signature signature = SecurityHelper.newECVerifySignature(publicKey);
        try {
            signature.update(bytes);
        }
        catch (SignatureException e) {
            throw new InternalError(e);
        }
        return signature.verify(sign);
    }

    public static boolean isValidSign(InputStream input, byte[] sign, ECPublicKey publicKey) throws IOException, SignatureException {
        Signature signature = SecurityHelper.newECVerifySignature(publicKey);
        SecurityHelper.updateSignature(input, signature);
        return signature.verify(sign);
    }

    public static boolean isValidToken(CharSequence token) {
        return token.length() == 32 && token.chars().allMatch(ch -> HEX.indexOf(ch) >= 0);
    }

    public static Cipher newCipher(String algo) {
        try {
            return Cipher.getInstance(algo);
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new InternalError(e);
        }
    }

    private static Cipher newBCCipher(String algo) {
        try {
            return Cipher.getInstance(algo, "BC");
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException | NoSuchPaddingException e) {
            throw new InternalError(e);
        }
    }

    public static MessageDigest newDigest(DigestAlgorithm algo) {
        VerifyHelper.verify(algo, a -> a != DigestAlgorithm.PLAIN, "PLAIN digest");
        try {
            return MessageDigest.getInstance(algo.name);
        }
        catch (NoSuchAlgorithmException e) {
            throw new InternalError(e);
        }
    }

    public static SecureRandom newRandom() {
        return new SecureRandom();
    }

    private static Cipher newECCipher(int mode, ECKey key) {
        Cipher cipher = SecurityHelper.newBCCipher(EC_CIPHER_ALGO);
        try {
            cipher.init(mode, (Key)((Object)key));
        }
        catch (InvalidKeyException e) {
            throw new InternalError(e);
        }
        return cipher;
    }

    private static KeyFactory newECKeyFactory() {
        try {
            return KeyFactory.getInstance(EC_ALGO);
        }
        catch (NoSuchAlgorithmException e) {
            throw new InternalError(e);
        }
    }

    private static Signature newECSignature() {
        try {
            return Signature.getInstance(EC_SIGN_ALGO);
        }
        catch (NoSuchAlgorithmException e) {
            throw new InternalError(e);
        }
    }

    public static Signature newECSignSignature(ECPrivateKey key) {
        Signature signature = SecurityHelper.newECSignature();
        try {
            signature.initSign(key);
        }
        catch (InvalidKeyException e) {
            throw new InternalError(e);
        }
        return signature;
    }

    public static Signature newECVerifySignature(ECPublicKey key) {
        Signature signature = SecurityHelper.newECSignature();
        try {
            signature.initVerify(key);
        }
        catch (InvalidKeyException e) {
            throw new InternalError(e);
        }
        return signature;
    }

    public static byte[] randomBytes(int length) {
        return SecurityHelper.randomBytes(SecurityHelper.newRandom(), length);
    }

    public static byte[] randomBytes(Random random, int length) {
        byte[] bytes = new byte[length];
        random.nextBytes(bytes);
        return bytes;
    }

    public static String randomStringToken() {
        return SecurityHelper.randomStringToken(SecurityHelper.newRandom());
    }

    public static String randomStringToken(Random random) {
        return SecurityHelper.toHex(SecurityHelper.randomToken(random));
    }

    public static byte[] randomToken() {
        return SecurityHelper.randomToken(SecurityHelper.newRandom());
    }

    public static byte[] randomToken(Random random) {
        return SecurityHelper.randomBytes(random, 16);
    }

    public static String randomStringAESKey() {
        return SecurityHelper.toHex(SecurityHelper.randomAESKey(SecurityHelper.newRandom()));
    }

    public static String randomStringAESKey(Random random) {
        return SecurityHelper.toHex(SecurityHelper.randomAESKey(random));
    }

    public static byte[] randomAESKey() {
        return SecurityHelper.randomAESKey(SecurityHelper.newRandom());
    }

    public static byte[] randomAESKey(Random random) {
        return SecurityHelper.randomBytes(random, 8);
    }

    public static String randomUsername() {
        return SecurityHelper.randomUsername(SecurityHelper.newRandom());
    }

    public static String randomUsername(Random random) {
        String suffix;
        String prefix;
        int usernameLength = 3 + random.nextInt(7);
        int prefixType = random.nextInt(7);
        if (usernameLength >= 5 && prefixType == 6) {
            prefix = random.nextBoolean() ? "Mr" : "Dr";
            usernameLength -= 2;
        } else if (usernameLength >= 6 && prefixType == 5) {
            prefix = "Mrs";
            usernameLength -= 3;
        } else {
            prefix = "";
        }
        int suffixType = random.nextInt(7);
        if (usernameLength >= 5 && suffixType == 6) {
            suffix = String.valueOf(10 + random.nextInt(90));
            usernameLength -= 2;
        } else if (usernameLength >= 7 && suffixType == 5) {
            suffix = String.valueOf(1990 + random.nextInt(26));
            usernameLength -= 4;
        } else {
            suffix = "";
        }
        int consRepeat = 0;
        boolean consPrev = random.nextBoolean();
        char[] chars = new char[usernameLength];
        for (int i = 0; i < chars.length; ++i) {
            if (i > 1 && consPrev && random.nextInt(10) == 0) {
                chars[i] = chars[i - 1];
                continue;
            }
            if (consRepeat < 1 && random.nextInt() == 5) {
                ++consRepeat;
            } else {
                consRepeat = 0;
                consPrev ^= true;
            }
            char[] alphabet = consPrev ? CONS : VOWELS;
            chars[i] = alphabet[random.nextInt(alphabet.length)];
        }
        if (!prefix.isEmpty() || random.nextBoolean()) {
            chars[0] = Character.toUpperCase(chars[0]);
        }
        return VerifyHelper.verifyUsername(prefix + new String(chars) + suffix);
    }

    public static byte[] sign(byte[] bytes, ECPrivateKey privateKey) {
        Signature signature = SecurityHelper.newECSignSignature(privateKey);
        try {
            signature.update(bytes);
            return signature.sign();
        }
        catch (SignatureException e) {
            throw new InternalError(e);
        }
    }

    public static String toHex(byte[] bytes) {
        int offset = 0;
        char[] hex = new char[bytes.length << 1];
        for (byte currentByte : bytes) {
            int ub = Byte.toUnsignedInt(currentByte);
            hex[offset] = HEX.charAt(ub >>> 4);
            hex[++offset] = HEX.charAt(ub & 0xF);
            ++offset;
        }
        return new String(hex);
    }

    public static ECPublicKey toPublicECKey(byte[] bytes) throws InvalidKeySpecException {
        return (ECPublicKey)SecurityHelper.newECKeyFactory().generatePublic(new X509EncodedKeySpec(bytes));
    }

    public static ECPrivateKey toPrivateECKey(byte[] bytes) throws InvalidKeySpecException {
        return (ECPrivateKey)SecurityHelper.newECKeyFactory().generatePrivate(new PKCS8EncodedKeySpec(bytes));
    }

    private static void updateSignature(InputStream input, Signature signature) throws IOException {
        byte[] buffer = IOHelper.newBuffer();
        int length = input.read(buffer);
        while (length >= 0) {
            try {
                signature.update(buffer, 0, length);
            }
            catch (SignatureException e) {
                throw new InternalError(e);
            }
            length = input.read(buffer);
        }
    }

    public static void verifySign(byte[] bytes, byte[] sign, ECPublicKey publicKey) throws SignatureException {
        if (!SecurityHelper.isValidSign(bytes, sign, publicKey)) {
            throw new SignatureException("Invalid sign");
        }
    }

    public static void verifySign(InputStream input, byte[] sign, ECPublicKey publicKey) throws SignatureException, IOException {
        if (!SecurityHelper.isValidSign(input, sign, publicKey)) {
            throw new SignatureException("Invalid stream sign");
        }
    }

    public static String verifyToken(String token) {
        return VerifyHelper.verify(token, SecurityHelper::isValidToken, String.format("Invalid token: '%s'", token));
    }

    public static Cipher newECDecryptCipher(ECPrivateKey privateKey) {
        try {
            return SecurityHelper.newECCipher(2, privateKey);
        }
        catch (SecurityException e) {
            throw new InternalError(e);
        }
    }

    public static Cipher newECEncryptCipher(ECPublicKey publicKey) {
        try {
            return SecurityHelper.newECCipher(1, publicKey);
        }
        catch (SecurityException e) {
            throw new InternalError(e);
        }
    }

    public static byte[] encrypt(String seed, byte[] cleartext) throws Exception {
        byte[] rawKey = SecurityHelper.getRawKey(seed.getBytes());
        return SecurityHelper.encrypt(rawKey, cleartext);
    }

    public static byte[] encrypt(String seed, String cleartext) throws Exception {
        return SecurityHelper.encrypt(seed, cleartext.getBytes());
    }

    private static byte[] getRawKey(byte[] seed) throws Exception {
        KeyGenerator kGen = KeyGenerator.getInstance("AES");
        SecureRandom sr = SecureRandom.getInstance("SHA1PRNG");
        sr.setSeed(seed);
        kGen.init(128, sr);
        SecretKey sKey = kGen.generateKey();
        return sKey.getEncoded();
    }

    public static byte[] encrypt(byte[] raw, byte[] clear) throws Exception {
        SecretKeySpec sKeySpec = new SecretKeySpec(raw, "AES");
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(1, sKeySpec);
        return cipher.doFinal(clear);
    }

    public static byte[] decrypt(byte[] raw, byte[] encrypted) throws Exception {
        SecretKeySpec sKeySpec = new SecretKeySpec(raw, "AES");
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(2, sKeySpec);
        return cipher.doFinal(encrypted);
    }

    public static byte[] decrypt(String seed, byte[] encrypted) throws Exception {
        return SecurityHelper.decrypt(SecurityHelper.getRawKey(seed.getBytes()), encrypted);
    }

    public static byte[] fromHex(String hexString) {
        int len = hexString.length() / 2;
        byte[] result = new byte[len];
        for (int i = 0; i < len; ++i) {
            result[i] = Integer.valueOf(hexString.substring(2 * i, 2 * i + 2), 16).byteValue();
        }
        return result;
    }

    public static final class DigestAlgorithm
    extends Enum<DigestAlgorithm> {
        public static final /* enum */ DigestAlgorithm PLAIN = new DigestAlgorithm("plain", -1);
        public static final /* enum */ DigestAlgorithm MD5 = new DigestAlgorithm("MD5", 128);
        public static final /* enum */ DigestAlgorithm SHA1 = new DigestAlgorithm("SHA-1", 160);
        public static final /* enum */ DigestAlgorithm SHA224 = new DigestAlgorithm("SHA-224", 224);
        public static final /* enum */ DigestAlgorithm SHA256 = new DigestAlgorithm("SHA-256", 256);
        public static final /* enum */ DigestAlgorithm SHA512 = new DigestAlgorithm("SHA-512", 512);
        private static final Map<String, DigestAlgorithm> ALGORITHMS;
        public final String name;
        public final int bits;
        public final int bytes;
        private static final /* synthetic */ DigestAlgorithm[] $VALUES;

        public static DigestAlgorithm[] values() {
            return (DigestAlgorithm[])$VALUES.clone();
        }

        public static DigestAlgorithm valueOf(String name) {
            return Enum.valueOf(DigestAlgorithm.class, name);
        }

        private DigestAlgorithm(String name, int bits) {
            this.name = name;
            this.bits = bits;
            this.bytes = bits / 8;
            assert (bits % 8 == 0);
        }

        public static DigestAlgorithm byName(String name) {
            return VerifyHelper.getMapValue(ALGORITHMS, name, String.format("Unknown digest algorithm: '%s'", name));
        }

        public String toString() {
            return this.name;
        }

        public byte[] verify(byte[] digest) {
            if (digest.length != this.bytes) {
                throw new IllegalArgumentException("Invalid digest length: " + digest.length);
            }
            return digest;
        }

        static {
            $VALUES = new DigestAlgorithm[]{PLAIN, MD5, SHA1, SHA224, SHA256, SHA512};
            DigestAlgorithm[] algorithmsValues = DigestAlgorithm.values();
            ALGORITHMS = new HashMap<String, DigestAlgorithm>(algorithmsValues.length);
            for (DigestAlgorithm algorithm : algorithmsValues) {
                ALGORITHMS.put(algorithm.name, algorithm);
            }
        }
    }
}

