/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import pro.gravit.utils.helper.LogHelper;

public class LauncherTrustManager {
    private final X509Certificate[] trustSigners;
    private final List<X509Certificate> trustCache = new ArrayList<X509Certificate>();

    public LauncherTrustManager(X509Certificate[] trustSigners) {
        this.trustSigners = trustSigners;
    }

    public LauncherTrustManager(List<byte[]> encodedCertificate) throws CertificateException {
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
        this.trustSigners = (X509Certificate[])encodedCertificate.stream().map(cert -> {
            X509Certificate x509Certificate;
            ByteArrayInputStream input = new ByteArrayInputStream((byte[])cert);
            try {
                x509Certificate = (X509Certificate)certFactory.generateCertificate(input);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((InputStream)input).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException | CertificateException e) {
                    LogHelper.error(e);
                    return null;
                }
            }
            ((InputStream)input).close();
            return x509Certificate;
        }).toArray(X509Certificate[]::new);
    }

    public void checkCertificate(X509Certificate[] certs, CertificateChecker checker) throws CertificateException, NoSuchProviderException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        if (certs == null) {
            throw new SecurityException("Object not signed");
        }
        for (int i = 0; i < certs.length; ++i) {
            X509Certificate cert = certs[i];
            if (this.trustCache.contains(cert)) {
                this.trustCache.addAll(Arrays.asList(certs).subList(0, i));
                return;
            }
            X509Certificate signer = i + 1 < certs.length ? certs[i + 1] : null;
            cert.checkValidity();
            if (signer != null) {
                cert.verify(signer.getPublicKey());
            } else if (!this.isTrusted(cert)) {
                throw new CertificateException(String.format("Certificate %s is not signed by a trusted signer", cert.getSubjectDN().getName()));
            }
            checker.check(cert, signer, i);
        }
        Collections.addAll(this.trustCache, certs);
    }

    public boolean isTrusted(X509Certificate certificate) throws CertificateEncodingException {
        for (X509Certificate cert : this.trustSigners) {
            if (!cert.getSerialNumber().equals(certificate.getSerialNumber()) || !Arrays.equals(cert.getEncoded(), certificate.getEncoded())) continue;
            return true;
        }
        return false;
    }

    public X509Certificate[] getTrusted() {
        return Arrays.copyOf(this.trustSigners, this.trustSigners.length);
    }

    public void isCertificateCodeSign(X509Certificate certificate) {
        try {
            List<String> extended = certificate.getExtendedKeyUsage();
            if (extended == null) {
                throw new SecurityException("Certificate extendedKeyUsage null");
            }
            boolean isCodeSign = false;
            for (String s : extended) {
                if (!s.equals("1.3.6.1.5.5.7.3.3")) continue;
                isCodeSign = true;
                break;
            }
            if (!isCodeSign) {
                throw new SecurityException("Certificate extendedKeyUsage codeSign checkFailed");
            }
        }
        catch (CertificateParsingException e) {
            throw new SecurityException(e);
        }
    }

    public void isCertificateCA(X509Certificate certificate) {
        if (certificate.getBasicConstraints() < 0) {
            throw new SecurityException("This certificate not CA");
        }
    }

    public void stdCertificateChecker(X509Certificate cert, X509Certificate signer, int number) {
        if (number == 0) {
            this.isCertificateCodeSign(cert);
        } else {
            this.isCertificateCA(cert);
        }
    }

    public static interface CertificateChecker {
        public void check(X509Certificate var1, X509Certificate var2, int var3) throws SecurityException;
    }

    public static enum CheckMode {
        EXCEPTION_IN_NOT_SIGNED,
        WARN_IN_NOT_SIGNED,
        NONE_IN_NOT_SIGNED;

    }
}

