/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.serialize;

import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Objects;
import java.util.UUID;
import pro.gravit.utils.helper.IOHelper;

public final class HOutput
implements AutoCloseable,
Flushable {
    public final OutputStream stream;

    public HOutput(OutputStream stream) {
        this.stream = Objects.requireNonNull(stream, "stream");
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }

    @Override
    public void flush() throws IOException {
        this.stream.flush();
    }

    public void writeASCII(String s, int maxBytes) throws IOException {
        this.writeByteArray(IOHelper.encodeASCII(s), maxBytes);
    }

    public void writeBigInteger(BigInteger bi, int max) throws IOException {
        this.writeByteArray(bi.toByteArray(), max);
    }

    public void writeBoolean(boolean b) throws IOException {
        this.writeUnsignedByte(b ? 1 : 0);
    }

    public void writeByteArray(byte[] bytes, int max) throws IOException {
        this.writeLength(bytes.length, max);
        this.stream.write(bytes);
    }

    public void writeInt(int i) throws IOException {
        this.writeUnsignedByte(i >>> 24 & 0xFF);
        this.writeUnsignedByte(i >>> 16 & 0xFF);
        this.writeUnsignedByte(i >>> 8 & 0xFF);
        this.writeUnsignedByte(i & 0xFF);
    }

    public void writeLength(int length, int max) throws IOException {
        IOHelper.verifyLength(length, max);
        if (max >= 0) {
            this.writeVarInt(length);
        }
    }

    public void writeLong(long l) throws IOException {
        this.writeInt((int)(l >> 32));
        this.writeInt((int)l);
    }

    public void writeShort(short s) throws IOException {
        this.writeUnsignedByte(s >>> 8 & 0xFF);
        this.writeUnsignedByte(s & 0xFF);
    }

    public void writeString(String s, int maxBytes) throws IOException {
        this.writeByteArray(IOHelper.encode(s), maxBytes);
    }

    public void writeUnsignedByte(int b) throws IOException {
        this.stream.write(b);
    }

    public void writeUUID(UUID uuid) throws IOException {
        this.writeLong(uuid.getMostSignificantBits());
        this.writeLong(uuid.getLeastSignificantBits());
    }

    public void writeVarInt(int i) throws IOException {
        while (((long)i & 0xFFFFFFFFFFFFFF80L) != 0L) {
            this.writeUnsignedByte(i & 0x7F | 0x80);
            i >>>= 7;
        }
        this.writeUnsignedByte(i);
    }

    public void writeVarLong(long l) throws IOException {
        while ((l & 0xFFFFFFFFFFFFFF80L) != 0L) {
            this.writeUnsignedByte((int)l & 0x7F | 0x80);
            l >>>= 7;
        }
        this.writeUnsignedByte((int)l);
    }
}

