/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.utils.helper;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Base64;
import java.util.LinkedList;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import pro.gravit.utils.command.CommandException;

public final class CommonHelper {
    private static ScriptEngineFactory nashornFactory;

    private CommonHelper() {
    }

    private static ScriptEngineFactory getEngineFactories(ScriptEngineManager manager) {
        for (ScriptEngineFactory fact : manager.getEngineFactories()) {
            if (!fact.getNames().contains("nashorn") && !fact.getNames().contains("Nashorn")) continue;
            return fact;
        }
        return null;
    }

    public static String low(String s) {
        return s.toLowerCase(Locale.US);
    }

    public static boolean multiMatches(Pattern[] pattern, String from) {
        for (Pattern p : pattern) {
            if (!p.matcher(from).matches()) continue;
            return true;
        }
        return false;
    }

    public static String multiReplace(Pattern[] pattern, String from, String replace) {
        String tmp = null;
        for (Pattern p : pattern) {
            Matcher m = p.matcher(from);
            if (!m.matches()) continue;
            tmp = m.replaceAll(replace);
        }
        return tmp != null ? tmp : from;
    }

    public static ScriptEngine newScriptEngine() {
        if (nashornFactory == null) {
            throw new UnsupportedOperationException("ScriptEngine not supported");
        }
        return nashornFactory.getScriptEngine();
    }

    public static Thread newThread(String name, boolean daemon, Runnable runnable) {
        Thread thread = new Thread(runnable);
        thread.setDaemon(daemon);
        if (name != null) {
            thread.setName(name);
        }
        return thread;
    }

    public static String replace(String source, String ... params) {
        for (int i = 0; i < params.length; i += 2) {
            source = source.replace('%' + params[i] + '%', params[i + 1]);
        }
        return source;
    }

    public static String[] parseCommand(CharSequence line) throws CommandException {
        boolean quoted = false;
        boolean wasQuoted = false;
        LinkedList<String> result = new LinkedList<String>();
        StringBuilder builder = new StringBuilder(100);
        block4: for (int i = 0; i <= line.length(); ++i) {
            char ch;
            boolean end = i >= line.length();
            char c = ch = end ? (char)'\u0000' : line.charAt(i);
            if (end || !quoted && Character.isWhitespace(ch)) {
                if (end && quoted) {
                    throw new CommandException("Quotes wasn't closed");
                }
                if (wasQuoted || builder.length() > 0) {
                    result.add(builder.toString());
                }
                wasQuoted = false;
                builder.setLength(0);
                continue;
            }
            switch (ch) {
                case '\"': {
                    quoted = !quoted;
                    wasQuoted = true;
                    continue block4;
                }
                case '\\': {
                    if (i + 1 >= line.length()) {
                        throw new CommandException("Escape character is not specified");
                    }
                    char next = line.charAt(i + 1);
                    builder.append(next);
                    ++i;
                    continue block4;
                }
                default: {
                    builder.append(ch);
                }
            }
        }
        return result.toArray(new String[0]);
    }

    public static GsonBuilder newBuilder() {
        return new GsonBuilder().registerTypeHierarchyAdapter(byte[].class, (Object)ByteArrayToBase64TypeAdapter.INSTANCE);
    }

    static {
        try {
            ScriptEngineManager scriptManager = new ScriptEngineManager();
            nashornFactory = CommonHelper.getEngineFactories(scriptManager);
        }
        catch (Throwable e) {
            nashornFactory = null;
        }
    }

    private static class ByteArrayToBase64TypeAdapter
    implements JsonSerializer<byte[]>,
    JsonDeserializer<byte[]> {
        private static final ByteArrayToBase64TypeAdapter INSTANCE = new ByteArrayToBase64TypeAdapter();
        private final Base64.Decoder decoder = Base64.getUrlDecoder();
        private final Base64.Encoder encoder = Base64.getUrlEncoder();

        private ByteArrayToBase64TypeAdapter() {
        }

        public byte[] deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonArray()) {
                JsonArray byteArr = json.getAsJsonArray();
                byte[] arr = new byte[byteArr.size()];
                for (int i = 0; i < arr.length; ++i) {
                    arr[i] = byteArr.get(i).getAsByte();
                }
                return arr;
            }
            return this.decoder.decode(json.getAsString());
        }

        public JsonElement serialize(byte[] src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(this.encoder.encodeToString(src));
        }
    }
}

