/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.serialize.signed;

import java.io.IOException;
import java.security.SignatureException;
import java.util.Arrays;
import pro.gravit.launcher.serialize.HInput;
import pro.gravit.launcher.serialize.HOutput;
import pro.gravit.launcher.serialize.stream.StreamObject;
import pro.gravit.utils.helper.SecurityHelper;

public class DigestBytesHolder
extends StreamObject {
    protected final byte[] bytes;
    private final byte[] digest;

    public DigestBytesHolder(byte[] bytes, byte[] digest, SecurityHelper.DigestAlgorithm algorithm) throws SignatureException {
        if (Arrays.equals(SecurityHelper.digest(algorithm, bytes), digest)) {
            throw new SignatureException("Invalid digest");
        }
        this.bytes = (byte[])bytes.clone();
        this.digest = (byte[])digest.clone();
    }

    public DigestBytesHolder(byte[] bytes, SecurityHelper.DigestAlgorithm algorithm) {
        this.bytes = (byte[])bytes.clone();
        this.digest = SecurityHelper.digest(algorithm, bytes);
    }

    public DigestBytesHolder(HInput input, SecurityHelper.DigestAlgorithm algorithm) throws IOException, SignatureException {
        this(input.readByteArray(0), input.readByteArray(-256), algorithm);
    }

    public final byte[] getBytes() {
        return (byte[])this.bytes.clone();
    }

    public final byte[] getDigest() {
        return (byte[])this.digest.clone();
    }

    @Override
    public final void write(HOutput output) throws IOException {
        output.writeByteArray(this.bytes, 0);
        output.writeByteArray(this.digest, -256);
    }
}

