/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Path;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import pro.gravit.launcher.CertificatePinningTrustManager;
import pro.gravit.launcher.LauncherInject;
import pro.gravit.utils.helper.IOHelper;

public class AsyncDownloader {
    public static final Callback IGNORE = ignored -> {};
    @LauncherInject(value="launcher.certificatePinning")
    private static boolean isCertificatePinning;
    private static volatile SSLSocketFactory sslSocketFactory;
    private static volatile SSLContext sslContext;
    public final Callback callback;
    public volatile boolean isClosed;

    public AsyncDownloader(Callback callback) {
        this.callback = callback;
    }

    public AsyncDownloader() {
        this.callback = IGNORE;
    }

    public static SSLSocketFactory makeSSLSocketFactory() throws NoSuchAlgorithmException, CertificateException, KeyStoreException, IOException, KeyManagementException {
        if (sslSocketFactory != null) {
            return sslSocketFactory;
        }
        SSLContext sslContext = AsyncDownloader.makeSSLContext();
        sslSocketFactory = sslContext.getSocketFactory();
        return sslSocketFactory;
    }

    public static SSLContext makeSSLContext() throws NoSuchAlgorithmException, CertificateException, KeyStoreException, IOException, KeyManagementException {
        if (sslContext != null) {
            return sslContext;
        }
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(null, CertificatePinningTrustManager.getTrustManager().getTrustManagers(), new SecureRandom());
        return sslContext;
    }

    public void downloadFile(URL url, Path target, long size) throws IOException {
        if (this.isClosed) {
            throw new IOException("Download interrupted");
        }
        URLConnection connection = url.openConnection();
        if (isCertificatePinning) {
            HttpsURLConnection connection1 = (HttpsURLConnection)connection;
            try {
                connection1.setSSLSocketFactory(AsyncDownloader.makeSSLSocketFactory());
            }
            catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                throw new IOException(e);
            }
        }
        try (InputStream input = connection.getInputStream();){
            this.transfer(input, target, size);
        }
    }

    public void downloadFile(URL url, Path target) throws IOException {
        URLConnection connection = url.openConnection();
        if (isCertificatePinning) {
            HttpsURLConnection connection1 = (HttpsURLConnection)connection;
            try {
                connection1.setSSLSocketFactory(AsyncDownloader.makeSSLSocketFactory());
            }
            catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                throw new IOException(e);
            }
        }
        try (InputStream input = connection.getInputStream();){
            IOHelper.transfer(input, target);
        }
    }

    public void downloadListInOneThread(List<SizedFile> files, String baseURL, Path targetDir) throws URISyntaxException, IOException {
        URI baseUri = new URI(baseURL);
        String scheme = baseUri.getScheme();
        String host = baseUri.getHost();
        int port = baseUri.getPort();
        if (port != -1) {
            host = host + ":" + port;
        }
        String path = baseUri.getPath();
        for (SizedFile currentFile : files) {
            URL url = new URI(scheme, host, path + currentFile.urlPath, "", "").toURL();
            this.downloadFile(url, targetDir.resolve(currentFile.filePath), currentFile.size);
        }
    }

    public void downloadListInOneThreadSimple(List<SizedFile> files, String baseURL, Path targetDir) throws IOException {
        for (SizedFile currentFile : files) {
            this.downloadFile(new URL(baseURL + currentFile.urlPath), targetDir.resolve(currentFile.filePath), currentFile.size);
        }
    }

    public List<List<SizedFile>> sortFiles(List<SizedFile> files, int threads) {
        files.sort(Comparator.comparingLong(f -> -f.size));
        ArrayList<List<SizedFile>> result = new ArrayList<List<SizedFile>>();
        for (int i = 0; i < threads; ++i) {
            result.add(new LinkedList());
        }
        long[] sizes = new long[threads];
        Arrays.fill(sizes, 0L);
        for (SizedFile sizedFile : files) {
            long min = Long.MAX_VALUE;
            int minIndex = 0;
            for (int i = 0; i < threads; ++i) {
                if (sizes[i] >= min) continue;
                min = sizes[i];
                minIndex = i;
            }
            ((List)result.get(minIndex)).add(sizedFile);
            int n = minIndex;
            sizes[n] = sizes[n] + sizedFile.size;
        }
        for (List list : result) {
            Collections.shuffle(list);
        }
        return result;
    }

    public CompletableFuture[] runDownloadList(List<List<SizedFile>> files, String baseURL, Path targetDir, Executor executor) {
        int threads = files.size();
        CompletableFuture[] futures = new CompletableFuture[threads];
        for (int i = 0; i < threads; ++i) {
            List<SizedFile> currentTasks = files.get(i);
            futures[i] = CompletableFuture.runAsync(() -> {
                try {
                    this.downloadListInOneThread(currentTasks, baseURL, targetDir);
                }
                catch (IOException | URISyntaxException e) {
                    throw new CompletionException(e);
                }
            }, executor);
        }
        return futures;
    }

    public CompletableFuture[] runDownloadListSimple(List<List<SizedFile>> files, String baseURL, Path targetDir, Executor executor) {
        int threads = files.size();
        CompletableFuture[] futures = new CompletableFuture[threads];
        for (int i = 0; i < threads; ++i) {
            List<SizedFile> currentTasks = files.get(i);
            futures[i] = CompletableFuture.runAsync(() -> {
                try {
                    this.downloadListInOneThreadSimple(currentTasks, baseURL, targetDir);
                }
                catch (IOException e) {
                    throw new CompletionException(e);
                }
            }, executor);
        }
        return futures;
    }

    public void transfer(InputStream input, Path file, long size) throws IOException {
        try (OutputStream fileOutput = IOHelper.newOutput(file);){
            int length;
            byte[] bytes = IOHelper.newBuffer();
            for (long downloaded = 0L; downloaded < size; downloaded += (long)length) {
                if (this.isClosed) {
                    throw new IOException("Download interrupted");
                }
                int remaining = (int)Math.min(size - downloaded, (long)bytes.length);
                length = input.read(bytes, 0, remaining);
                if (length < 0) {
                    throw new EOFException(String.format("%d bytes remaining", size - downloaded));
                }
                fileOutput.write(bytes, 0, length);
                this.callback.update(length);
            }
        }
    }

    @FunctionalInterface
    public static interface Callback {
        public void update(long var1);
    }

    public static class SizedFile {
        public final String urlPath;
        public final String filePath;
        public final long size;

        public SizedFile(String path, long size) {
            this.urlPath = path;
            this.filePath = path;
            this.size = size;
        }

        public SizedFile(String urlPath, String filePath, long size) {
            this.urlPath = urlPath;
            this.filePath = filePath;
            this.size = size;
        }
    }
}

