/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.utils;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import pro.gravit.launcher.AsyncDownloader;
import pro.gravit.launcher.LauncherInject;
import pro.gravit.utils.Downloader;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.LogHelper;

public class Downloader {
    @LauncherInject(value="launcher.certificatePinning")
    private static boolean isCertificatePinning;
    @LauncherInject(value="launcher.noHttp2")
    private static boolean isNoHttp2;
    protected final HttpClient client;
    protected final ExecutorService executor;
    protected final Queue<DownloadTask> tasks = new ConcurrentLinkedDeque();
    protected CompletableFuture<Void> future;

    protected Downloader(HttpClient client, ExecutorService executor) {
        this.client = client;
        this.executor = executor;
    }

    public static Downloader downloadList(List<AsyncDownloader.SizedFile> files, String baseURL, Path targetDir, DownloadCallback callback, ExecutorService executor, int threads) throws Exception {
        boolean closeExecutor = false;
        LogHelper.info("Download with Java 11+ HttpClient");
        if (executor == null) {
            executor = Executors.newWorkStealingPool(Math.min(3, threads));
            closeExecutor = true;
        }
        Downloader downloader = Downloader.newDownloader((ExecutorService)executor);
        downloader.future = downloader.downloadFiles(files, baseURL, targetDir, callback, executor, threads);
        if (closeExecutor) {
            ExecutorService finalExecutor = executor;
            downloader.future = downloader.future.thenAccept(e -> finalExecutor.shutdownNow());
        }
        return downloader;
    }

    public static Downloader newDownloader(ExecutorService executor) {
        if (executor == null) {
            throw new NullPointerException();
        }
        HttpClient.Builder builder = HttpClient.newBuilder().version(isNoHttp2 ? HttpClient.Version.HTTP_1_1 : HttpClient.Version.HTTP_2).followRedirects(HttpClient.Redirect.NORMAL).executor(executor);
        if (isCertificatePinning) {
            try {
                builder.sslContext(AsyncDownloader.makeSSLContext());
            }
            catch (Exception e) {
                throw new SecurityException(e);
            }
        }
        HttpClient client = builder.build();
        return new Downloader(client, executor);
    }

    public void cancel() {
        for (DownloadTask task : this.tasks) {
            if (task.isCompleted()) continue;
            task.cancel();
        }
        this.tasks.clear();
        this.executor.shutdownNow();
    }

    public boolean isCanceled() {
        return this.executor.isTerminated();
    }

    public CompletableFuture<Void> getFuture() {
        return this.future;
    }

    public CompletableFuture<Void> downloadFiles(List<AsyncDownloader.SizedFile> files, String baseURL, Path targetDir, DownloadCallback callback, ExecutorService executor, int threads) throws Exception {
        Consumer<HttpResponse> next;
        URI baseUri = new URI(baseURL);
        Collections.shuffle(files);
        ConcurrentLinkedDeque<AsyncDownloader.SizedFile> queue = new ConcurrentLinkedDeque<AsyncDownloader.SizedFile>(files);
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        AtomicInteger currentThreads = new AtomicInteger(threads);
        ConsumerObject consumerObject = new ConsumerObject();
        consumerObject.next = next = e -> {
            AsyncDownloader.SizedFile file;
            if (callback != null && e != null) {
                callback.onComplete((Path)e.body());
            }
            if ((file = (AsyncDownloader.SizedFile)queue.poll()) == null) {
                if (currentThreads.decrementAndGet() == 0) {
                    future.complete(null);
                }
                return;
            }
            try {
                DownloadTask task = this.sendAsync(file, baseUri, targetDir, callback);
                ((CompletableFuture)task.completableFuture.thenAccept(consumerObject.next)).exceptionally(ec -> {
                    future.completeExceptionally((Throwable)ec);
                    return null;
                });
            }
            catch (Exception exception) {
                LogHelper.error(exception);
                future.completeExceptionally(exception);
            }
        };
        for (int i = 0; i < threads; ++i) {
            next.accept(null);
        }
        return future;
    }

    protected DownloadTask sendAsync(AsyncDownloader.SizedFile file, URI baseUri, Path targetDir, DownloadCallback callback) throws Exception {
        IOHelper.createParentDirs(targetDir.resolve(file.filePath));
        ProgressTrackingBodyHandler bodyHandler = this.makeBodyHandler(targetDir.resolve(file.filePath), callback);
        CompletableFuture future = this.client.sendAsync(this.makeHttpRequest(baseUri, file.urlPath), bodyHandler);
        AtomicReference<Object> task = new AtomicReference<Object>(null);
        task.set(new DownloadTask(bodyHandler, null));
        this.tasks.add(task.get());
        ((DownloadTask)task.get()).completableFuture = future.thenApply(e -> {
            this.tasks.remove(task.get());
            return e;
        });
        return task.get();
    }

    protected HttpRequest makeHttpRequest(URI baseUri, String filePath) throws URISyntaxException {
        String scheme = baseUri.getScheme();
        Object host = baseUri.getHost();
        int port = baseUri.getPort();
        if (port != -1) {
            host = (String)host + ":" + port;
        }
        String path = baseUri.getPath();
        return HttpRequest.newBuilder().GET().uri(new URI(scheme, (String)host, path + filePath, "", "")).header("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/45.0.2454.85 Safari/537.36").build();
    }

    protected ProgressTrackingBodyHandler<Path> makeBodyHandler(Path file, DownloadCallback callback) {
        return new ProgressTrackingBodyHandler(HttpResponse.BodyHandlers.ofFile(file, StandardOpenOption.CREATE, StandardOpenOption.WRITE), callback);
    }

    public static interface DownloadCallback {
        public void apply(long var1);

        public void onComplete(Path var1);
    }
}

