/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.utils.launch;

import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.module.Configuration;
import java.lang.module.ModuleFinder;
import java.lang.module.ModuleReference;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import pro.gravit.utils.helper.HackHelper;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.helper.LogHelper;
import pro.gravit.utils.launch.ClassLoaderControl;
import pro.gravit.utils.launch.Launch;
import pro.gravit.utils.launch.LaunchOptions;
import pro.gravit.utils.launch.ModuleHacks;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class ModuleLaunch
implements Launch {
    private ModuleClassLoader moduleClassLoader;
    private Configuration configuration;
    private ModuleLayer.Controller controller;
    private ModuleFinder moduleFinder;
    private ModuleLayer layer;
    private MethodHandles.Lookup hackLookup;

    @Override
    public ClassLoaderControl init(List<Path> files, String nativePath, LaunchOptions options) {
        this.moduleClassLoader = new ModuleClassLoader((URL[])files.stream().map(e -> {
            try {
                return e.toUri().toURL();
            }
            catch (MalformedURLException ex) {
                throw new RuntimeException(ex);
            }
        }).toArray(URL[]::new), ClassLoader.getPlatformClassLoader());
        this.moduleClassLoader.nativePath = nativePath;
        if (options.enableHacks) {
            this.hackLookup = HackHelper.createHackLookup(ModuleLaunch.class);
        }
        if (options.moduleConf != null) {
            Module target;
            Module source;
            String pkg;
            String moduleName;
            String[] split;
            this.moduleFinder = ModuleFinder.of((Path[])options.moduleConf.modulePath.stream().map(x$0 -> Paths.get(x$0, new String[0])).map(Path::toAbsolutePath).toArray(Path[]::new));
            ModuleLayer bootLayer = ModuleLayer.boot();
            if (options.moduleConf.modules.contains("ALL-MODULE-PATH")) {
                Set<ModuleReference> set = this.moduleFinder.findAll();
                if (LogHelper.isDevEnabled()) {
                    for (ModuleReference m : set) {
                        LogHelper.dev("Found module %s in %s", m.descriptor().name(), m.location().map(URI::toString).orElse("unknown"));
                    }
                    LogHelper.dev("Found %d modules", set.size());
                }
                for (ModuleReference m : set) {
                    options.moduleConf.modules.add(m.descriptor().name());
                }
                options.moduleConf.modules.remove("ALL-MODULE-PATH");
            }
            this.configuration = bootLayer.configuration().resolveAndBind(this.moduleFinder, ModuleFinder.of(new Path[0]), options.moduleConf.modules);
            this.controller = ModuleLayer.defineModulesWithOneLoader(this.configuration, List.of(bootLayer), this.moduleClassLoader);
            this.layer = this.controller.layer();
            for (Map.Entry<String, String> e2 : options.moduleConf.exports.entrySet()) {
                split = e2.getKey().split("/");
                moduleName = split[0];
                pkg = split[1];
                LogHelper.dev("Export module: %s package: %s to %s", moduleName, pkg, e2.getValue());
                source = this.layer.findModule(split[0]).orElse(null);
                if (source == null) {
                    throw new RuntimeException(String.format("Module %s not found", moduleName));
                }
                target = this.layer.findModule(e2.getValue()).orElse(null);
                if (target == null) {
                    throw new RuntimeException(String.format("Module %s not found", e2.getValue()));
                }
                if (options.enableHacks && source.getLayer() != this.layer) {
                    ModuleHacks.createController(this.hackLookup, source.getLayer()).addExports(source, pkg, target);
                    continue;
                }
                this.controller.addExports(source, pkg, target);
            }
            for (Map.Entry<String, String> e2 : options.moduleConf.opens.entrySet()) {
                split = e2.getKey().split("/");
                moduleName = split[0];
                pkg = split[1];
                LogHelper.dev("Open module: %s package: %s to %s", moduleName, pkg, e2.getValue());
                source = this.layer.findModule(split[0]).orElse(null);
                if (source == null) {
                    throw new RuntimeException(String.format("Module %s not found", moduleName));
                }
                target = this.layer.findModule(e2.getValue()).orElse(null);
                if (target == null) {
                    throw new RuntimeException(String.format("Module %s not found", e2.getValue()));
                }
                if (options.enableHacks && source.getLayer() != this.layer) {
                    ModuleHacks.createController(this.hackLookup, source.getLayer()).addOpens(source, pkg, target);
                    continue;
                }
                this.controller.addOpens(source, pkg, target);
            }
            for (Map.Entry<String, String> e2 : options.moduleConf.reads.entrySet()) {
                LogHelper.dev("Read module %s to %s", e2.getKey(), e2.getValue());
                Module source2 = this.layer.findModule(e2.getKey()).orElse(null);
                if (source2 == null) {
                    throw new RuntimeException(String.format("Module %s not found", e2.getKey()));
                }
                Module target2 = this.layer.findModule(e2.getValue()).orElse(null);
                if (target2 == null) {
                    throw new RuntimeException(String.format("Module %s not found", e2.getValue()));
                }
                if (options.enableHacks && source2.getLayer() != this.layer) {
                    ModuleHacks.createController(this.hackLookup, source2.getLayer()).addReads(source2, target2);
                    continue;
                }
                this.controller.addReads(source2, target2);
            }
        }
        return this.moduleClassLoader.makeControl();
    }

    @Override
    public void launch(String mainClass, String mainModuleName, Collection<String> args) throws Throwable {
        Thread.currentThread().setContextClassLoader(this.moduleClassLoader);
        if (mainModuleName == null) {
            Class<?> mainClazz = Class.forName(mainClass, true, this.moduleClassLoader);
            MethodHandle mainMethod = MethodHandles.lookup().findStatic(mainClazz, "main", MethodType.methodType(Void.TYPE, String[].class)).asFixedArity();
            JVMHelper.fullGC();
            mainMethod.asFixedArity().invokeWithArguments(new Object[]{args.toArray(new String[0])});
            return;
        }
        Module mainModule = this.layer.findModule(mainModuleName).orElseThrow();
        Module unnamed = ModuleLaunch.class.getClassLoader().getUnnamedModule();
        if (unnamed != null) {
            this.controller.addOpens(mainModule, ModuleLaunch.getPackageFromClass(mainClass), unnamed);
        }
        ClassLoader loader = mainModule.getClassLoader();
        Class<?> mainClazz = Class.forName(mainClass, true, loader);
        MethodHandle mainMethod = MethodHandles.lookup().findStatic(mainClazz, "main", MethodType.methodType(Void.TYPE, String[].class));
        mainMethod.asFixedArity().invokeWithArguments(new Object[]{args.toArray(new String[0])});
    }

    private static String getPackageFromClass(String clazz) {
        int index = clazz.lastIndexOf(".");
        if (index >= 0) {
            return clazz.substring(0, index);
        }
        return clazz;
    }

    private class ModuleClassLoader
    extends URLClassLoader {
        private final ClassLoader SYSTEM_CLASS_LOADER;
        private final List<ClassLoaderControl.ClassTransformer> transformers;
        private final Map<String, Class<?>> classMap;
        private String nativePath;
        private final List<String> packages;

        public ModuleClassLoader(URL[] urls, ClassLoader parent) {
            super("LAUNCHER", urls, parent);
            this.SYSTEM_CLASS_LOADER = ClassLoader.getSystemClassLoader();
            this.transformers = new ArrayList<ClassLoaderControl.ClassTransformer>();
            this.classMap = new ConcurrentHashMap();
            this.packages = new ArrayList<String>();
            this.packages.add("pro.gravit.launcher.");
            this.packages.add("pro.gravit.utils.");
        }

        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            if (name != null) {
                for (String pkg : this.packages) {
                    if (!name.startsWith(pkg)) continue;
                    return this.SYSTEM_CLASS_LOADER.loadClass(name);
                }
            }
            return super.loadClass(name, resolve);
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            Class<?> clazz = this.findClass(null, name);
            if (clazz == null) {
                throw new ClassNotFoundException(name);
            }
            return clazz;
        }

        @Override
        protected Class<?> findClass(String moduleName, String name) {
            Class<?> clazz = this.classMap.get(name);
            if (clazz != null) {
                return clazz;
            }
            if (name != null && !this.transformers.isEmpty()) {
                boolean needTransform = false;
                for (ClassLoaderControl.ClassTransformer t : this.transformers) {
                    if (!t.filter(moduleName, name)) continue;
                    needTransform = true;
                    break;
                }
                if (needTransform) {
                    String rawClassName = name.replace(".", "/").concat(".class");
                    try (InputStream input = this.getResourceAsStream(rawClassName);){
                        byte[] bytes = IOHelper.read(input);
                        for (ClassLoaderControl.ClassTransformer t : this.transformers) {
                            bytes = t.transform(moduleName, name, null, bytes);
                        }
                        clazz = this.defineClass(name, bytes, 0, bytes.length);
                    }
                    catch (IOException e) {
                        return null;
                    }
                }
            }
            if (clazz == null) {
                try {
                    clazz = super.findClass(name);
                }
                catch (ClassNotFoundException e) {
                    return null;
                }
            }
            if (clazz != null) {
                this.classMap.put(name, clazz);
                return clazz;
            }
            return null;
        }

        @Override
        public String findLibrary(String name) {
            return this.nativePath.concat(IOHelper.PLATFORM_SEPARATOR).concat(JVMHelper.NATIVE_PREFIX).concat(name).concat(JVMHelper.NATIVE_EXTENSION);
        }

        public void addAllowedPackage(String pkg) {
            this.packages.add(pkg);
        }

        private ModuleClassLoaderControl makeControl() {
            return new ModuleClassLoaderControl();
        }

        private class ModuleClassLoaderControl
        implements ClassLoaderControl {
            private ModuleClassLoaderControl() {
            }

            @Override
            public void addLauncherPackage(String prefix) {
                ModuleClassLoader.this.addAllowedPackage(prefix);
            }

            @Override
            public void addTransformer(ClassLoaderControl.ClassTransformer transformer) {
                ModuleClassLoader.this.transformers.add(transformer);
            }

            @Override
            public void addURL(URL url) {
                ModuleClassLoader.this.addURL(url);
            }

            @Override
            public void addJar(Path path) {
                try {
                    ModuleClassLoader.this.addURL(path.toUri().toURL());
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public URL[] getURLs() {
                return ModuleClassLoader.this.getURLs();
            }

            @Override
            public Class<?> getClass(String name) throws ClassNotFoundException {
                return Class.forName(name, false, ModuleClassLoader.this);
            }

            @Override
            public ClassLoader getClassLoader() {
                return ModuleClassLoader.this;
            }

            @Override
            public Object getJava9ModuleController() {
                return ModuleLaunch.this.controller;
            }

            @Override
            public MethodHandles.Lookup getHackLookup() {
                return ModuleLaunch.this.hackLookup;
            }
        }
    }
}

