/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.utils.helper;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.SecurityHelper;

public final class UnpackHelper {
    public static void unpack(URL resource, Path target) throws IOException {
        if (IOHelper.isFile(target) && UnpackHelper.matches(target, resource)) {
            return;
        }
        Files.deleteIfExists(target);
        IOHelper.createParentDirs(target);
        try (InputStream in = IOHelper.newInput(resource);){
            IOHelper.transfer(in, target);
        }
    }

    private static boolean matches(Path target, URL in) {
        try {
            return Arrays.equals(SecurityHelper.digest(SecurityHelper.DigestAlgorithm.SHA256, in), SecurityHelper.digest(SecurityHelper.DigestAlgorithm.SHA256, target));
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean unpackZipNoCheck(URL resource, Path target) throws IOException {
        if (Files.isDirectory(target, new LinkOption[0])) {
            return false;
        }
        Files.deleteIfExists(target);
        Files.createDirectory(target, new FileAttribute[0]);
        try (ZipInputStream input = IOHelper.newZipInput(resource);){
            ZipEntry entry = input.getNextEntry();
            while (entry != null) {
                if (!entry.isDirectory()) {
                    IOHelper.transfer((InputStream)input, target.resolve(IOHelper.toPath(entry.getName())));
                }
                entry = input.getNextEntry();
            }
        }
        return true;
    }

    public static void unpackZipNoCheck(String resource, Path target) throws IOException {
        try {
            if (Files.isDirectory(target, new LinkOption[0])) {
                return;
            }
            Files.deleteIfExists(target);
            Files.createDirectory(target, new FileAttribute[0]);
            try (ZipInputStream input = IOHelper.newZipInput(IOHelper.getResourceURL(resource));){
                ZipEntry entry = input.getNextEntry();
                while (entry != null) {
                    if (!entry.isDirectory()) {
                        IOHelper.transfer((InputStream)input, target.resolve(IOHelper.toPath(entry.getName())));
                    }
                    entry = input.getNextEntry();
                }
            }
        }
        catch (NoSuchFileException noSuchFileException) {
            // empty catch block
        }
    }
}

