/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.utils.launch;

import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import pro.gravit.utils.helper.HackHelper;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.launch.BasicLaunch;
import pro.gravit.utils.launch.ClassLoaderControl;
import pro.gravit.utils.launch.Launch;
import pro.gravit.utils.launch.LaunchOptions;

public class LegacyLaunch
implements Launch {
    private LegacyClassLoader legacyClassLoader;
    private MethodHandles.Lookup hackLookup;

    @Override
    public ClassLoaderControl init(List<Path> files, String nativePath, LaunchOptions options) {
        this.legacyClassLoader = new LegacyClassLoader((URL[])files.stream().map(e -> {
            try {
                return e.toUri().toURL();
            }
            catch (MalformedURLException ex) {
                throw new RuntimeException(ex);
            }
        }).toArray(URL[]::new), BasicLaunch.class.getClassLoader());
        this.legacyClassLoader.nativePath = nativePath;
        if (options.enableHacks) {
            this.hackLookup = HackHelper.createHackLookup(BasicLaunch.class);
        }
        return this.legacyClassLoader.makeControl();
    }

    @Override
    public void launch(String mainClass, String mainModule, Collection<String> args) throws Throwable {
        Thread.currentThread().setContextClassLoader(this.legacyClassLoader);
        Class<?> mainClazz = Class.forName(mainClass, true, this.legacyClassLoader);
        MethodHandle mainMethod = MethodHandles.lookup().findStatic(mainClazz, "main", MethodType.methodType(Void.TYPE, String[].class)).asFixedArity();
        JVMHelper.fullGC();
        mainMethod.asFixedArity().invokeWithArguments(new Object[]{args.toArray(new String[0])});
    }

    private class LegacyClassLoader
    extends URLClassLoader {
        private final ClassLoader SYSTEM_CLASS_LOADER;
        private final List<ClassLoaderControl.ClassTransformer> transformers;
        private final Map<String, Class<?>> classMap;
        private String nativePath;
        private final List<String> packages;

        public LegacyClassLoader(URL[] urls) {
            super(urls);
            this.SYSTEM_CLASS_LOADER = ClassLoader.getSystemClassLoader();
            this.transformers = new ArrayList<ClassLoaderControl.ClassTransformer>();
            this.classMap = new ConcurrentHashMap();
            this.packages = new ArrayList<String>();
            this.packages.add("pro.gravit.launcher.");
            this.packages.add("pro.gravit.utils.");
        }

        public LegacyClassLoader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
            this.SYSTEM_CLASS_LOADER = ClassLoader.getSystemClassLoader();
            this.transformers = new ArrayList<ClassLoaderControl.ClassTransformer>();
            this.classMap = new ConcurrentHashMap();
            this.packages = new ArrayList<String>();
        }

        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            if (name != null) {
                for (String pkg : this.packages) {
                    if (!name.startsWith(pkg)) continue;
                    return this.SYSTEM_CLASS_LOADER.loadClass(name);
                }
            }
            return super.loadClass(name, resolve);
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            Class<?> clazz = this.classMap.get(name);
            if (clazz != null) {
                return clazz;
            }
            if (name != null && !this.transformers.isEmpty()) {
                boolean needTransform = false;
                for (ClassLoaderControl.ClassTransformer t : this.transformers) {
                    if (!t.filter(null, name)) continue;
                    needTransform = true;
                    break;
                }
                if (needTransform) {
                    String rawClassName = name.replace(".", "/").concat(".class");
                    try (InputStream input = this.getResourceAsStream(rawClassName);){
                        byte[] bytes = IOHelper.read(input);
                        for (ClassLoaderControl.ClassTransformer t : this.transformers) {
                            bytes = t.transform(null, name, null, bytes);
                        }
                        clazz = this.defineClass(name, bytes, 0, bytes.length);
                    }
                    catch (IOException e) {
                        throw new ClassNotFoundException(name, e);
                    }
                }
            }
            if (clazz == null) {
                clazz = super.findClass(name);
            }
            if (clazz != null) {
                this.classMap.put(name, clazz);
                return clazz;
            }
            throw new ClassNotFoundException(name);
        }

        @Override
        public String findLibrary(String name) {
            return this.nativePath.concat(IOHelper.PLATFORM_SEPARATOR).concat(JVMHelper.NATIVE_PREFIX).concat(name).concat(JVMHelper.NATIVE_EXTENSION);
        }

        public void addAllowedPackage(String pkg) {
            this.packages.add(pkg);
        }

        private LegacyClassLoaderControl makeControl() {
            return new LegacyClassLoaderControl();
        }

        public class LegacyClassLoaderControl
        implements ClassLoaderControl {
            @Override
            public void addLauncherPackage(String prefix) {
                LegacyClassLoader.this.addAllowedPackage(prefix);
            }

            @Override
            public void addTransformer(ClassLoaderControl.ClassTransformer transformer) {
                LegacyClassLoader.this.transformers.add(transformer);
            }

            @Override
            public void addURL(URL url) {
                LegacyClassLoader.this.addURL(url);
            }

            @Override
            public void addJar(Path path) {
                try {
                    LegacyClassLoader.this.addURL(path.toUri().toURL());
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public URL[] getURLs() {
                return LegacyClassLoader.this.getURLs();
            }

            @Override
            public Class<?> getClass(String name) throws ClassNotFoundException {
                return Class.forName(name, false, LegacyClassLoader.this);
            }

            @Override
            public ClassLoader getClassLoader() {
                return LegacyClassLoader.this;
            }

            @Override
            public Object getJava9ModuleController() {
                return null;
            }

            @Override
            public MethodHandles.Lookup getHackLookup() {
                return LegacyLaunch.this.hackLookup;
            }
        }
    }
}

