/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.core.serialize.stream;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import pro.gravit.launcher.core.serialize.HInput;
import pro.gravit.launcher.core.serialize.HOutput;
import pro.gravit.utils.helper.VerifyHelper;

public final class EnumSerializer<E extends Enum<?>> {
    private final Map<Integer, E> map = new HashMap<Integer, E>(16);

    public EnumSerializer(Class<E> clazz) {
        for (Enum e : (Enum[])clazz.getEnumConstants()) {
            VerifyHelper.putIfAbsent(this.map, ((Itf)((Object)e)).getNumber(), e, "Duplicate number for enum constant " + e.name());
        }
    }

    public static void write(HOutput output, Itf itf) throws IOException {
        output.writeVarInt(itf.getNumber());
    }

    public E read(HInput input) throws IOException {
        int n = input.readVarInt();
        return (E)((Enum)VerifyHelper.getMapValue(this.map, n, "Unknown enum number: " + n));
    }

    @FunctionalInterface
    public static interface Itf {
        public int getNumber();
    }
}

