/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.utils;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public final class Version
implements Comparable<Version> {
    public static final int MAJOR = 5;
    public static final int MINOR = 6;
    public static final int PATCH = 8;
    public static final int BUILD = 1;
    public static final Type RELEASE = Type.STABLE;
    public final int major;
    public final int minor;
    public final int patch;
    public final int build;
    public final Type release;

    public Version(int major, int minor, int patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.build = 0;
        this.release = Type.UNKNOWN;
    }

    public Version(int major, int minor, int patch, int build) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.build = build;
        this.release = Type.UNKNOWN;
    }

    public Version(int major, int minor, int patch, int build, Type release) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.build = build;
        this.release = release;
    }

    public static Version of(int major, int minor, int patch) {
        return new Version(major, minor, patch);
    }

    public static Version of(int major, int minor, int patch, int build) {
        return new Version(major, minor, patch, build);
    }

    public static Version of(int major, int minor, int patch, int build, Type release) {
        return new Version(major, minor, patch, build, release);
    }

    public static Version getVersion() {
        return new Version(5, 6, 8, 1, RELEASE);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version that = (Version)o;
        return this.major == that.major && this.minor == that.minor && this.patch == that.patch && this.build == that.build;
    }

    public String getVersionString() {
        return String.format("%d.%d.%d", this.major, this.minor, this.patch);
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor, this.patch, this.build);
    }

    public String getReleaseStatus() {
        if (this.release.equals((Object)Type.UNKNOWN)) {
            return "";
        }
        return this.release.name().toLowerCase(Locale.ENGLISH);
    }

    public String toString() {
        return String.format("%d.%d.%d-%d %s", this.major, this.minor, this.patch, this.build, this.getReleaseStatus());
    }

    @Override
    public int compareTo(Version version) {
        if (version.major != this.major) {
            return Integer.compare(this.major, version.major);
        }
        if (version.minor != this.minor) {
            return Integer.compare(this.minor, version.minor);
        }
        if (version.patch != this.patch) {
            return Integer.compare(this.patch, version.patch);
        }
        return 0;
    }

    public boolean isUpperThan(Version version) {
        return this.compareTo(version) > 0;
    }

    public boolean isLowerThan(Version version) {
        return this.compareTo(version) < 0;
    }

    public static enum Type {
        LTS,
        STABLE,
        BETA,
        ALPHA,
        DEV,
        EXPERIMENTAL,
        UNKNOWN;

        private static final Map<String, Type> types;
        public static final Map<String, Type> unModTypes;

        static {
            types = new HashMap<String, Type>();
            unModTypes = Collections.unmodifiableMap(types);
            Arrays.asList(Type.values()).forEach(type -> types.put(type.name().substring(0, Math.min(type.name().length(), 3)).toLowerCase(Locale.ENGLISH), (Type)((Object)type)));
        }
    }
}

