/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.core;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import pro.gravit.launcher.core.LauncherInject;
import pro.gravit.utils.helper.LogHelper;

public class LauncherTrustManager {
    private final X509Certificate[] trustSigners;
    private final List<X509Certificate> trustCache = new ArrayList<X509Certificate>();
    @LauncherInject(value="launcher.certificatePinning")
    private static boolean isCertificatePinning;

    public LauncherTrustManager(X509Certificate[] trustSigners) {
        this.trustSigners = trustSigners;
        if (this.requireCustomTrustStore()) {
            this.injectCertificates();
        }
    }

    public LauncherTrustManager(List<byte[]> encodedCertificate) throws CertificateException {
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
        this.trustSigners = (X509Certificate[])encodedCertificate.stream().map(cert -> {
            X509Certificate x509Certificate;
            ByteArrayInputStream input = new ByteArrayInputStream((byte[])cert);
            try {
                x509Certificate = (X509Certificate)certFactory.generateCertificate(input);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((InputStream)input).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException | CertificateException e) {
                    LogHelper.error(e);
                    return null;
                }
            }
            ((InputStream)input).close();
            return x509Certificate;
        }).toArray(X509Certificate[]::new);
        if (this.requireCustomTrustStore()) {
            this.injectCertificates();
        }
    }

    private boolean requireCustomTrustStore() {
        return this.trustSigners != null && this.trustSigners.length != 0 && isCertificatePinning;
    }

    private void injectCertificates() {
        try {
            Map<String, Certificate> jdkTrustStore = LauncherTrustManager.getDefaultKeyStore();
            KeyStore mergedTrustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            mergedTrustStore.load(null, new char[0]);
            Arrays.stream(this.trustSigners).forEach(cert -> LauncherTrustManager.setCertificateEntry(mergedTrustStore, "injected-certificate" + String.valueOf(UUID.randomUUID()), cert));
            jdkTrustStore.keySet().forEach(key -> LauncherTrustManager.setCertificateEntry(mergedTrustStore, key, (Certificate)jdkTrustStore.get(key)));
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(mergedTrustStore);
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, trustManagerFactory.getTrustManagers(), null);
            HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
            LogHelper.info("Successfully injected certificates to truststore");
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            LogHelper.error("Error while modify existing keystore");
        }
    }

    private static Map<String, Certificate> getDefaultKeyStore() {
        HashMap<String, Certificate> jdkTrustStore = new HashMap<String, Certificate>();
        try {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            Path ksPath = Paths.get(System.getProperty("java.home"), "lib", "security", "cacerts");
            keyStore.load(Files.newInputStream(ksPath, new OpenOption[0]), "changeit".toCharArray());
            LauncherTrustManager.extractAllCertsAndPutInMap(keyStore, jdkTrustStore);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            LogHelper.warning("Error while loading existing keystore");
        }
        return jdkTrustStore;
    }

    private static void extractAllCertsAndPutInMap(KeyStore keyStore, Map<String, Certificate> placeToExport) {
        try {
            Collections.list(keyStore.aliases()).forEach(key -> LauncherTrustManager.extractCertAndPutInMap(keyStore, key, placeToExport));
        }
        catch (KeyStoreException e) {
            LogHelper.error("Error during extraction certificates from default keystore");
        }
    }

    private static void setCertificateEntry(KeyStore keyStore, String name, Certificate cert) {
        try {
            keyStore.setCertificateEntry(name, cert);
        }
        catch (KeyStoreException e) {
            LogHelper.warning("Something went wrong while adding certificate " + name);
        }
    }

    private static void extractCertAndPutInMap(KeyStore keyStoreFromExtract, String key, Map<String, Certificate> placeToExtract) {
        try {
            if (keyStoreFromExtract.containsAlias(key)) {
                placeToExtract.put(key, keyStoreFromExtract.getCertificate(key));
            }
        }
        catch (KeyStoreException e) {
            LogHelper.warning("Error while extracting certificate " + key);
        }
    }

    public CheckClassResult checkCertificates(X509Certificate[] certs, CertificateChecker checker) {
        if (certs == null) {
            return new CheckClassResult(CheckClassResultType.NOT_SIGNED, null, null);
        }
        X509Certificate rootCert = certs[certs.length - 1];
        X509Certificate endCert = certs[0];
        for (int i = 0; i < certs.length; ++i) {
            X509Certificate cert = certs[i];
            if (this.trustCache.contains(cert)) {
                this.trustCache.addAll(Arrays.asList(certs).subList(0, i));
                return new CheckClassResult(CheckClassResultType.SUCCESS, endCert, rootCert);
            }
            X509Certificate signer = i + 1 < certs.length ? certs[i + 1] : null;
            try {
                cert.checkValidity();
            }
            catch (Exception e) {
                return new CheckClassResult(CheckClassResultType.UNVERIFED, endCert, rootCert, e);
            }
            if (signer != null) {
                try {
                    cert.verify(signer.getPublicKey());
                }
                catch (Exception e) {
                    return new CheckClassResult(CheckClassResultType.UNVERIFED, endCert, rootCert, e);
                }
            }
            try {
                if (this.isTrusted(cert)) continue;
                return new CheckClassResult(CheckClassResultType.UNTRUSTED, endCert, rootCert);
            }
            catch (CertificateEncodingException e) {
                return new CheckClassResult(CheckClassResultType.UNVERIFED, endCert, rootCert, e);
            }
            try {
                checker.check(cert, signer, i);
                continue;
            }
            catch (Exception e) {
                return new CheckClassResult(CheckClassResultType.UNCOMPAT, endCert, rootCert, e);
            }
        }
        Collections.addAll(this.trustCache, certs);
        return new CheckClassResult(CheckClassResultType.SUCCESS, endCert, rootCert);
    }

    public void checkCertificatesSuccess(X509Certificate[] certs, CertificateChecker checker) throws Exception {
        CheckClassResult result = this.checkCertificates(certs, checker);
        if (result.type == CheckClassResultType.SUCCESS) {
            return;
        }
        if (result.exception != null) {
            throw result.exception;
        }
        throw new SecurityException(result.type.name());
    }

    public boolean isTrusted(X509Certificate certificate) throws CertificateEncodingException {
        for (X509Certificate cert : this.trustSigners) {
            if (!cert.getSerialNumber().equals(certificate.getSerialNumber()) || !Arrays.equals(cert.getEncoded(), certificate.getEncoded())) continue;
            return true;
        }
        return false;
    }

    public X509Certificate[] getTrusted() {
        return Arrays.copyOf(this.trustSigners, this.trustSigners.length);
    }

    public void isCertificateCodeSign(X509Certificate certificate) {
        try {
            List<String> extended = certificate.getExtendedKeyUsage();
            if (extended == null) {
                throw new SecurityException("Certificate extendedKeyUsage null");
            }
            boolean isCodeSign = false;
            for (String s : extended) {
                if (!s.equals("1.3.6.1.5.5.7.3.3")) continue;
                isCodeSign = true;
                break;
            }
            if (!isCodeSign) {
                throw new SecurityException("Certificate extendedKeyUsage codeSign checkFailed");
            }
        }
        catch (CertificateParsingException e) {
            throw new SecurityException(e);
        }
    }

    public void isCertificateCA(X509Certificate certificate) {
        if (certificate.getBasicConstraints() < 0) {
            throw new SecurityException("This certificate not CA");
        }
    }

    public void stdCertificateChecker(X509Certificate cert, X509Certificate signer, int number) {
        if (number == 0) {
            this.isCertificateCodeSign(cert);
        } else {
            this.isCertificateCA(cert);
        }
    }

    public static class CheckClassResult {
        public final CheckClassResultType type;
        public final X509Certificate endCertificate;
        public final X509Certificate rootCertificate;
        public final Exception exception;

        public CheckClassResult(CheckClassResultType type, X509Certificate endCertificate, X509Certificate rootCertificate) {
            this.type = type;
            this.endCertificate = endCertificate;
            this.rootCertificate = rootCertificate;
            this.exception = null;
        }

        public CheckClassResult(CheckClassResultType type, X509Certificate endCertificate, X509Certificate rootCertificate, Exception exception) {
            this.type = type;
            this.endCertificate = endCertificate;
            this.rootCertificate = rootCertificate;
            this.exception = exception;
        }

        public CheckClassResult(CheckClassResult orig) {
            this.type = orig.type;
            this.exception = orig.exception;
            this.rootCertificate = orig.rootCertificate;
            this.endCertificate = orig.endCertificate;
        }
    }

    public static enum CheckClassResultType {
        NOT_SIGNED,
        SUCCESS,
        UNTRUSTED,
        UNVERIFED,
        UNCOMPAT;

    }

    public static interface CertificateChecker {
        public void check(X509Certificate var1, X509Certificate var2, int var3) throws SecurityException;
    }
}

