/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher;

import java.io.IOException;
import java.util.StringJoiner;
import pro.gravit.launcher.LauncherAPI;
import pro.gravit.launcher.serialize.HInput;
import pro.gravit.launcher.serialize.HOutput;

public class ClientPermissions {
    public static final ClientPermissions DEFAULT = new ClientPermissions();
    @LauncherAPI
    public boolean canAdmin;
    @LauncherAPI
    public boolean canServer;
    @LauncherAPI
    public boolean canUSR1;
    @LauncherAPI
    public boolean canUSR2;
    @LauncherAPI
    public boolean canUSR3;
    @LauncherAPI
    public boolean canBot;

    public ClientPermissions(HInput input) throws IOException {
        this(input.readLong());
    }

    public ClientPermissions() {
        this.canAdmin = false;
        this.canServer = false;
        this.canUSR1 = false;
        this.canUSR2 = false;
        this.canUSR3 = false;
        this.canBot = false;
    }

    public ClientPermissions(long data) {
        this.canAdmin = (data & 1L) != 0L;
        this.canServer = (data & 2L) != 0L;
        this.canUSR1 = (data & 4L) != 0L;
        this.canUSR2 = (data & 8L) != 0L;
        this.canUSR3 = (data & 0x10L) != 0L;
        this.canBot = (data & 0x20L) != 0L;
    }

    @LauncherAPI
    public long toLong() {
        long result = 0L;
        result |= !this.canAdmin ? 0L : 1L;
        result |= !this.canServer ? 0L : 2L;
        result |= !this.canUSR1 ? 0L : 4L;
        result |= !this.canUSR2 ? 0L : 8L;
        result |= !this.canUSR3 ? 0L : 16L;
        return result |= !this.canBot ? 0L : 32L;
    }

    public static ClientPermissions getSuperuserAccount() {
        ClientPermissions perm = new ClientPermissions();
        perm.canServer = true;
        perm.canAdmin = true;
        return perm;
    }

    public void write(HOutput output) throws IOException {
        output.writeLong(this.toLong());
    }

    public String toString() {
        return new StringJoiner(", ", ClientPermissions.class.getSimpleName() + "[", "]").add("canAdmin=" + this.canAdmin).add("canServer=" + this.canServer).add("canUSR1=" + this.canUSR1).add("canUSR2=" + this.canUSR2).add("canUSR3=" + this.canUSR3).add("canBot=" + this.canBot).toString();
    }
}

