/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher;

import java.io.IOException;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import pro.gravit.launcher.AutogenConfig;
import pro.gravit.launcher.Launcher;
import pro.gravit.launcher.LauncherAPI;
import pro.gravit.launcher.serialize.HInput;
import pro.gravit.launcher.serialize.HOutput;
import pro.gravit.launcher.serialize.stream.StreamObject;
import pro.gravit.utils.helper.SecurityHelper;
import pro.gravit.utils.helper.VerifyHelper;

public final class LauncherConfig
extends StreamObject {
    private static final AutogenConfig config = new AutogenConfig();
    public String address;
    @LauncherAPI
    public final String projectname;
    public final int clientPort;
    public String secretKeyClient;
    public String oemUnlockKey;
    @LauncherAPI
    public final RSAPublicKey publicKey;
    @LauncherAPI
    public final Map<String, byte[]> runtime;
    public final boolean isWarningMissArchJava;
    public boolean isNettyEnabled;
    public LauncherEnvironment environment;
    public final String guardLicenseName;
    public final String guardLicenseKey;
    public final String guardLicenseEncryptKey;
    public final String guardType;
    public final String secureCheckHash;
    public final String secureCheckSalt;

    public static AutogenConfig getAutogenConfig() {
        return config;
    }

    @LauncherAPI
    public LauncherConfig(HInput input) throws IOException, InvalidKeySpecException {
        this.publicKey = SecurityHelper.toPublicRSAKey((byte[])input.readByteArray(2048));
        this.secureCheckHash = LauncherConfig.config.secureCheckHash;
        this.secureCheckSalt = LauncherConfig.config.secureCheckSalt;
        this.projectname = LauncherConfig.config.projectname;
        this.clientPort = LauncherConfig.config.clientPort;
        this.secretKeyClient = LauncherConfig.config.secretKeyClient;
        this.oemUnlockKey = LauncherConfig.config.oemUnlockKey;
        this.isWarningMissArchJava = LauncherConfig.config.isWarningMissArchJava;
        this.guardLicenseEncryptKey = LauncherConfig.config.guardLicenseEncryptKey;
        this.guardLicenseKey = LauncherConfig.config.guardLicenseKey;
        this.guardType = LauncherConfig.config.guardType;
        this.guardLicenseName = LauncherConfig.config.guardLicenseName;
        this.address = LauncherConfig.config.address;
        LauncherEnvironment env = LauncherConfig.config.env == 0 ? LauncherEnvironment.DEV : (LauncherConfig.config.env == 1 ? LauncherEnvironment.DEBUG : (LauncherConfig.config.env == 2 ? LauncherEnvironment.STD : (LauncherConfig.config.env == 3 ? LauncherEnvironment.PROD : LauncherEnvironment.STD)));
        Launcher.applyLauncherEnv(env);
        this.environment = env;
        int count = input.readLength(0);
        HashMap localResources = new HashMap(count);
        for (int i = 0; i < count; ++i) {
            String name = input.readString(255);
            VerifyHelper.putIfAbsent(localResources, (Object)name, (Object)input.readByteArray(2048), (String)String.format("Duplicate runtime resource: '%s'", name));
        }
        this.runtime = Collections.unmodifiableMap(localResources);
    }

    @LauncherAPI
    public LauncherConfig(String address, RSAPublicKey publicKey, Map<String, byte[]> runtime, String projectname) {
        this.address = address;
        this.publicKey = Objects.requireNonNull(publicKey, "publicKey");
        this.runtime = Collections.unmodifiableMap(new HashMap<String, byte[]>(runtime));
        this.projectname = projectname;
        this.clientPort = 32148;
        this.guardLicenseName = "FREE";
        this.guardLicenseKey = "AAAA-BBBB-CCCC-DDDD";
        this.guardLicenseEncryptKey = "12345";
        this.guardType = "no";
        this.isWarningMissArchJava = true;
        this.isNettyEnabled = false;
        this.environment = LauncherEnvironment.STD;
        this.secureCheckSalt = null;
        this.secureCheckHash = null;
    }

    @LauncherAPI
    public LauncherConfig(String address, RSAPublicKey publicKey, Map<String, byte[]> runtime) {
        this.address = address;
        this.publicKey = Objects.requireNonNull(publicKey, "publicKey");
        this.runtime = Collections.unmodifiableMap(new HashMap<String, byte[]>(runtime));
        this.projectname = "Minecraft";
        this.guardLicenseName = "FREE";
        this.guardLicenseKey = "AAAA-BBBB-CCCC-DDDD";
        this.guardLicenseEncryptKey = "12345";
        this.clientPort = 32148;
        this.guardType = "no";
        this.isWarningMissArchJava = true;
        this.isNettyEnabled = false;
        this.environment = LauncherEnvironment.STD;
        this.secureCheckSalt = null;
        this.secureCheckHash = null;
    }

    public void write(HOutput output) throws IOException {
        output.writeByteArray(this.publicKey.getEncoded(), 2048);
        Set<Map.Entry<String, byte[]>> entrySet = this.runtime.entrySet();
        output.writeLength(entrySet.size(), 0);
        for (Map.Entry<String, byte[]> entry : this.runtime.entrySet()) {
            output.writeString(entry.getKey(), 255);
            output.writeByteArray(entry.getValue(), 2048);
        }
    }

    public static enum LauncherEnvironment {
        DEV,
        DEBUG,
        STD,
        PROD;

    }
}

