/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.downloader;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntPredicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.http.HttpResponse;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.LaxRedirectStrategy;
import pro.gravit.utils.helper.CommonHelper;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.LogHelper;
import pro.gravit.utils.helper.VerifyHelper;

public class ListDownloader {
    private static final AtomicInteger COUNTER_THR = new AtomicInteger(0);
    private static final ThreadFactory FACTORY = r -> CommonHelper.newThread((String)("Downloader Thread #" + COUNTER_THR.incrementAndGet()), (boolean)true, (Runnable)r);

    private static ExecutorService newExecutor() {
        return new ThreadPoolExecutor(0, VerifyHelper.verifyInt((int)Integer.parseInt(System.getProperty("launcher.downloadThreads", "3")), (IntPredicate)VerifyHelper.POSITIVE, (String)"Thread max count must be positive."), 5L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), FACTORY);
    }

    public void download(String base, List<DownloadTask> applies, Path dstDirFile, DownloadCallback callback, DownloadTotalCallback totalCallback) throws IOException, URISyntaxException {
        try (CloseableHttpClient httpclient = HttpClients.custom().setUserAgent(IOHelper.USER_AGENT).setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy()).build();){
            applies.sort((a, b) -> Long.compare(a.size, b.size));
            ArrayList<Callable<Void>> toExec = new ArrayList<Callable<Void>>();
            URI baseUri = new URI(base);
            String scheme = baseUri.getScheme();
            String host = baseUri.getHost();
            int port = baseUri.getPort();
            if (port != -1) {
                host = host + ":" + port;
            }
            String path = baseUri.getPath();
            CopyOnWriteArrayList excs = new CopyOnWriteArrayList();
            for (DownloadTask apply : applies) {
                URI u = new URI(scheme, host, path + apply.apply, "", "");
                callback.stateChanged(apply.apply, 0L, apply.size);
                Path targetPath = dstDirFile.resolve(apply.apply);
                toExec.add(() -> {
                    if (LogHelper.isDebugEnabled()) {
                        LogHelper.debug((String)"Download URL: %s to file %s dir: %s", (Object[])new Object[]{u.toString(), targetPath.toAbsolutePath().toString(), dstDirFile.toAbsolutePath().toString()});
                    }
                    try {
                        httpclient.execute((HttpUriRequest)new HttpGet(u), (ResponseHandler)new FileDownloadResponseHandler(targetPath, apply, callback, totalCallback, false));
                    }
                    catch (IOException e) {
                        excs.add(e);
                    }
                    return null;
                });
            }
            try {
                ExecutorService e = ListDownloader.newExecutor();
                e.invokeAll(toExec);
                e.shutdown();
                e.awaitTermination(4L, TimeUnit.HOURS);
            }
            catch (InterruptedException t) {
                LogHelper.error((Throwable)t);
            }
            if (!excs.isEmpty()) {
                IOException toThrow = (IOException)excs.remove(0);
                excs.forEach(toThrow::addSuppressed);
                throw toThrow;
            }
        }
    }

    public void downloadZip(String base, List<DownloadTask> applies, Path dstDirFile, DownloadCallback callback, DownloadTotalCallback totalCallback, boolean fullDownload) throws IOException, URISyntaxException {
        try (ZipInputStream input = IOHelper.newZipInput((URL)new URL(base));){
            ZipEntry entry = input.getNextEntry();
            while (entry != null) {
                if (!entry.isDirectory()) {
                    String name = entry.getName();
                    callback.stateChanged(name, 0L, entry.getSize());
                    LogHelper.subInfo((String)"Downloading file: '%s'", (Object[])new Object[]{name});
                    if (fullDownload || applies.stream().anyMatch(t -> t.apply.equals(name))) {
                        Path fileName = IOHelper.toPath((String)name);
                        ListDownloader.transfer(input, dstDirFile.resolve(fileName), fileName.toString(), entry.getSize(), callback, totalCallback);
                    }
                }
                entry = input.getNextEntry();
            }
        }
    }

    public void downloadOne(String url, Path target) throws IOException, URISyntaxException {
        try (CloseableHttpClient httpclient = HttpClients.custom().setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy()).build();){
            URI u = new URL(url).toURI();
            if (LogHelper.isDebugEnabled()) {
                LogHelper.debug((String)"Download URL: %s", (Object[])new Object[]{u.toString()});
            }
            HttpGet get = new HttpGet(u);
            httpclient.execute((HttpUriRequest)get, (ResponseHandler)new FileDownloadResponseHandler(target.toAbsolutePath()));
        }
    }

    public static void transfer(InputStream input, Path file, String filename, long size, DownloadCallback callback, DownloadTotalCallback totalCallback) throws IOException {
        try (OutputStream fileOutput = IOHelper.newOutput((Path)file);){
            long downloaded = 0L;
            byte[] bytes = IOHelper.newBuffer();
            while (downloaded < size) {
                int remaining = (int)Math.min(size - downloaded, (long)bytes.length);
                int length = input.read(bytes, 0, remaining);
                if (length < 0) {
                    throw new EOFException(String.format("%d bytes remaining", size - downloaded));
                }
                fileOutput.write(bytes, 0, length);
                totalCallback.addTotal(length);
                callback.stateChanged(filename, downloaded += (long)length, size);
            }
        }
    }

    static class FileDownloadResponseHandler
    implements ResponseHandler<Path> {
        private final Path target;
        private final DownloadTask task;
        private final DownloadCallback callback;
        private final DownloadTotalCallback totalCallback;
        private final boolean zip;

        public FileDownloadResponseHandler(Path target) {
            this.target = target;
            this.task = null;
            this.zip = false;
            this.callback = null;
            this.totalCallback = null;
        }

        public FileDownloadResponseHandler(Path target, DownloadTask task, DownloadCallback callback, DownloadTotalCallback totalCallback, boolean zip) {
            this.target = target;
            this.task = task;
            this.callback = callback;
            this.totalCallback = totalCallback;
            this.zip = zip;
        }

        public FileDownloadResponseHandler(Path target, DownloadCallback callback, DownloadTotalCallback totalCallback, boolean zip) {
            this.target = target;
            this.task = null;
            this.callback = callback;
            this.totalCallback = totalCallback;
            this.zip = zip;
        }

        public Path handleResponse(HttpResponse response) throws IOException {
            InputStream source = response.getEntity().getContent();
            int returnCode = response.getStatusLine().getStatusCode();
            if (returnCode != 200) {
                throw new IllegalStateException(String.format("Request download file %s return code %d", this.target.toString(), returnCode));
            }
            long contentLength = response.getEntity().getContentLength();
            if (this.task != null && contentLength != this.task.size) {
                LogHelper.warning((String)"Missing content length: expected %d | found %d", (Object[])new Object[]{this.task.size, contentLength});
            }
            if (this.zip) {
                try (ZipInputStream input = IOHelper.newZipInput((InputStream)source);){
                    ZipEntry entry = input.getNextEntry();
                    while (entry != null) {
                        if (entry.isDirectory()) {
                            entry = input.getNextEntry();
                            continue;
                        }
                        long size = entry.getSize();
                        String filename = entry.getName();
                        Path target = this.target.resolve(filename);
                        if (this.callback != null) {
                            this.callback.stateChanged(entry.getName(), 0L, entry.getSize());
                        }
                        if (LogHelper.isDevEnabled()) {
                            LogHelper.dev((String)"Resolved filename %s to %s", (Object[])new Object[]{filename, target.toAbsolutePath().toString()});
                        }
                        ListDownloader.transfer(source, target, filename, size, this.callback, this.totalCallback);
                        entry = input.getNextEntry();
                    }
                }
                return null;
            }
            if (this.callback != null && this.task != null) {
                this.callback.stateChanged(this.task.apply, 0L, this.task.size);
                ListDownloader.transfer(source, this.target, this.task.apply, this.task.size, this.callback, this.totalCallback);
            } else {
                IOHelper.transfer((InputStream)source, (Path)this.target);
            }
            return this.target;
        }
    }

    public static class DownloadTask {
        public String apply;
        public long size;

        public DownloadTask(String apply, long size) {
            this.apply = apply;
            this.size = size;
        }
    }

    @FunctionalInterface
    public static interface DownloadTotalCallback {
        public void addTotal(long var1);
    }

    @FunctionalInterface
    public static interface DownloadCallback {
        public void stateChanged(String var1, long var2, long var4);
    }
}

