/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.hwid;

import com.google.gson.Gson;
import java.util.Objects;
import java.util.StringJoiner;
import pro.gravit.launcher.LauncherAPI;
import pro.gravit.launcher.hwid.HWID;

public class OshiHWID
implements HWID {
    public static Gson gson = new Gson();
    @LauncherAPI
    public long totalMemory = 0L;
    @LauncherAPI
    public String serialNumber;
    @LauncherAPI
    public String HWDiskSerial;
    @LauncherAPI
    public String processorID;
    @LauncherAPI
    public String macAddr;

    @Override
    public String getSerializeString() {
        return gson.toJson((Object)this);
    }

    @Override
    public int getLevel() {
        int result = 0;
        if (this.totalMemory != 0L) {
            result += 8;
        }
        if (this.serialNumber != null && !this.serialNumber.equals("unknown")) {
            result += 12;
        }
        if (this.HWDiskSerial != null && !this.HWDiskSerial.equals("unknown")) {
            result += 30;
        }
        if (this.processorID != null && !this.processorID.equals("unknown")) {
            result += 10;
        }
        if (this.macAddr != null && !this.macAddr.equals("00:00:00:00:00:00")) {
            result += 15;
        }
        return result;
    }

    @Override
    public int compare(HWID hwid) {
        if (hwid instanceof OshiHWID) {
            int rate = 0;
            OshiHWID oshi = (OshiHWID)hwid;
            if (Math.abs(oshi.totalMemory - this.totalMemory) < 0x100000L) {
                rate += 5;
            }
            if (oshi.totalMemory == this.totalMemory) {
                rate += 15;
            }
            if (oshi.HWDiskSerial.equals(this.HWDiskSerial)) {
                rate += 45;
            }
            if (oshi.processorID.equals(this.processorID)) {
                rate += 18;
            }
            if (oshi.serialNumber.equals(this.serialNumber)) {
                rate += 15;
            }
            if (!oshi.macAddr.isEmpty() && oshi.macAddr.equals(this.macAddr)) {
                rate += 19;
            }
            return rate;
        }
        return 0;
    }

    @Override
    public boolean isNull() {
        return this.getLevel() < 15;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OshiHWID oshiHWID = (OshiHWID)o;
        return this.totalMemory == oshiHWID.totalMemory && Objects.equals(this.serialNumber, oshiHWID.serialNumber) && Objects.equals(this.HWDiskSerial, oshiHWID.HWDiskSerial) && Objects.equals(this.processorID, oshiHWID.processorID) && Objects.equals(this.macAddr, oshiHWID.macAddr);
    }

    public int hashCode() {
        return Objects.hash(this.totalMemory, this.serialNumber, this.HWDiskSerial, this.processorID, this.macAddr);
    }

    public String toString() {
        return new StringJoiner(", ", OshiHWID.class.getSimpleName() + "[", "]").add("totalMemory=" + this.totalMemory).add("serialNumber='" + this.serialNumber + "'").add("HWDiskSerial='" + this.HWDiskSerial + "'").add("processorID='" + this.processorID + "'").add("macAddr='" + this.macAddr + "'").toString();
    }
}

