/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.profiles;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import pro.gravit.launcher.LauncherAPI;
import pro.gravit.launcher.hasher.FileNameMatcher;
import pro.gravit.launcher.hasher.HashedDir;
import pro.gravit.launcher.profiles.optional.OptionalDepend;
import pro.gravit.launcher.profiles.optional.OptionalFile;
import pro.gravit.launcher.profiles.optional.OptionalType;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.VerifyHelper;

public final class ClientProfile
implements Comparable<ClientProfile> {
    public static final boolean profileCaseSensitive = Boolean.getBoolean("launcher.clientProfile.caseSensitive");
    private static final FileNameMatcher ASSET_MATCHER = new FileNameMatcher(new String[0], new String[]{"indexes", "objects"}, new String[0]);
    @LauncherAPI
    private String version;
    @LauncherAPI
    private String assetIndex;
    @LauncherAPI
    private String dir;
    @LauncherAPI
    private String assetDir;
    @LauncherAPI
    private int sortIndex;
    @LauncherAPI
    private String title;
    @LauncherAPI
    private String info;
    @LauncherAPI
    private String serverAddress;
    @LauncherAPI
    private int serverPort;
    @LauncherAPI
    private final List<String> update = new ArrayList<String>();
    @LauncherAPI
    private final List<String> updateExclusions = new ArrayList<String>();
    @LauncherAPI
    private final List<String> updateShared = new ArrayList<String>();
    @LauncherAPI
    private final List<String> updateVerify = new ArrayList<String>();
    @LauncherAPI
    private final Set<OptionalFile> updateOptional = new HashSet<OptionalFile>();
    @LauncherAPI
    private boolean updateFastCheck;
    @LauncherAPI
    private boolean useWhitelist;
    @LauncherAPI
    private String mainClass;
    @LauncherAPI
    private final List<String> jvmArgs = new ArrayList<String>();
    @LauncherAPI
    private final List<String> classPath = new ArrayList<String>();
    @LauncherAPI
    private final List<String> clientArgs = new ArrayList<String>();
    @LauncherAPI
    private final List<String> whitelist = new ArrayList<String>();

    @Override
    public int compareTo(ClientProfile o) {
        return Integer.compare(this.getSortIndex(), o.getSortIndex());
    }

    @LauncherAPI
    public String getAssetIndex() {
        return this.assetIndex;
    }

    @LauncherAPI
    public FileNameMatcher getAssetUpdateMatcher() {
        return this.getVersion().compareTo(Version.MC1710) >= 0 ? ASSET_MATCHER : null;
    }

    @LauncherAPI
    public String[] getClassPath() {
        return this.classPath.toArray(new String[0]);
    }

    @LauncherAPI
    public String[] getClientArgs() {
        return this.clientArgs.toArray(new String[0]);
    }

    @LauncherAPI
    public String getDir() {
        return this.dir;
    }

    public void setDir(String dir) {
        this.dir = dir;
    }

    @LauncherAPI
    public String getAssetDir() {
        return this.assetDir;
    }

    @LauncherAPI
    public FileNameMatcher getClientUpdateMatcher() {
        String[] updateArray = this.update.toArray(new String[0]);
        String[] verifyArray = this.updateVerify.toArray(new String[0]);
        List<String> excludeList = this.updateExclusions;
        String[] exclusionsArray = excludeList.toArray(new String[0]);
        return new FileNameMatcher(updateArray, verifyArray, exclusionsArray);
    }

    @LauncherAPI
    public String[] getJvmArgs() {
        return this.jvmArgs.toArray(new String[0]);
    }

    @LauncherAPI
    public String getMainClass() {
        return this.mainClass;
    }

    @LauncherAPI
    public String getServerAddress() {
        return this.serverAddress;
    }

    @LauncherAPI
    public Set<OptionalFile> getOptional() {
        return this.updateOptional;
    }

    @LauncherAPI
    public void updateOptionalGraph() {
        for (OptionalFile file : this.updateOptional) {
            int i;
            if (file.dependenciesFile != null) {
                file.dependencies = new OptionalFile[file.dependenciesFile.length];
                for (i = 0; i < file.dependenciesFile.length; ++i) {
                    file.dependencies[i] = this.getOptionalFile(file.dependenciesFile[i].name, file.dependenciesFile[i].type);
                }
            }
            if (file.conflictFile == null) continue;
            file.conflict = new OptionalFile[file.conflictFile.length];
            for (i = 0; i < file.conflictFile.length; ++i) {
                file.conflict[i] = this.getOptionalFile(file.conflictFile[i].name, file.conflictFile[i].type);
            }
        }
    }

    @LauncherAPI
    public OptionalFile getOptionalFile(String file, OptionalType type) {
        for (OptionalFile f : this.updateOptional) {
            if (!f.type.equals((Object)type) || !f.name.equals(file)) continue;
            return f;
        }
        return null;
    }

    @LauncherAPI
    public Collection<String> getShared() {
        return this.updateShared;
    }

    @LauncherAPI
    public void markOptional(String name, OptionalType type) {
        OptionalFile file = this.getOptionalFile(name, type);
        if (file == null) {
            throw new SecurityException(String.format("Optional %s not found in optionalList", name));
        }
        this.markOptional(file);
    }

    @LauncherAPI
    public void markOptional(OptionalFile file) {
        if (file.mark) {
            return;
        }
        file.mark = true;
        if (file.dependencies != null) {
            for (OptionalFile dep : file.dependencies) {
                if (dep.dependenciesCount == null) {
                    dep.dependenciesCount = new HashSet<OptionalFile>();
                }
                dep.dependenciesCount.add(file);
                this.markOptional(dep);
            }
        }
        if (file.conflict != null) {
            for (OptionalFile conflict : file.conflict) {
                this.unmarkOptional(conflict);
            }
        }
    }

    @LauncherAPI
    public void unmarkOptional(String name, OptionalType type) {
        OptionalFile file = this.getOptionalFile(name, type);
        if (file == null) {
            throw new SecurityException(String.format("Optional %s not found in optionalList", name));
        }
        this.unmarkOptional(file);
    }

    @LauncherAPI
    public void unmarkOptional(OptionalFile file) {
        if (!file.mark) {
            return;
        }
        file.mark = false;
        if (file.dependenciesCount != null) {
            for (OptionalFile f : file.dependenciesCount) {
                if (f.isPreset) continue;
                this.unmarkOptional(f);
            }
            file.dependenciesCount.clear();
            file.dependenciesCount = null;
        }
        if (file.dependencies != null) {
            for (OptionalFile f : file.dependencies) {
                if (!f.mark) continue;
                if (f.dependenciesCount == null) {
                    this.unmarkOptional(f);
                    continue;
                }
                if (f.dependenciesCount.size() > 1) continue;
                f.dependenciesCount.clear();
                f.dependenciesCount = null;
                this.unmarkOptional(f);
            }
        }
    }

    public void pushOptionalFile(HashedDir dir, boolean digest) {
        for (OptionalFile opt : this.updateOptional) {
            if (!opt.type.equals((Object)OptionalType.FILE) || opt.mark) continue;
            for (String file : opt.list) {
                dir.removeR(file);
            }
        }
    }

    public void pushOptionalJvmArgs(Collection<String> jvmArgs1) {
        for (OptionalFile opt : this.updateOptional) {
            if (!opt.type.equals((Object)OptionalType.JVMARGS) || !opt.mark) continue;
            jvmArgs1.addAll(Arrays.asList(opt.list));
        }
    }

    public void pushOptionalClientArgs(Collection<String> clientArgs1) {
        for (OptionalFile opt : this.updateOptional) {
            if (!opt.type.equals((Object)OptionalType.CLIENTARGS) || !opt.mark) continue;
            clientArgs1.addAll(Arrays.asList(opt.list));
        }
    }

    public void pushOptionalClassPath(pushOptionalClassPathCallback callback) throws IOException {
        for (OptionalFile opt : this.updateOptional) {
            if (!opt.type.equals((Object)OptionalType.CLASSPATH) || !opt.mark) continue;
            callback.run(opt.list);
        }
    }

    @LauncherAPI
    public int getServerPort() {
        return this.serverPort;
    }

    @LauncherAPI
    public InetSocketAddress getServerSocketAddress() {
        return InetSocketAddress.createUnresolved(this.getServerAddress(), this.getServerPort());
    }

    @LauncherAPI
    public int getSortIndex() {
        return this.sortIndex;
    }

    @LauncherAPI
    public String getTitle() {
        return this.title;
    }

    @LauncherAPI
    public String getInfo() {
        return this.info;
    }

    @LauncherAPI
    public Version getVersion() {
        return Version.byName(this.version);
    }

    @LauncherAPI
    public boolean isUpdateFastCheck() {
        return this.updateFastCheck;
    }

    @LauncherAPI
    public boolean isWhitelistContains(String username) {
        if (!this.useWhitelist) {
            return true;
        }
        return this.whitelist.stream().anyMatch(profileCaseSensitive ? e -> e.equals(username) : e -> e.equalsIgnoreCase(username));
    }

    @LauncherAPI
    public void setTitle(String title) {
        this.title = title;
    }

    @LauncherAPI
    public void setInfo(String info) {
        this.info = info;
    }

    @LauncherAPI
    public void setVersion(Version version) {
        this.version = version.name;
    }

    public String toString() {
        return this.title;
    }

    @LauncherAPI
    public void verify() {
        this.getVersion();
        IOHelper.verifyFileName((String)this.getAssetIndex());
        VerifyHelper.verify((Object)this.getTitle(), (Predicate)VerifyHelper.NOT_EMPTY, (String)"Profile title can't be empty");
        VerifyHelper.verify((Object)this.getInfo(), (Predicate)VerifyHelper.NOT_EMPTY, (String)"Profile info can't be empty");
        VerifyHelper.verify((Object)this.getServerAddress(), (Predicate)VerifyHelper.NOT_EMPTY, (String)"Server address can't be empty");
        VerifyHelper.verifyInt((int)this.getServerPort(), (IntPredicate)VerifyHelper.range((int)0, (int)65535), (String)("Illegal server port: " + this.getServerPort()));
        VerifyHelper.verify((Object)this.getTitle(), (Predicate)VerifyHelper.NOT_EMPTY, (String)"Main class can't be empty");
        for (String s : this.update) {
            if (s != null) continue;
            throw new IllegalArgumentException("Found null entry in update");
        }
        for (String s : this.updateVerify) {
            if (s != null) continue;
            throw new IllegalArgumentException("Found null entry in updateVerify");
        }
        for (String s : this.updateExclusions) {
            if (s != null) continue;
            throw new IllegalArgumentException("Found null entry in updateExclusions");
        }
        for (String s : this.classPath) {
            if (s != null) continue;
            throw new IllegalArgumentException("Found null entry in classPath");
        }
        for (String s : this.jvmArgs) {
            if (s != null) continue;
            throw new IllegalArgumentException("Found null entry in jvmArgs");
        }
        for (String s : this.clientArgs) {
            if (s != null) continue;
            throw new IllegalArgumentException("Found null entry in clientArgs");
        }
        for (OptionalFile f : this.updateOptional) {
            if (f == null) {
                throw new IllegalArgumentException("Found null entry in updateOptional");
            }
            if (f.name == null) {
                throw new IllegalArgumentException("Optional: name must not be null");
            }
            if (f.list == null) {
                throw new IllegalArgumentException("Optional: list must not be null");
            }
            for (String string : f.list) {
                if (string != null) continue;
                throw new IllegalArgumentException(String.format("Found null entry in updateOptional.%s.list", f.name));
            }
            if (f.conflictFile != null) {
                for (OptionalDepend optionalDepend : f.conflictFile) {
                    if (optionalDepend != null) continue;
                    throw new IllegalArgumentException(String.format("Found null entry in updateOptional.%s.conflictFile", f.name));
                }
            }
            if (f.dependenciesFile == null) continue;
            for (OptionalDepend optionalDepend : f.dependenciesFile) {
                if (optionalDepend != null) continue;
                throw new IllegalArgumentException(String.format("Found null entry in updateOptional.%s.dependenciesFile", f.name));
            }
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.assetDir == null ? 0 : this.assetDir.hashCode());
        result = 31 * result + (this.assetIndex == null ? 0 : this.assetIndex.hashCode());
        result = 31 * result + (this.classPath == null ? 0 : this.classPath.hashCode());
        result = 31 * result + (this.clientArgs == null ? 0 : this.clientArgs.hashCode());
        result = 31 * result + (this.dir == null ? 0 : this.dir.hashCode());
        result = 31 * result + (this.jvmArgs == null ? 0 : this.jvmArgs.hashCode());
        result = 31 * result + (this.mainClass == null ? 0 : this.mainClass.hashCode());
        result = 31 * result + (this.serverAddress == null ? 0 : this.serverAddress.hashCode());
        result = 31 * result + this.serverPort;
        result = 31 * result + this.sortIndex;
        result = 31 * result + (this.title == null ? 0 : this.title.hashCode());
        result = 31 * result + (this.info == null ? 0 : this.info.hashCode());
        result = 31 * result + (this.update == null ? 0 : this.update.hashCode());
        result = 31 * result + (this.updateExclusions == null ? 0 : this.updateExclusions.hashCode());
        result = 31 * result + (this.updateFastCheck ? 1231 : 1237);
        result = 31 * result + (this.updateOptional == null ? 0 : this.updateOptional.hashCode());
        result = 31 * result + (this.updateShared == null ? 0 : this.updateShared.hashCode());
        result = 31 * result + (this.updateVerify == null ? 0 : this.updateVerify.hashCode());
        result = 31 * result + (this.useWhitelist ? 1231 : 1237);
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        result = 31 * result + (this.whitelist == null ? 0 : this.whitelist.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClientProfile other = (ClientProfile)obj;
        if (this.assetDir == null ? other.assetDir != null : !this.assetDir.equals(other.assetDir)) {
            return false;
        }
        if (this.assetIndex == null ? other.assetIndex != null : !this.assetIndex.equals(other.assetIndex)) {
            return false;
        }
        if (this.classPath == null ? other.classPath != null : !this.classPath.equals(other.classPath)) {
            return false;
        }
        if (this.clientArgs == null ? other.clientArgs != null : !this.clientArgs.equals(other.clientArgs)) {
            return false;
        }
        if (this.dir == null ? other.dir != null : !this.dir.equals(other.dir)) {
            return false;
        }
        if (this.jvmArgs == null ? other.jvmArgs != null : !this.jvmArgs.equals(other.jvmArgs)) {
            return false;
        }
        if (this.mainClass == null ? other.mainClass != null : !this.mainClass.equals(other.mainClass)) {
            return false;
        }
        if (this.serverAddress == null ? other.serverAddress != null : !this.serverAddress.equals(other.serverAddress)) {
            return false;
        }
        if (this.serverPort != other.serverPort) {
            return false;
        }
        if (this.sortIndex != other.sortIndex) {
            return false;
        }
        if (this.title == null ? other.title != null : !this.title.equals(other.title)) {
            return false;
        }
        if (this.info == null ? other.info != null : !this.info.equals(other.info)) {
            return false;
        }
        if (this.update == null ? other.update != null : !this.update.equals(other.update)) {
            return false;
        }
        if (this.updateExclusions == null ? other.updateExclusions != null : !this.updateExclusions.equals(other.updateExclusions)) {
            return false;
        }
        if (this.updateFastCheck != other.updateFastCheck) {
            return false;
        }
        if (this.updateOptional == null ? other.updateOptional != null : !this.updateOptional.equals(other.updateOptional)) {
            return false;
        }
        if (this.updateShared == null ? other.updateShared != null : !this.updateShared.equals(other.updateShared)) {
            return false;
        }
        if (this.updateVerify == null ? other.updateVerify != null : !this.updateVerify.equals(other.updateVerify)) {
            return false;
        }
        if (this.useWhitelist != other.useWhitelist) {
            return false;
        }
        if (this.version == null ? other.version != null : !this.version.equals(other.version)) {
            return false;
        }
        if (this.whitelist == null) {
            return other.whitelist == null;
        }
        return this.whitelist.equals(other.whitelist);
    }

    @FunctionalInterface
    public static interface pushOptionalClassPathCallback {
        public void run(String[] var1) throws IOException;
    }

    @LauncherAPI
    public static enum Version {
        MC125("1.2.5", 29),
        MC147("1.4.7", 51),
        MC152("1.5.2", 61),
        MC164("1.6.4", 78),
        MC172("1.7.2", 4),
        MC1710("1.7.10", 5),
        MC189("1.8.9", 47),
        MC19("1.9", 107),
        MC192("1.9.2", 109),
        MC194("1.9.4", 110),
        MC1102("1.10.2", 210),
        MC111("1.11", 315),
        MC1112("1.11.2", 316),
        MC112("1.12", 335),
        MC1121("1.12.1", 338),
        MC1122("1.12.2", 340),
        MC113("1.13", 393),
        MC1131("1.13.1", 401),
        MC1132("1.13.2", 402),
        MC114("1.14", 477),
        MC1141("1.14.1", 480),
        MC1142("1.14.2", 485),
        MC1143("1.14.3", 490),
        MC1144("1.14.4", 498);

        private static final Map<String, Version> VERSIONS;
        public final String name;
        public final int protocol;

        public static Version byName(String name) {
            return (Version)((Object)VerifyHelper.getMapValue(VERSIONS, (Object)name, (String)String.format("Unknown client version: '%s'", name)));
        }

        private Version(String name, int protocol) {
            this.name = name;
            this.protocol = protocol;
        }

        public String toString() {
            return "Minecraft " + this.name;
        }

        static {
            Version[] versionsValues = Version.values();
            VERSIONS = new HashMap<String, Version>(versionsValues.length);
            for (Version version : versionsValues) {
                VERSIONS.put(version.name, version);
            }
        }
    }
}

