/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.profiles;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Objects;
import pro.gravit.launcher.LauncherAPI;
import pro.gravit.launcher.serialize.HInput;
import pro.gravit.launcher.serialize.HOutput;
import pro.gravit.launcher.serialize.stream.StreamObject;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.SecurityHelper;

public final class Texture
extends StreamObject {
    private static final SecurityHelper.DigestAlgorithm DIGEST_ALGO = SecurityHelper.DigestAlgorithm.SHA256;
    @LauncherAPI
    public final String url;
    @LauncherAPI
    public final byte[] digest;

    @LauncherAPI
    public Texture(HInput input) throws IOException {
        this.url = IOHelper.verifyURL((String)input.readASCII(2048));
        this.digest = input.readByteArray(-Texture.DIGEST_ALGO.bytes);
    }

    @LauncherAPI
    public Texture(String url, boolean cloak) throws IOException {
        byte[] texture;
        this.url = IOHelper.verifyURL((String)url);
        try (InputStream input = IOHelper.newInput((URL)new URL(url));){
            texture = IOHelper.read((InputStream)input);
        }
        input = new ByteArrayInputStream(texture);
        var5_4 = null;
        try {
            IOHelper.readTexture((Object)input, (boolean)cloak);
        }
        catch (Throwable throwable) {
            var5_4 = throwable;
            throw throwable;
        }
        finally {
            if (input != null) {
                if (var5_4 != null) {
                    try {
                        ((ByteArrayInputStream)input).close();
                    }
                    catch (Throwable throwable) {
                        var5_4.addSuppressed(throwable);
                    }
                } else {
                    ((ByteArrayInputStream)input).close();
                }
            }
        }
        this.digest = SecurityHelper.digest((SecurityHelper.DigestAlgorithm)DIGEST_ALGO, (URL)new URL(url));
    }

    @LauncherAPI
    public Texture(String url, byte[] digest) {
        this.url = IOHelper.verifyURL((String)url);
        this.digest = Objects.requireNonNull(digest, "digest");
    }

    public void write(HOutput output) throws IOException {
        output.writeASCII(this.url, 2048);
        output.writeByteArray(this.digest, -Texture.DIGEST_ALGO.bytes);
    }
}

