/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.profiles.optional;

import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import pro.gravit.launcher.LauncherAPI;
import pro.gravit.launcher.profiles.optional.OptionalDepend;
import pro.gravit.launcher.profiles.optional.OptionalType;
import pro.gravit.launcher.serialize.HInput;
import pro.gravit.launcher.serialize.HOutput;
import pro.gravit.utils.helper.LogHelper;

public class OptionalFile {
    @LauncherAPI
    public String[] list;
    @LauncherAPI
    public OptionalType type;
    @LauncherAPI
    public boolean mark;
    @LauncherAPI
    public boolean visible = true;
    @LauncherAPI
    public String name;
    @LauncherAPI
    public String info;
    @LauncherAPI
    public OptionalDepend[] dependenciesFile;
    @LauncherAPI
    public OptionalDepend[] conflictFile;
    @LauncherAPI
    public transient OptionalFile[] dependencies;
    @LauncherAPI
    public transient OptionalFile[] conflict;
    @LauncherAPI
    public int subTreeLevel = 1;
    @LauncherAPI
    public boolean isPreset;
    @LauncherAPI
    public long permissions = 0L;
    @LauncherAPI
    public transient Set<OptionalFile> dependenciesCount;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OptionalFile that = (OptionalFile)o;
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    @LauncherAPI
    public OptionalType getType() {
        return OptionalType.FILE;
    }

    @LauncherAPI
    public String getName() {
        return this.name;
    }

    @LauncherAPI
    public boolean isVisible() {
        return this.visible;
    }

    @LauncherAPI
    public boolean isMark() {
        return this.mark;
    }

    @LauncherAPI
    public long getPermissions() {
        return this.permissions;
    }

    @LauncherAPI
    public void writeType(HOutput output) throws IOException {
        switch (this.type) {
            case FILE: {
                output.writeInt(1);
                break;
            }
            case CLASSPATH: {
                output.writeInt(2);
                break;
            }
            case JVMARGS: {
                output.writeInt(3);
                break;
            }
            case CLIENTARGS: {
                output.writeInt(4);
                break;
            }
            default: {
                output.writeInt(5);
            }
        }
    }

    @LauncherAPI
    public static OptionalType readType(HInput input) throws IOException {
        OptionalType type;
        int t = input.readInt();
        switch (t) {
            case 1: {
                type = OptionalType.FILE;
                break;
            }
            case 2: {
                type = OptionalType.CLASSPATH;
                break;
            }
            case 3: {
                type = OptionalType.JVMARGS;
                break;
            }
            case 4: {
                type = OptionalType.CLIENTARGS;
                break;
            }
            default: {
                LogHelper.error((String)"readType failed. Read int %d", (Object[])new Object[]{t});
                type = OptionalType.FILE;
            }
        }
        return type;
    }
}

