/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.request;

import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import pro.gravit.launcher.Launcher;
import pro.gravit.launcher.LauncherAPI;
import pro.gravit.launcher.LauncherNetworkAPI;
import pro.gravit.launcher.request.RequestException;
import pro.gravit.launcher.request.WebSocketEvent;
import pro.gravit.launcher.request.websockets.StandartClientWebSocketService;
import pro.gravit.launcher.request.websockets.WebSocketRequest;
import pro.gravit.utils.helper.SecurityHelper;

public abstract class Request<R extends WebSocketEvent>
implements WebSocketRequest {
    private static long session = SecurityHelper.secureRandom.nextLong();
    @LauncherNetworkAPI
    public UUID requestUUID = UUID.randomUUID();
    public static StandartClientWebSocketService service;
    private final transient AtomicBoolean started = new AtomicBoolean(false);

    public static void setSession(long session) {
        Request.session = session;
    }

    public static long getSession() {
        return session;
    }

    @LauncherAPI
    public static void requestError(String message) throws RequestException {
        throw new RequestException(message);
    }

    @LauncherAPI
    public R request() throws Exception {
        if (!this.started.compareAndSet(false, true)) {
            throw new IllegalStateException("Request already started");
        }
        if (service == null) {
            service = StandartClientWebSocketService.initWebSockets(Launcher.getConfig().address, false);
        }
        return this.requestDo(service);
    }

    @LauncherAPI
    public R request(StandartClientWebSocketService service) throws Exception {
        if (!this.started.compareAndSet(false, true)) {
            throw new IllegalStateException("Request already started");
        }
        return this.requestDo(service);
    }

    protected R requestDo(StandartClientWebSocketService service) throws Exception {
        return (R)service.sendRequest(this);
    }
}

