/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.managers;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.jar.JarFile;
import pro.gravit.launcher.modules.Module;
import pro.gravit.launcher.modules.ModuleContext;
import pro.gravit.launcher.modules.ModulesManager;
import pro.gravit.utils.PublicURLClassLoader;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.LogHelper;

public class SimpleModuleManager
implements ModulesManager {
    public ArrayList<Module> modules;
    public PublicURLClassLoader classloader;
    protected ModuleContext context;

    public void autoload(Path dir) throws IOException {
        LogHelper.info((String)"Load modules");
        if (Files.notExists(dir, new LinkOption[0])) {
            Files.createDirectory(dir, new FileAttribute[0]);
        } else {
            IOHelper.walk((Path)dir, (FileVisitor)new ModulesVisitor(), (boolean)true);
        }
        this.sort();
        LogHelper.info((String)"Loaded %d modules", (Object[])new Object[]{this.modules.size()});
    }

    @Override
    public void sort() {
        this.modules.sort((m1, m2) -> {
            int p1 = m1.getPriority();
            int p2 = m2.getPriority();
            return Integer.compare(p2, p1);
        });
    }

    @Override
    public void close() {
        for (Module m : this.modules) {
            try {
                m.close();
            }
            catch (Throwable t) {
                if (m.getName() != null) {
                    LogHelper.error((String)"Error in stopping module: %s", (Object[])new Object[]{m.getName()});
                } else {
                    LogHelper.error((String)"Error in stopping one of modules");
                }
                LogHelper.error((Throwable)t);
            }
        }
    }

    @Override
    public void initModules() {
        for (Module m : this.modules) {
            m.init(this.context);
            LogHelper.info((String)"Module %s version: %s init", (Object[])new Object[]{m.getName(), m.getVersion()});
        }
    }

    @Override
    public void load(Module module) {
        this.modules.add(module);
    }

    public void loadModuleFull(URL jarpath) throws ClassNotFoundException, IllegalAccessException, InstantiationException, URISyntaxException, IOException {
        try (JarFile f = new JarFile(Paths.get(jarpath.toURI()).toFile());){
            this.classloader.addURL(jarpath);
            Module module = (Module)Class.forName(f.getManifest().getMainAttributes().getValue("Main-Class"), true, (ClassLoader)this.classloader).newInstance();
            this.modules.add(module);
            module.preInit(this.context);
            module.init(this.context);
            module.postInit(this.context);
            module.finish(this.context);
            LogHelper.info((String)"Module %s version: %s loaded", (Object[])new Object[]{module.getName(), module.getVersion()});
        }
    }

    @Override
    public void loadModule(URL jarpath) throws Exception {
        try (JarFile f = new JarFile(Paths.get(jarpath.toURI()).toFile());){
            this.loadModule(jarpath, f.getManifest().getMainAttributes().getValue("Main-Class"));
        }
    }

    @Override
    public void loadModule(URL jarpath, String classname) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        this.classloader.addURL(jarpath);
        Module module = (Module)Class.forName(classname, true, (ClassLoader)this.classloader).newInstance();
        this.modules.add(module);
        LogHelper.info((String)"Module %s version: %s loaded", (Object[])new Object[]{module.getName(), module.getVersion()});
    }

    @Override
    public void postInitModules() {
        for (Module m : this.modules) {
            m.postInit(this.context);
            LogHelper.info((String)"Module %s version: %s post-init", (Object[])new Object[]{m.getName(), m.getVersion()});
        }
    }

    @Override
    public void preInitModules() {
        for (Module m : this.modules) {
            m.preInit(this.context);
            LogHelper.info((String)"Module %s version: %s pre-init", (Object[])new Object[]{m.getName(), m.getVersion()});
        }
    }

    @Override
    public void printModules() {
        for (Module m : this.modules) {
            LogHelper.info((String)"Module %s version: %s", (Object[])new Object[]{m.getName(), m.getVersion()});
        }
        LogHelper.info((String)"Loaded %d modules", (Object[])new Object[]{this.modules.size()});
    }

    @Override
    public void registerModule(Module module) {
        this.modules.add(module);
        LogHelper.info((String)"Module %s version: %s registered", (Object[])new Object[]{module.getName(), module.getVersion()});
    }

    @Override
    public void finishModules() {
        for (Module m : this.modules) {
            m.finish(this.context);
            LogHelper.info((String)"Module %s version: %s finished initialization", (Object[])new Object[]{m.getName(), m.getVersion()});
        }
    }

    protected final class ModulesVisitor
    extends SimpleFileVisitor<Path> {
        private ModulesVisitor() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            if (!file.toFile().getName().endsWith(".jar")) return super.visitFile(file, attrs);
            try (JarFile f = new JarFile(file.toFile());){
                String mainclass = f.getManifest().getMainAttributes().getValue("Main-Class");
                if (mainclass == null) {
                    LogHelper.error((String)"In module %s Main-Class not found", (Object[])new Object[]{file.toString()});
                    FileVisitResult fileVisitResult = super.visitFile(file, attrs);
                    return fileVisitResult;
                }
                SimpleModuleManager.this.loadModule(file.toUri().toURL(), mainclass);
                return super.visitFile(file, attrs);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                LogHelper.error((Throwable)e);
            }
            return super.visitFile(file, attrs);
        }
    }
}

