/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.request.auth;

import java.util.function.Predicate;
import pro.gravit.launcher.LauncherAPI;
import pro.gravit.launcher.LauncherNetworkAPI;
import pro.gravit.launcher.events.request.AuthRequestEvent;
import pro.gravit.launcher.hwid.HWID;
import pro.gravit.launcher.request.Request;
import pro.gravit.launcher.request.websockets.WebSocketRequest;
import pro.gravit.utils.helper.VerifyHelper;

public final class AuthRequest
extends Request<AuthRequestEvent>
implements WebSocketRequest {
    @LauncherNetworkAPI
    private final String login;
    @LauncherNetworkAPI
    private final byte[] encryptedPassword;
    @LauncherNetworkAPI
    private final String auth_id;
    @LauncherNetworkAPI
    private final HWID hwid;
    @LauncherNetworkAPI
    private final String customText;
    @LauncherNetworkAPI
    private final boolean getSession;
    @LauncherNetworkAPI
    private final ConnectTypes authType;
    @LauncherNetworkAPI
    public boolean initProxy;
    @LauncherNetworkAPI
    public String password;

    @LauncherAPI
    public AuthRequest(String login, byte[] password, HWID hwid) {
        this.login = (String)VerifyHelper.verify((Object)login, (Predicate)VerifyHelper.NOT_EMPTY, (String)"Login can't be empty");
        this.encryptedPassword = (byte[])password.clone();
        this.hwid = hwid;
        this.customText = "";
        this.auth_id = "";
        this.getSession = true;
        this.authType = ConnectTypes.CLIENT;
    }

    @LauncherAPI
    public AuthRequest(String login, byte[] password, HWID hwid, String auth_id) {
        this.login = (String)VerifyHelper.verify((Object)login, (Predicate)VerifyHelper.NOT_EMPTY, (String)"Login can't be empty");
        this.encryptedPassword = (byte[])password.clone();
        this.hwid = hwid;
        this.auth_id = auth_id;
        this.customText = "";
        this.getSession = true;
        this.authType = ConnectTypes.CLIENT;
    }

    @LauncherAPI
    public AuthRequest(String login, byte[] password, HWID hwid, String customText, String auth_id) {
        this.login = (String)VerifyHelper.verify((Object)login, (Predicate)VerifyHelper.NOT_EMPTY, (String)"Login can't be empty");
        this.encryptedPassword = (byte[])password.clone();
        this.hwid = hwid;
        this.auth_id = auth_id;
        this.customText = customText;
        this.getSession = true;
        this.authType = ConnectTypes.CLIENT;
    }

    public AuthRequest(String login, byte[] encryptedPassword, String auth_id, ConnectTypes authType) {
        this.login = login;
        this.encryptedPassword = encryptedPassword;
        this.auth_id = auth_id;
        this.authType = authType;
        this.hwid = null;
        this.customText = "";
        this.getSession = false;
    }

    public AuthRequest(String login, String password, String auth_id, ConnectTypes authType) {
        this.login = login;
        this.password = password;
        this.encryptedPassword = null;
        this.auth_id = auth_id;
        this.authType = authType;
        this.hwid = null;
        this.customText = "";
        this.getSession = false;
    }

    @Override
    public String getType() {
        return "auth";
    }

    public static enum ConnectTypes {
        SERVER,
        CLIENT,
        BOT,
        PROXY;

    }
}

