/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.request.uuid;

import java.io.IOException;
import pro.gravit.launcher.LauncherAPI;
import pro.gravit.launcher.LauncherNetworkAPI;
import pro.gravit.launcher.events.request.BatchProfileByUsernameRequestEvent;
import pro.gravit.launcher.request.Request;
import pro.gravit.launcher.request.websockets.WebSocketRequest;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.VerifyHelper;

public final class BatchProfileByUsernameRequest
extends Request<BatchProfileByUsernameRequestEvent>
implements WebSocketRequest {
    @LauncherNetworkAPI
    private final Entry[] list;

    @LauncherAPI
    public BatchProfileByUsernameRequest(String ... usernames) throws IOException {
        this.list = new Entry[usernames.length];
        for (int i = 0; i < usernames.length; ++i) {
            this.list[i].client = "";
            this.list[i].username = usernames[i];
        }
        IOHelper.verifyLength((int)usernames.length, (int)128);
        for (String username : usernames) {
            VerifyHelper.verifyUsername((String)username);
        }
    }

    @Override
    public String getType() {
        return "batchProfileByUsername";
    }

    class Entry {
        @LauncherNetworkAPI
        String username;
        @LauncherNetworkAPI
        String client;

        Entry() {
        }
    }
}

