/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.config;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Path;
import pro.gravit.launcher.Launcher;
import pro.gravit.launcher.LauncherAPI;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.LogHelper;

public abstract class JsonConfigurable<T> {
    private Type type;
    protected Path configPath;

    @LauncherAPI
    public void saveConfig() throws IOException {
        this.saveConfig(this.configPath);
    }

    @LauncherAPI
    public void loadConfig() throws IOException {
        this.loadConfig(this.configPath);
    }

    @LauncherAPI
    public JsonConfigurable(Type type, Path configPath) {
        this.type = type;
        this.configPath = configPath;
    }

    @LauncherAPI
    public void saveConfig(Path configPath) throws IOException {
        try (BufferedWriter writer = IOHelper.newWriter((Path)configPath);){
            Launcher.gsonManager.configGson.toJson(this.getConfig(), this.type, (Appendable)writer);
        }
    }

    @LauncherAPI
    public void loadConfig(Path configPath) throws IOException {
        if (this.generateConfigIfNotExists(configPath)) {
            return;
        }
        try (BufferedReader reader = IOHelper.newReader((Path)configPath);){
            this.setConfig(Launcher.gsonManager.configGson.fromJson((Reader)reader, this.type));
        }
        catch (Exception e) {
            LogHelper.error((Throwable)e);
            this.resetConfig(configPath);
        }
    }

    @LauncherAPI
    public void resetConfig() throws IOException {
        this.setConfig(this.getDefaultConfig());
        this.saveConfig();
    }

    @LauncherAPI
    public void resetConfig(Path newPath) throws IOException {
        this.setConfig(this.getDefaultConfig());
        this.saveConfig(newPath);
    }

    @LauncherAPI
    public boolean generateConfigIfNotExists(Path path) throws IOException {
        if (IOHelper.isFile((Path)path)) {
            return false;
        }
        this.resetConfig(path);
        return true;
    }

    @LauncherAPI
    public boolean generateConfigIfNotExists() throws IOException {
        if (IOHelper.isFile((Path)this.configPath)) {
            return false;
        }
        this.resetConfig();
        return true;
    }

    protected void setType(Type type) {
        this.type = type;
    }

    @LauncherAPI
    public abstract T getConfig();

    @LauncherAPI
    public abstract T getDefaultConfig();

    @LauncherAPI
    public abstract void setConfig(T var1);
}

