/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.modules.impl;

import java.io.IOException;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.jar.JarFile;
import pro.gravit.launcher.managers.SimpleModulesConfigManager;
import pro.gravit.launcher.modules.LauncherInitContext;
import pro.gravit.launcher.modules.LauncherModule;
import pro.gravit.launcher.modules.LauncherModuleInfo;
import pro.gravit.launcher.modules.LauncherModulesManager;
import pro.gravit.launcher.modules.ModulesConfigManager;
import pro.gravit.launcher.modules.impl.SimpleModuleContext;
import pro.gravit.utils.PublicURLClassLoader;
import pro.gravit.utils.Version;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.LogHelper;

public class SimpleModuleManager
implements LauncherModulesManager {
    protected final List<LauncherModule> modules = new ArrayList<LauncherModule>();
    protected final List<String> moduleNames = new ArrayList<String>();
    protected final SimpleModuleContext context;
    protected final ModulesConfigManager modulesConfigManager;
    protected final Path modulesDir;
    protected LauncherInitContext initContext;
    protected PublicURLClassLoader classLoader = new PublicURLClassLoader(new URL[0]);

    public void autoload() throws IOException {
        this.autoload(this.modulesDir);
    }

    public void autoload(Path dir) throws IOException {
        if (Files.notExists(dir, new LinkOption[0])) {
            Files.createDirectory(dir, new FileAttribute[0]);
        } else {
            IOHelper.walk((Path)dir, (FileVisitor)new ModulesVisitor(), (boolean)true);
        }
    }

    public void initModules(LauncherInitContext initContext) {
        boolean isAnyModuleLoad = true;
        this.modules.sort((m1, m2) -> {
            int priority1 = m1.getModuleInfo().priority;
            int priority2 = m2.getModuleInfo().priority;
            return Integer.compare(priority1, priority2);
        });
        while (isAnyModuleLoad) {
            isAnyModuleLoad = false;
            for (LauncherModule module : this.modules) {
                if (!module.getInitStatus().equals((Object)LauncherModule.InitStatus.INIT_WAIT) || !this.checkDepend(module)) continue;
                isAnyModuleLoad = true;
                module.setInitStatus(LauncherModule.InitStatus.INIT);
                module.init(initContext);
                module.setInitStatus(LauncherModule.InitStatus.FINISH);
            }
        }
        for (LauncherModule module : this.modules) {
            LauncherModuleInfo info;
            if (module.getInitStatus().equals((Object)LauncherModule.InitStatus.INIT_WAIT)) {
                info = module.getModuleInfo();
                LogHelper.warning((String)"Module %s required %s. Cyclic dependencies?", (Object[])new Object[]{info.name, Arrays.toString(info.dependencies)});
                module.setInitStatus(LauncherModule.InitStatus.INIT);
                module.init(initContext);
                module.setInitStatus(LauncherModule.InitStatus.FINISH);
                continue;
            }
            if (!module.getInitStatus().equals((Object)LauncherModule.InitStatus.PRE_INIT_WAIT)) continue;
            info = module.getModuleInfo();
            LogHelper.error((String)"Module %s skip pre-init phase. This module NOT finish loading", (Object[])new Object[]{info.name, Arrays.toString(info.dependencies)});
        }
    }

    private boolean checkDepend(LauncherModule module) {
        LauncherModuleInfo info = module.getModuleInfo();
        for (String dep : info.dependencies) {
            LauncherModule depModule = this.getModule(dep);
            if (depModule == null) {
                throw new RuntimeException(String.format("Module %s required %s. %s not found", info.name, dep, dep));
            }
            if (depModule.getInitStatus().equals((Object)LauncherModule.InitStatus.FINISH)) continue;
            return false;
        }
        return true;
    }

    public SimpleModuleManager(Path modulesDir, Path configDir) {
        this.modulesConfigManager = new SimpleModulesConfigManager(configDir);
        this.context = new SimpleModuleContext(this, this.modulesConfigManager);
        this.modulesDir = modulesDir;
    }

    @Override
    public LauncherModule loadModule(LauncherModule module) {
        if (this.modules.contains(module)) {
            return module;
        }
        this.modules.add(module);
        LauncherModuleInfo info = module.getModuleInfo();
        this.moduleNames.add(info.name);
        module.setContext(this.context);
        module.preInit();
        if (this.initContext != null) {
            module.setInitStatus(LauncherModule.InitStatus.INIT);
            module.init(this.initContext);
            module.setInitStatus(LauncherModule.InitStatus.FINISH);
        }
        return module;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public LauncherModule loadModule(Path file) throws IOException {
        try (JarFile f = new JarFile(file.toFile());){
            String moduleClass = f.getManifest().getMainAttributes().getValue("Module-Main-Class");
            if (moduleClass == null) {
                LogHelper.error((String)"In module %s Module-Main-Class not found", (Object[])new Object[]{file.toString()});
                LauncherModule launcherModule2 = null;
                return launcherModule2;
            }
            this.classLoader.addURL(file.toUri().toURL());
            LauncherModule module = (LauncherModule)Class.forName(moduleClass, true, (ClassLoader)this.classLoader).newInstance();
            this.loadModule(module);
            LauncherModule launcherModule = module;
            return launcherModule;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            LogHelper.error((Throwable)e);
            LogHelper.error((String)"In module %s Module-Main-Class incorrect", (Object[])new Object[]{file.toString()});
            return null;
        }
    }

    @Override
    public LauncherModule getModule(String name) {
        for (LauncherModule module : this.modules) {
            LauncherModuleInfo info = module.getModuleInfo();
            if (!info.name.equals(name) && (info.providers.length <= 0 || !Arrays.asList(info.providers).contains(name))) continue;
            return module;
        }
        return null;
    }

    @Override
    public LauncherModule getCoreModule() {
        return null;
    }

    @Override
    public ClassLoader getModuleClassLoader() {
        return this.classLoader;
    }

    @Override
    public <T extends LauncherModule> T getModule(Class<? extends T> clazz) {
        for (LauncherModule module : this.modules) {
            if (!clazz.isAssignableFrom(module.getClass())) continue;
            return (T)module;
        }
        return null;
    }

    @Override
    public <T> T getModuleByInterface(Class<T> clazz) {
        for (LauncherModule module : this.modules) {
            if (!clazz.isAssignableFrom(module.getClass())) continue;
            return (T)module;
        }
        return null;
    }

    @Override
    public <T> List<T> getModulesByInterface(Class<T> clazz) {
        ArrayList<LauncherModule> list = new ArrayList<LauncherModule>();
        for (LauncherModule module : this.modules) {
            if (!clazz.isAssignableFrom(module.getClass())) continue;
            list.add(module);
        }
        return list;
    }

    @Override
    public <T extends LauncherModule> T findModule(Class<? extends T> clazz, Predicate<Version> versionPredicate) {
        for (LauncherModule module : this.modules) {
            LauncherModuleInfo info = module.getModuleInfo();
            if (!versionPredicate.test(info.version) || !clazz.isAssignableFrom(module.getClass())) continue;
            return (T)module;
        }
        return null;
    }

    @Override
    public <T extends LauncherModule.Event> void invokeEvent(T event) {
        for (LauncherModule module : this.modules) {
            module.callEvent(event);
            if (!event.isCancel()) continue;
            return;
        }
    }

    protected final class ModulesVisitor
    extends SimpleFileVisitor<Path> {
        private ModulesVisitor() {
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            if (file.toFile().getName().endsWith(".jar")) {
                SimpleModuleManager.this.loadModule(file);
            }
            return super.visitFile(file, attrs);
        }
    }
}

