/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.request.update;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import pro.gravit.launcher.Launcher;
import pro.gravit.launcher.LauncherAPI;
import pro.gravit.launcher.LauncherNetworkAPI;
import pro.gravit.launcher.downloader.ListDownloader;
import pro.gravit.launcher.events.request.UpdateRequestEvent;
import pro.gravit.launcher.hasher.FileNameMatcher;
import pro.gravit.launcher.hasher.HashedDir;
import pro.gravit.launcher.hasher.HashedEntry;
import pro.gravit.launcher.hasher.HashedFile;
import pro.gravit.launcher.request.Request;
import pro.gravit.launcher.request.websockets.StandartClientWebSocketService;
import pro.gravit.launcher.request.websockets.WebSocketRequest;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.LogHelper;

public final class UpdateRequest
extends Request<UpdateRequestEvent>
implements WebSocketRequest {
    private static UpdateController controller;
    @LauncherNetworkAPI
    private final String dirName;
    private final transient Path dir;
    private final transient FileNameMatcher matcher;
    private final transient boolean digest;
    private volatile transient State.Callback stateCallback;
    private transient HashedDir localDir;
    private transient long totalDownloaded;
    private transient long totalSize;
    private transient Instant startTime;

    public static void setController(UpdateController controller) {
        UpdateRequest.controller = controller;
    }

    public static UpdateController getController() {
        return controller;
    }

    @Override
    public String getType() {
        return "update";
    }

    @Override
    public UpdateRequestEvent requestDo(StandartClientWebSocketService service) throws Exception {
        LogHelper.debug((String)"Start update request");
        UpdateRequestEvent e = (UpdateRequestEvent)service.sendRequest(this);
        if (controller != null) {
            controller.preUpdate(this, e);
        }
        LogHelper.debug((String)"Start update");
        Launcher.profile.pushOptionalFile(e.hdir, !Launcher.profile.isUpdateFastCheck());
        if (controller != null) {
            controller.preDiff(this, e);
        }
        HashedDir.Diff diff = e.hdir.diff(this.localDir, this.matcher);
        if (controller != null) {
            controller.postDiff(this, e, diff);
        }
        ArrayList<ListDownloader.DownloadTask> adds = new ArrayList<ListDownloader.DownloadTask>();
        if (controller != null) {
            controller.preDownload(this, e, adds);
        }
        diff.mismatch.walk((CharSequence)"/", (path, name, entry) -> {
            if (entry.getType().equals((Object)HashedEntry.Type.FILE)) {
                if (!entry.flag) {
                    HashedFile file = (HashedFile)entry;
                    this.totalSize += file.size;
                    adds.add(new ListDownloader.DownloadTask(path, file.size));
                }
            } else if (entry.getType().equals((Object)HashedEntry.Type.DIR)) {
                try {
                    Files.createDirectories(this.dir.resolve(path), new FileAttribute[0]);
                }
                catch (IOException ex) {
                    LogHelper.error((Throwable)ex);
                }
            }
            return HashedDir.WalkAction.CONTINUE;
        });
        this.totalSize = diff.mismatch.size();
        this.startTime = Instant.now();
        this.updateState("UnknownFile", 0L, 100L);
        ListDownloader listDownloader = new ListDownloader();
        LogHelper.info((String)"Download %s to %s", (Object[])new Object[]{this.dirName, this.dir.toAbsolutePath().toString()});
        if (e.zip && !adds.isEmpty()) {
            listDownloader.downloadZip(e.url, adds, this.dir, this::updateState, add -> this.totalDownloaded += add, e.fullDownload);
        } else {
            listDownloader.download(e.url, adds, this.dir, this::updateState, add -> this.totalDownloaded += add);
        }
        if (controller != null) {
            controller.postDownload(this, e);
        }
        this.deleteExtraDir(this.dir, diff.extra, diff.extra.flag);
        if (controller != null) {
            controller.postUpdate(this, e);
        }
        LogHelper.debug((String)"Update success");
        return e;
    }

    public Path getDir() {
        return this.dir;
    }

    @LauncherAPI
    public UpdateRequest(String dirName, Path dir, FileNameMatcher matcher, boolean digest) {
        this.dirName = IOHelper.verifyFileName((String)dirName);
        this.dir = Objects.requireNonNull(dir, "dir");
        this.matcher = matcher;
        this.digest = digest;
    }

    private void deleteExtraDir(Path subDir, HashedDir subHDir, boolean flag) throws IOException {
        block4: for (Map.Entry mapEntry : subHDir.map().entrySet()) {
            String name = (String)mapEntry.getKey();
            Path path = subDir.resolve(name);
            HashedEntry entry = (HashedEntry)mapEntry.getValue();
            HashedEntry.Type entryType = entry.getType();
            switch (entryType) {
                case FILE: {
                    this.updateState(IOHelper.toString((Path)path), 0L, 0L);
                    Files.delete(path);
                    continue block4;
                }
                case DIR: {
                    this.deleteExtraDir(path, (HashedDir)entry, flag || entry.flag);
                    continue block4;
                }
            }
            throw new AssertionError((Object)("Unsupported hashed entry type: " + entryType.name()));
        }
        if (flag) {
            this.updateState(IOHelper.toString((Path)subDir), 0L, 0L);
            Files.delete(subDir);
        }
    }

    @Override
    public UpdateRequestEvent request() throws Exception {
        Files.createDirectories(this.dir, new FileAttribute[0]);
        this.localDir = new HashedDir(this.dir, this.matcher, false, this.digest);
        return (UpdateRequestEvent)super.request();
    }

    @LauncherAPI
    public void setStateCallback(State.Callback callback) {
        this.stateCallback = callback;
    }

    private void updateState(String filePath, long fileDownloaded, long fileSize) {
        if (this.stateCallback != null) {
            this.stateCallback.call(new State(filePath, fileDownloaded, fileSize, this.totalDownloaded, this.totalSize, Duration.between(this.startTime, Instant.now())));
        }
    }

    public static final class State {
        @LauncherAPI
        public final long fileDownloaded;
        @LauncherAPI
        public final long fileSize;
        @LauncherAPI
        public final long totalDownloaded;
        @LauncherAPI
        public final long totalSize;
        @LauncherAPI
        public final String filePath;
        @LauncherAPI
        public final Duration duration;

        public State(String filePath, long fileDownloaded, long fileSize, long totalDownloaded, long totalSize, Duration duration) {
            this.filePath = filePath;
            this.fileDownloaded = fileDownloaded;
            this.fileSize = fileSize;
            this.totalDownloaded = totalDownloaded;
            this.totalSize = totalSize;
            this.duration = duration;
        }

        @LauncherAPI
        public double getBps() {
            long seconds = this.duration.getSeconds();
            if (seconds == 0L) {
                return -1.0;
            }
            return (double)this.totalDownloaded / (double)seconds;
        }

        @LauncherAPI
        public Duration getEstimatedTime() {
            double bps = this.getBps();
            if (bps <= 0.0) {
                return null;
            }
            return Duration.ofSeconds((long)((double)this.getTotalRemaining() / bps));
        }

        @LauncherAPI
        public double getFileDownloadedKiB() {
            return (double)this.fileDownloaded / 1024.0;
        }

        @LauncherAPI
        public double getFileDownloadedMiB() {
            return this.getFileDownloadedKiB() / 1024.0;
        }

        @LauncherAPI
        public double getFileDownloadedPart() {
            if (this.fileSize == 0L) {
                return 0.0;
            }
            return (double)this.fileDownloaded / (double)this.fileSize;
        }

        @LauncherAPI
        public long getFileRemaining() {
            return this.fileSize - this.fileDownloaded;
        }

        @LauncherAPI
        public double getFileRemainingKiB() {
            return (double)this.getFileRemaining() / 1024.0;
        }

        @LauncherAPI
        public double getFileRemainingMiB() {
            return this.getFileRemainingKiB() / 1024.0;
        }

        @LauncherAPI
        public double getFileSizeKiB() {
            return (double)this.fileSize / 1024.0;
        }

        @LauncherAPI
        public double getFileSizeMiB() {
            return this.getFileSizeKiB() / 1024.0;
        }

        @LauncherAPI
        public double getTotalDownloadedKiB() {
            return (double)this.totalDownloaded / 1024.0;
        }

        @LauncherAPI
        public double getTotalDownloadedMiB() {
            return this.getTotalDownloadedKiB() / 1024.0;
        }

        @LauncherAPI
        public double getTotalDownloadedPart() {
            if (this.totalSize == 0L) {
                return 0.0;
            }
            return (double)this.totalDownloaded / (double)this.totalSize;
        }

        @LauncherAPI
        public long getTotalRemaining() {
            return this.totalSize - this.totalDownloaded;
        }

        @LauncherAPI
        public double getTotalRemainingKiB() {
            return (double)this.getTotalRemaining() / 1024.0;
        }

        @LauncherAPI
        public double getTotalRemainingMiB() {
            return this.getTotalRemainingKiB() / 1024.0;
        }

        @LauncherAPI
        public double getTotalSizeKiB() {
            return (double)this.totalSize / 1024.0;
        }

        @LauncherAPI
        public double getTotalSizeMiB() {
            return this.getTotalSizeKiB() / 1024.0;
        }

        @FunctionalInterface
        public static interface Callback {
            @LauncherAPI
            public void call(State var1);
        }
    }

    public static interface UpdateController {
        public void preUpdate(UpdateRequest var1, UpdateRequestEvent var2) throws IOException;

        public void preDiff(UpdateRequest var1, UpdateRequestEvent var2) throws IOException;

        public void postDiff(UpdateRequest var1, UpdateRequestEvent var2, HashedDir.Diff var3) throws IOException;

        public void preDownload(UpdateRequest var1, UpdateRequestEvent var2, List<ListDownloader.DownloadTask> var3) throws IOException;

        public void postDownload(UpdateRequest var1, UpdateRequestEvent var2) throws IOException;

        public void postUpdate(UpdateRequest var1, UpdateRequestEvent var2) throws IOException;
    }
}

