/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.request.websockets;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.HashSet;
import javax.net.ssl.SSLException;
import pro.gravit.launcher.Launcher;
import pro.gravit.launcher.events.ExceptionEvent;
import pro.gravit.launcher.events.request.AuthRequestEvent;
import pro.gravit.launcher.events.request.BatchProfileByUsernameRequestEvent;
import pro.gravit.launcher.events.request.CheckServerRequestEvent;
import pro.gravit.launcher.events.request.ErrorRequestEvent;
import pro.gravit.launcher.events.request.ExecCommandRequestEvent;
import pro.gravit.launcher.events.request.GetAvailabilityAuthRequestEvent;
import pro.gravit.launcher.events.request.GetSecureTokenRequestEvent;
import pro.gravit.launcher.events.request.JoinServerRequestEvent;
import pro.gravit.launcher.events.request.LauncherRequestEvent;
import pro.gravit.launcher.events.request.LogEvent;
import pro.gravit.launcher.events.request.ProfileByUUIDRequestEvent;
import pro.gravit.launcher.events.request.ProfileByUsernameRequestEvent;
import pro.gravit.launcher.events.request.ProfilesRequestEvent;
import pro.gravit.launcher.events.request.RegisterRequestEvent;
import pro.gravit.launcher.events.request.RestoreSessionRequestEvent;
import pro.gravit.launcher.events.request.SetPasswordRequestEvent;
import pro.gravit.launcher.events.request.SetProfileRequestEvent;
import pro.gravit.launcher.events.request.UpdateListRequestEvent;
import pro.gravit.launcher.events.request.UpdateRequestEvent;
import pro.gravit.launcher.events.request.VerifySecureTokenRequestEvent;
import pro.gravit.launcher.hasher.HashedEntry;
import pro.gravit.launcher.hasher.HashedEntryAdapter;
import pro.gravit.launcher.request.WebSocketEvent;
import pro.gravit.launcher.request.websockets.ClientJSONPoint;
import pro.gravit.launcher.request.websockets.WebSocketRequest;
import pro.gravit.utils.ProviderMap;
import pro.gravit.utils.UniversalJsonAdapter;
import pro.gravit.utils.helper.LogHelper;

public class ClientWebSocketService
extends ClientJSONPoint {
    public final Gson gson;
    public OnCloseCallback onCloseCallback;
    public final Boolean onConnect;
    public ReconnectCallback reconnectCallback;
    public static ProviderMap<WebSocketEvent> results = new ProviderMap();
    public static ProviderMap<WebSocketRequest> requests = new ProviderMap();
    private HashSet<EventHandler> handlers = new HashSet();

    public ClientWebSocketService(String address) throws SSLException {
        super(ClientWebSocketService.createURL(address));
        this.gson = Launcher.gsonManager.gson;
        this.onConnect = true;
    }

    public static void appendTypeAdapters(GsonBuilder builder) {
        builder.registerTypeAdapter(HashedEntry.class, (Object)new HashedEntryAdapter());
        builder.registerTypeAdapter(WebSocketEvent.class, (Object)new UniversalJsonAdapter(results));
        builder.registerTypeAdapter(WebSocketRequest.class, (Object)new UniversalJsonAdapter(requests));
    }

    private static URI createURL(String address) {
        try {
            URI u = new URI(address);
            return u;
        }
        catch (Throwable e) {
            LogHelper.error((Throwable)e);
            return null;
        }
    }

    @Override
    void onMessage(String message) {
        WebSocketEvent result = (WebSocketEvent)this.gson.fromJson(message, WebSocketEvent.class);
        for (EventHandler handler : this.handlers) {
            handler.process(result);
        }
    }

    @Override
    void onDisconnect() {
        LogHelper.info((String)"WebSocket client disconnect");
        if (this.onCloseCallback != null) {
            this.onCloseCallback.onClose(0, "unsupported param", !this.isClosed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void onOpen() throws Exception {
        Boolean bl = this.onConnect;
        synchronized (bl) {
            this.onConnect.notifyAll();
        }
    }

    public void registerRequests() {
    }

    public void registerResults() {
        results.register("auth", AuthRequestEvent.class);
        results.register("checkServer", CheckServerRequestEvent.class);
        results.register("joinServer", JoinServerRequestEvent.class);
        results.register("launcher", LauncherRequestEvent.class);
        results.register("profileByUsername", ProfileByUsernameRequestEvent.class);
        results.register("profileByUUID", ProfileByUUIDRequestEvent.class);
        results.register("batchProfileByUsername", BatchProfileByUsernameRequestEvent.class);
        results.register("profiles", ProfilesRequestEvent.class);
        results.register("setProfile", SetProfileRequestEvent.class);
        results.register("updateList", UpdateListRequestEvent.class);
        results.register("error", ErrorRequestEvent.class);
        results.register("update", UpdateRequestEvent.class);
        results.register("restoreSession", RestoreSessionRequestEvent.class);
        results.register("getSecureToken", GetSecureTokenRequestEvent.class);
        results.register("verifySecureToken", VerifySecureTokenRequestEvent.class);
        results.register("log", LogEvent.class);
        results.register("cmdExec", ExecCommandRequestEvent.class);
        results.register("getAvailabilityAuth", GetAvailabilityAuthRequestEvent.class);
        results.register("exception", ExceptionEvent.class);
        results.register("register", RegisterRequestEvent.class);
        results.register("setpassword", SetPasswordRequestEvent.class);
    }

    public void registerHandler(EventHandler eventHandler) {
        this.handlers.add(eventHandler);
    }

    public void waitIfNotConnected() {
    }

    public void sendObject(Object obj) throws IOException {
        this.waitIfNotConnected();
        if (this.ch == null || !this.ch.isActive()) {
            this.reconnectCallback.onReconnect();
        }
        this.send(this.gson.toJson(obj, WebSocketRequest.class));
    }

    public void sendObject(Object obj, Type type) throws IOException {
        this.waitIfNotConnected();
        if (this.ch == null || !this.ch.isActive()) {
            this.reconnectCallback.onReconnect();
        }
        this.send(this.gson.toJson(obj, type));
    }

    @FunctionalInterface
    public static interface EventHandler {
        public void process(WebSocketEvent var1);
    }

    public static interface ReconnectCallback {
        public void onReconnect() throws IOException;
    }

    @FunctionalInterface
    public static interface OnCloseCallback {
        public void onClose(int var1, String var2, boolean var3);
    }
}

