/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.request.websockets;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;
import pro.gravit.launcher.events.ExceptionEvent;
import pro.gravit.launcher.events.request.ErrorRequestEvent;
import pro.gravit.launcher.request.Request;
import pro.gravit.launcher.request.RequestException;
import pro.gravit.launcher.request.WebSocketEvent;
import pro.gravit.launcher.request.websockets.ClientWebSocketService;
import pro.gravit.launcher.request.websockets.WaitEventHandler;
import pro.gravit.launcher.request.websockets.WebSocketRequest;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.helper.LogHelper;

public class StandartClientWebSocketService
extends ClientWebSocketService {
    public WaitEventHandler waitEventHandler = new WaitEventHandler();

    public StandartClientWebSocketService(String address) throws SSLException {
        super(address);
    }

    public WebSocketEvent sendRequest(WebSocketRequest request) throws IOException, InterruptedException {
        WebSocketEvent result;
        RequestFuture future = new RequestFuture(request);
        try {
            result = future.get();
        }
        catch (ExecutionException e) {
            throw (RequestException)e.getCause();
        }
        return result;
    }

    public RequestFuture asyncSendRequest(WebSocketRequest request) throws IOException {
        return new RequestFuture(request);
    }

    public static StandartClientWebSocketService initWebSockets(String address, boolean async) {
        StandartClientWebSocketService service;
        try {
            service = new StandartClientWebSocketService(address);
        }
        catch (SSLException e) {
            throw new SecurityException(e);
        }
        service.registerResults();
        service.registerRequests();
        service.registerHandler(service.waitEventHandler);
        if (!async) {
            try {
                service.open();
                LogHelper.debug((String)"Connect to %s", (Object[])new Object[]{address});
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            try {
                service.open();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        JVMHelper.RUNTIME.addShutdownHook(new Thread(() -> {
            try {
                service.close();
            }
            catch (InterruptedException e) {
                LogHelper.error((Throwable)e);
            }
        }));
        return service;
    }

    public class RequestFuture
    implements Future<WebSocketEvent> {
        public final WaitEventHandler.ResultEvent event = new WaitEventHandler.ResultEvent();
        public boolean isCanceled = false;

        public RequestFuture(WebSocketRequest request) throws IOException {
            this.event.type = request.getType();
            if (request instanceof Request) {
                this.event.uuid = ((Request)request).requestUUID;
            }
            StandartClientWebSocketService.this.waitEventHandler.requests.add(this.event);
            StandartClientWebSocketService.this.sendObject(request);
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            StandartClientWebSocketService.this.waitEventHandler.requests.remove(this.event);
            this.isCanceled = true;
            return true;
        }

        @Override
        public boolean isCancelled() {
            return this.isCanceled;
        }

        @Override
        public boolean isDone() {
            return this.event.ready;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public WebSocketEvent get() throws InterruptedException, ExecutionException {
            if (this.isCanceled) {
                return null;
            }
            WaitEventHandler.ResultEvent resultEvent = this.event;
            synchronized (resultEvent) {
                while (!this.event.ready) {
                    this.event.wait();
                }
            }
            WebSocketEvent result = this.event.result;
            StandartClientWebSocketService.this.waitEventHandler.requests.remove(this.event);
            if (this.event.result.getType().equals("error") || this.event.result.getType().equals("exception")) {
                ErrorRequestEvent errorRequestEvent = (ErrorRequestEvent)this.event.result;
                throw new ExecutionException(new RequestException(errorRequestEvent.error));
            }
            if (this.event.result.getType().equals("exception")) {
                ExceptionEvent error = (ExceptionEvent)this.event.result;
                throw new ExecutionException(new RequestException(String.format("LaunchServer fatal error: %s: %s", error.clazz, error.message)));
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public WebSocketEvent get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException {
            if (this.isCanceled) {
                return null;
            }
            WaitEventHandler.ResultEvent resultEvent = this.event;
            synchronized (resultEvent) {
                while (!this.event.ready) {
                    this.event.wait(timeout);
                }
            }
            WebSocketEvent result = this.event.result;
            StandartClientWebSocketService.this.waitEventHandler.requests.remove(this.event);
            if (this.event.result.getType().equals("error")) {
                ErrorRequestEvent errorRequestEvent = (ErrorRequestEvent)this.event.result;
                throw new ExecutionException(new RequestException(errorRequestEvent.error));
            }
            if (this.event.result.getType().equals("exception")) {
                ExceptionEvent error = (ExceptionEvent)this.event.result;
                throw new ExecutionException(new RequestException(String.format("LaunchServer fatal error: %s: %s", error.clazz, error.message)));
            }
            return result;
        }
    }
}

