/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher;

import java.io.IOException;
import java.net.URL;
import java.nio.file.NoSuchFileException;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import pro.gravit.launcher.LauncherConfig;
import pro.gravit.launcher.managers.GsonManager;
import pro.gravit.launcher.profiles.ClientProfile;
import pro.gravit.launcher.serialize.HInput;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.LogHelper;
import pro.gravit.utils.helper.SecurityHelper;

public final class Launcher {
    public static final String SKIN_URL_PROPERTY = "skinURL";
    public static final String SKIN_DIGEST_PROPERTY = "skinDigest";
    public static final String CLOAK_URL_PROPERTY = "cloakURL";
    public static final String CLOAK_DIGEST_PROPERTY = "cloakDigest";
    public static final AtomicBoolean LAUNCHED = new AtomicBoolean(false);
    private static final AtomicReference<LauncherConfig> CONFIG = new AtomicReference();
    public static final int PROTOCOL_MAGIC_LEGACY = 1917264920;
    public static final int PROTOCOL_MAGIC = -1576685468;
    public static final String RUNTIME_DIR = "runtime";
    public static final String GUARD_DIR = "guard";
    public static final String CONFIG_FILE = "config.bin";
    public static ClientProfile profile;
    public static final String INIT_SCRIPT_FILE = "init.js";
    public static final String API_SCRIPT_FILE = "engine/api.js";
    public static final String CONFIG_SCRIPT_FILE = "config.js";
    private static final Pattern UUID_PATTERN;
    public static GsonManager gsonManager;

    public static LauncherConfig getConfig() {
        LauncherConfig config = CONFIG.get();
        if (config == null) {
            try (HInput input = new HInput(IOHelper.newInput((URL)IOHelper.getResourceURL((String)CONFIG_FILE)));){
                config = new LauncherConfig(input);
            }
            catch (IOException | InvalidKeySpecException e) {
                throw new SecurityException(e);
            }
            CONFIG.set(config);
        }
        return config;
    }

    public static void setConfig(LauncherConfig cfg) {
        CONFIG.set(cfg);
    }

    public static URL getResourceURL(String name) throws IOException {
        LauncherConfig config = Launcher.getConfig();
        byte[] validDigest = config.runtime.get(name);
        if (validDigest == null) {
            throw new NoSuchFileException(name);
        }
        URL url = IOHelper.getResourceURL((String)("runtime/" + name));
        if (!Arrays.equals(validDigest, SecurityHelper.digest((SecurityHelper.DigestAlgorithm)SecurityHelper.DigestAlgorithm.MD5, (URL)url))) {
            throw new NoSuchFileException(name);
        }
        return url;
    }

    public static URL getResourceURL(String name, String prefix) throws IOException {
        LauncherConfig config = Launcher.getConfig();
        byte[] validDigest = config.runtime.get(name);
        if (validDigest == null) {
            throw new NoSuchFileException(name);
        }
        URL url = IOHelper.getResourceURL((String)(prefix + '/' + name));
        if (!Arrays.equals(validDigest, SecurityHelper.digest((SecurityHelper.DigestAlgorithm)SecurityHelper.DigestAlgorithm.MD5, (URL)url))) {
            throw new NoSuchFileException(name);
        }
        return url;
    }

    public static String toHash(UUID uuid) {
        return UUID_PATTERN.matcher(uuid.toString()).replaceAll("");
    }

    public static void applyLauncherEnv(LauncherConfig.LauncherEnvironment env) {
        switch (env) {
            case DEV: {
                LogHelper.setDevEnabled((boolean)true);
                LogHelper.setStacktraceEnabled((boolean)true);
                LogHelper.setDebugEnabled((boolean)true);
                break;
            }
            case DEBUG: {
                LogHelper.setDebugEnabled((boolean)true);
                LogHelper.setStacktraceEnabled((boolean)true);
                break;
            }
            case STD: {
                break;
            }
            case PROD: {
                LogHelper.setStacktraceEnabled((boolean)false);
                LogHelper.setDebugEnabled((boolean)false);
                LogHelper.setDevEnabled((boolean)false);
            }
        }
    }

    static {
        UUID_PATTERN = Pattern.compile("-", 16);
    }
}

