/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.security.cert.CertificateException;
import java.security.interfaces.ECPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import pro.gravit.launcher.Launcher;
import pro.gravit.launcher.LauncherInject;
import pro.gravit.launcher.LauncherInjectionConstructor;
import pro.gravit.launcher.LauncherTrustManager;
import pro.gravit.launcher.modules.LauncherModule;
import pro.gravit.launcher.modules.LauncherModulesManager;
import pro.gravit.launcher.serialize.HInput;
import pro.gravit.launcher.serialize.HOutput;
import pro.gravit.launcher.serialize.stream.StreamObject;
import pro.gravit.utils.helper.LogHelper;
import pro.gravit.utils.helper.SecurityHelper;
import pro.gravit.utils.helper.VerifyHelper;

public final class LauncherConfig
extends StreamObject {
    @LauncherInject(value="launchercore.certificates")
    private static final List<byte[]> secureConfigCertificates = null;
    @LauncherInject(value="launcher.modules")
    private static final List<Class<?>> modulesClasses = null;
    @LauncherInject(value="launcher.address")
    public String address;
    @LauncherInject(value="launcher.projectName")
    public final String projectName;
    @LauncherInject(value="launcher.port")
    public final int clientPort;
    @LauncherInject(value="runtimeconfig.secretKeyClient")
    public String secretKeyClient;
    @LauncherInject(value="runtimeconfig.oemUnlockKey")
    public String oemUnlockKey;
    public final LauncherTrustManager trustManager;
    public final ECPublicKey publicKey;
    public final Map<String, byte[]> runtime;
    @LauncherInject(value="launcher.isWarningMissArchJava")
    public final boolean isWarningMissArchJava;
    @LauncherInject(value="launchercore.env")
    public LauncherEnvironment environment;
    @LauncherInject(value="launcher.guardType")
    public final String guardType;
    @LauncherInject(value="runtimeconfig.secureCheckHash")
    public final String secureCheckHash;
    @LauncherInject(value="runtimeconfig.secureCheckSalt")
    public final String secureCheckSalt;
    @LauncherInject(value="runtimeconfig.passwordEncryptKey")
    public final String passwordEncryptKey;
    private static final MethodType VOID_TYPE = MethodType.methodType(Void.TYPE);

    @LauncherInjectionConstructor
    public LauncherConfig(HInput input) throws IOException, InvalidKeySpecException {
        this.publicKey = SecurityHelper.toPublicECKey((byte[])input.readByteArray(2048));
        this.secureCheckHash = null;
        this.secureCheckSalt = null;
        this.passwordEncryptKey = null;
        this.projectName = null;
        this.clientPort = -1;
        this.secretKeyClient = null;
        this.oemUnlockKey = null;
        try {
            this.trustManager = new LauncherTrustManager(secureConfigCertificates);
        }
        catch (CertificateException e) {
            throw new IOException(e);
        }
        this.isWarningMissArchJava = false;
        this.guardType = null;
        this.address = null;
        this.environment = LauncherEnvironment.STD;
        Launcher.applyLauncherEnv(this.environment);
        int count = input.readLength(0);
        HashMap localResources = new HashMap(count);
        for (int i = 0; i < count; ++i) {
            String name = input.readString(255);
            VerifyHelper.putIfAbsent(localResources, (Object)name, (Object)input.readByteArray(2048), (String)String.format("Duplicate runtime resource: '%s'", name));
        }
        this.runtime = Collections.unmodifiableMap(localResources);
    }

    public LauncherConfig(String address, ECPublicKey publicKey, Map<String, byte[]> runtime, String projectName) {
        this.address = address;
        this.publicKey = publicKey;
        this.runtime = Collections.unmodifiableMap(new HashMap<String, byte[]>(runtime));
        this.projectName = projectName;
        this.clientPort = 32148;
        this.guardType = "no";
        this.isWarningMissArchJava = true;
        this.environment = LauncherEnvironment.STD;
        this.secureCheckSalt = null;
        this.secureCheckHash = null;
        this.passwordEncryptKey = null;
        this.trustManager = null;
    }

    public void write(HOutput output) throws IOException {
        output.writeByteArray(this.publicKey.getEncoded(), 2048);
        Set<Map.Entry<String, byte[]>> entrySet = this.runtime.entrySet();
        output.writeLength(entrySet.size(), 0);
        for (Map.Entry<String, byte[]> entry : this.runtime.entrySet()) {
            output.writeString(entry.getKey(), 255);
            output.writeByteArray(entry.getValue(), 2048);
        }
    }

    public static void initModules(LauncherModulesManager modulesManager) {
        for (Class<?> clazz : modulesClasses) {
            try {
                modulesManager.loadModule((LauncherModule)MethodHandles.publicLookup().findConstructor(clazz, VOID_TYPE).invokeWithArguments(Collections.emptyList()));
            }
            catch (Throwable e) {
                LogHelper.error((Throwable)e);
            }
        }
        modulesClasses.clear();
    }

    public static enum LauncherEnvironment {
        DEV,
        DEBUG,
        STD,
        PROD;

    }
}

