/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.hwid;

import com.google.gson.Gson;
import java.util.Objects;
import java.util.StringJoiner;
import pro.gravit.launcher.LauncherNetworkAPI;
import pro.gravit.launcher.hwid.HWID;
import pro.gravit.launcher.hwid.HWIDCheckHelper;

public class OshiHWID
implements HWID {
    public static Gson gson = new Gson();
    @LauncherNetworkAPI
    public long totalMemory = 0L;
    @LauncherNetworkAPI
    public String serialNumber;
    @LauncherNetworkAPI
    public String HWDiskSerial;
    @LauncherNetworkAPI
    public String processorID;
    @LauncherNetworkAPI
    public String macAddr;

    @Override
    public int getLevel() {
        int result = 0;
        if (this.totalMemory != 0L) {
            result += 32;
        }
        if (this.serialNumber != null) {
            result += this.isRealSerialNumber() ? 20 : 3;
        }
        if (this.HWDiskSerial != null && !this.HWDiskSerial.isEmpty()) {
            result += 38;
        }
        if (this.processorID != null && !this.processorID.isEmpty()) {
            result += 15;
        }
        if (this.macAddr != null && !this.macAddr.isEmpty()) {
            result += 25;
        }
        return result;
    }

    @Override
    public int getAntiLevel() {
        return HWIDCheckHelper.checkString(this.serialNumber) + HWIDCheckHelper.checkString(this.HWDiskSerial);
    }

    @Override
    public int compare(HWID hwid) {
        if (hwid instanceof OshiHWID) {
            int rate = 0;
            OshiHWID oshi = (OshiHWID)hwid;
            if (Math.abs(oshi.totalMemory - this.totalMemory) < 0x100000L) {
                rate += 5;
            }
            if (oshi.totalMemory == this.totalMemory) {
                rate += 32;
            }
            if (oshi.HWDiskSerial.equals(this.HWDiskSerial) && !this.HWDiskSerial.isEmpty()) {
                rate += 38;
            }
            if (oshi.processorID.equals(this.processorID) && !this.processorID.isEmpty()) {
                rate += 15;
            }
            if (oshi.serialNumber.equals(this.serialNumber)) {
                rate += this.isRealSerialNumber() ? 20 : 3;
            }
            if (!oshi.macAddr.isEmpty() && oshi.macAddr.equals(this.macAddr)) {
                rate += 19;
            }
            return rate;
        }
        return 0;
    }

    @Override
    public boolean isNull() {
        return this.getLevel() < 15;
    }

    @Override
    public void normalize() {
        this.HWDiskSerial = this.HWDiskSerial.trim();
        this.serialNumber = this.serialNumber.trim();
        this.processorID = this.processorID.trim();
        this.macAddr = this.macAddr.trim();
    }

    public boolean isRealSerialNumber() {
        if (this.serialNumber.isEmpty()) {
            return false;
        }
        if (this.serialNumber.equals("System Serial Number")) {
            return false;
        }
        if (this.serialNumber.equals("To be filled by O.E.M.")) {
            return false;
        }
        if (this.serialNumber.equals("unknown")) {
            return false;
        }
        if (this.serialNumber.equals("None")) {
            return false;
        }
        return !this.serialNumber.equals("Default string");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OshiHWID oshiHWID = (OshiHWID)o;
        return this.totalMemory == oshiHWID.totalMemory && Objects.equals(this.serialNumber, oshiHWID.serialNumber) && Objects.equals(this.HWDiskSerial, oshiHWID.HWDiskSerial) && Objects.equals(this.processorID, oshiHWID.processorID) && Objects.equals(this.macAddr, oshiHWID.macAddr);
    }

    public int hashCode() {
        return Objects.hash(this.totalMemory, this.serialNumber, this.HWDiskSerial, this.processorID, this.macAddr);
    }

    public String toString() {
        return new StringJoiner(", ", OshiHWID.class.getSimpleName() + "[", "]").add("totalMemory=" + this.totalMemory).add("serialNumber='" + this.serialNumber + "'").add("HWDiskSerial='" + this.HWDiskSerial + "'").add("processorID='" + this.processorID + "'").add("macAddr='" + this.macAddr + "'").toString();
    }
}

