/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.managers;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import pro.gravit.launcher.config.SimpleConfigurable;
import pro.gravit.launcher.modules.ModulesConfigManager;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.LogHelper;

public class SimpleModulesConfigManager
implements ModulesConfigManager {
    public final Path configDir;

    public SimpleModulesConfigManager(Path configDir) {
        this.configDir = configDir;
    }

    @Override
    public Path getModuleConfig(String moduleName) {
        return this.getModuleConfig(moduleName, "Config");
    }

    @Override
    public Path getModuleConfig(String moduleName, String configName) {
        return this.getModuleConfigDir(moduleName).resolve(moduleName.concat(configName.concat(".json")));
    }

    @Override
    public Path getModuleConfigDir(String moduleName) {
        if (!IOHelper.isDir((Path)this.configDir)) {
            try {
                Files.createDirectories(this.configDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                LogHelper.error((Throwable)e);
            }
        }
        return this.configDir.resolve(moduleName);
    }

    @Override
    public <T> SimpleConfigurable<T> getConfigurable(Class<T> tClass, Path configPath) {
        return new SimpleConfigurable<T>(tClass, configPath);
    }
}

