/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.profiles;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import pro.gravit.launcher.LauncherNetworkAPI;
import pro.gravit.launcher.hasher.FileNameMatcher;
import pro.gravit.launcher.hasher.HashedDir;
import pro.gravit.launcher.profiles.optional.OptionalDepend;
import pro.gravit.launcher.profiles.optional.OptionalFile;
import pro.gravit.launcher.profiles.optional.OptionalType;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.VerifyHelper;

public final class ClientProfile
implements Comparable<ClientProfile> {
    public static final boolean profileCaseSensitive = Boolean.getBoolean("launcher.clientProfile.caseSensitive");
    private static final FileNameMatcher ASSET_MATCHER = new FileNameMatcher(new String[0], new String[]{"indexes", "objects"}, new String[0]);
    @LauncherNetworkAPI
    private String version;
    @LauncherNetworkAPI
    private String assetIndex;
    @LauncherNetworkAPI
    private String dir;
    @LauncherNetworkAPI
    private String assetDir;
    @LauncherNetworkAPI
    private int sortIndex;
    @LauncherNetworkAPI
    private UUID uuid;
    @LauncherNetworkAPI
    private String title;
    @LauncherNetworkAPI
    private String info;
    @LauncherNetworkAPI
    private String serverAddress;
    @LauncherNetworkAPI
    private int serverPort;
    @LauncherNetworkAPI
    private final List<String> update = new ArrayList<String>();
    @LauncherNetworkAPI
    private final List<String> updateExclusions = new ArrayList<String>();
    @LauncherNetworkAPI
    private final List<String> updateShared = new ArrayList<String>();
    @LauncherNetworkAPI
    private final List<String> updateVerify = new ArrayList<String>();
    @LauncherNetworkAPI
    private final Set<OptionalFile> updateOptional = new HashSet<OptionalFile>();
    @LauncherNetworkAPI
    private boolean updateFastCheck;
    @LauncherNetworkAPI
    private boolean useWhitelist;
    @LauncherNetworkAPI
    private String mainClass;
    @LauncherNetworkAPI
    private final List<String> jvmArgs = new ArrayList<String>();
    @LauncherNetworkAPI
    private final List<String> classPath = new ArrayList<String>();
    @LauncherNetworkAPI
    private final List<String> clientArgs = new ArrayList<String>();
    @LauncherNetworkAPI
    private final List<String> whitelist = new ArrayList<String>();
    @LauncherNetworkAPI
    public SecurityManagerConfig securityManagerConfig = SecurityManagerConfig.CLIENT;
    @LauncherNetworkAPI
    public ClassLoaderConfig classLoaderConfig = ClassLoaderConfig.LAUNCHER;

    @Override
    public int compareTo(ClientProfile o) {
        return Integer.compare(this.getSortIndex(), o.getSortIndex());
    }

    public String getAssetIndex() {
        return this.assetIndex;
    }

    public FileNameMatcher getAssetUpdateMatcher() {
        return this.getVersion().compareTo(Version.MC1710) >= 0 ? ASSET_MATCHER : null;
    }

    public String[] getClassPath() {
        return this.classPath.toArray(new String[0]);
    }

    public String[] getClientArgs() {
        return this.clientArgs.toArray(new String[0]);
    }

    public String getDir() {
        return this.dir;
    }

    public void setDir(String dir) {
        this.dir = dir;
    }

    public String getAssetDir() {
        return this.assetDir;
    }

    public FileNameMatcher getClientUpdateMatcher() {
        String[] updateArray = this.update.toArray(new String[0]);
        String[] verifyArray = this.updateVerify.toArray(new String[0]);
        List<String> excludeList = this.updateExclusions;
        String[] exclusionsArray = excludeList.toArray(new String[0]);
        return new FileNameMatcher(updateArray, verifyArray, exclusionsArray);
    }

    public String[] getJvmArgs() {
        return this.jvmArgs.toArray(new String[0]);
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    public Set<OptionalFile> getOptional() {
        return this.updateOptional;
    }

    public void updateOptionalGraph() {
        for (OptionalFile file : this.updateOptional) {
            int i;
            if (file.dependenciesFile != null) {
                file.dependencies = new OptionalFile[file.dependenciesFile.length];
                for (i = 0; i < file.dependenciesFile.length; ++i) {
                    file.dependencies[i] = this.getOptionalFile(file.dependenciesFile[i].name, file.dependenciesFile[i].type);
                }
            }
            if (file.conflictFile == null) continue;
            file.conflict = new OptionalFile[file.conflictFile.length];
            for (i = 0; i < file.conflictFile.length; ++i) {
                file.conflict[i] = this.getOptionalFile(file.conflictFile[i].name, file.conflictFile[i].type);
            }
        }
    }

    public OptionalFile getOptionalFile(String file, OptionalType type) {
        for (OptionalFile f : this.updateOptional) {
            if (!f.type.equals((Object)type) || !f.name.equals(file)) continue;
            return f;
        }
        return null;
    }

    public Collection<String> getShared() {
        return this.updateShared;
    }

    public void markOptional(String name, OptionalType type) {
        OptionalFile file = this.getOptionalFile(name, type);
        if (file == null) {
            throw new SecurityException(String.format("Optional %s not found in optionalList", name));
        }
        this.markOptional(file);
    }

    public void markOptional(OptionalFile file) {
        if (file.mark) {
            return;
        }
        file.mark = true;
        file.notifyObservers(true);
        if (file.dependencies != null) {
            for (OptionalFile dep : file.dependencies) {
                if (dep.dependenciesCount == null) {
                    dep.dependenciesCount = new HashSet<OptionalFile>();
                }
                dep.dependenciesCount.add(file);
                this.markOptional(dep);
            }
        }
        if (file.conflict != null) {
            for (OptionalFile conflict : file.conflict) {
                this.unmarkOptional(conflict);
            }
        }
    }

    public void unmarkOptional(String name, OptionalType type) {
        OptionalFile file = this.getOptionalFile(name, type);
        if (file == null) {
            throw new SecurityException(String.format("Optional %s not found in optionalList", name));
        }
        this.unmarkOptional(file);
    }

    public void unmarkOptional(OptionalFile file) {
        if (!file.mark) {
            return;
        }
        file.mark = false;
        file.notifyObservers(false);
        if (file.dependenciesCount != null) {
            for (OptionalFile f : file.dependenciesCount) {
                if (f.isPreset) continue;
                this.unmarkOptional(f);
            }
            file.dependenciesCount.clear();
            file.dependenciesCount = null;
        }
        if (file.dependencies != null) {
            for (OptionalFile f : file.dependencies) {
                if (!f.mark) continue;
                if (f.dependenciesCount == null) {
                    this.unmarkOptional(f);
                    continue;
                }
                if (f.dependenciesCount.size() > 1) continue;
                f.dependenciesCount.clear();
                f.dependenciesCount = null;
                this.unmarkOptional(f);
            }
        }
    }

    public void pushOptionalFile(HashedDir dir, boolean digest) {
        for (OptionalFile opt : this.updateOptional) {
            if (!opt.type.equals((Object)OptionalType.FILE) || opt.mark) continue;
            for (String file : opt.list) {
                dir.removeR(file);
            }
        }
    }

    public void pushOptionalJvmArgs(Collection<String> jvmArgs1) {
        for (OptionalFile opt : this.updateOptional) {
            if (!opt.type.equals((Object)OptionalType.JVMARGS) || !opt.mark) continue;
            jvmArgs1.addAll(Arrays.asList(opt.list));
        }
    }

    public void pushOptionalClientArgs(Collection<String> clientArgs1) {
        for (OptionalFile opt : this.updateOptional) {
            if (!opt.type.equals((Object)OptionalType.CLIENTARGS) || !opt.mark) continue;
            clientArgs1.addAll(Arrays.asList(opt.list));
        }
    }

    public void pushOptionalClassPath(pushOptionalClassPathCallback callback) throws IOException {
        for (OptionalFile opt : this.updateOptional) {
            if (!opt.type.equals((Object)OptionalType.CLASSPATH) || !opt.mark) continue;
            callback.run(opt.list);
        }
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public InetSocketAddress getServerSocketAddress() {
        return InetSocketAddress.createUnresolved(this.getServerAddress(), this.getServerPort());
    }

    public int getSortIndex() {
        return this.sortIndex;
    }

    public String getTitle() {
        return this.title;
    }

    public String getInfo() {
        return this.info;
    }

    public Version getVersion() {
        return Version.byName(this.version);
    }

    public boolean isUpdateFastCheck() {
        return this.updateFastCheck;
    }

    public boolean isWhitelistContains(String username) {
        if (!this.useWhitelist) {
            return true;
        }
        return this.whitelist.stream().anyMatch(profileCaseSensitive ? e -> e.equals(username) : e -> e.equalsIgnoreCase(username));
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setInfo(String info) {
        this.info = info;
    }

    public void setVersion(Version version) {
        this.version = version.name;
    }

    public void setUUID(UUID uuid) {
        this.uuid = uuid;
    }

    public String toString() {
        return this.title;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public void verify() {
        this.getVersion();
        IOHelper.verifyFileName((String)this.getAssetIndex());
        VerifyHelper.verify((Object)this.getTitle(), (Predicate)VerifyHelper.NOT_EMPTY, (String)"Profile title can't be empty");
        VerifyHelper.verify((Object)this.getInfo(), (Predicate)VerifyHelper.NOT_EMPTY, (String)"Profile info can't be empty");
        VerifyHelper.verify((Object)this.getServerAddress(), (Predicate)VerifyHelper.NOT_EMPTY, (String)"Server address can't be empty");
        VerifyHelper.verifyInt((int)this.getServerPort(), (IntPredicate)VerifyHelper.range((int)0, (int)65535), (String)("Illegal server port: " + this.getServerPort()));
        VerifyHelper.verify((Object)this.getTitle(), (Predicate)VerifyHelper.NOT_EMPTY, (String)"Main class can't be empty");
        for (String s : this.update) {
            if (s != null) continue;
            throw new IllegalArgumentException("Found null entry in update");
        }
        for (String s : this.updateVerify) {
            if (s != null) continue;
            throw new IllegalArgumentException("Found null entry in updateVerify");
        }
        for (String s : this.updateExclusions) {
            if (s != null) continue;
            throw new IllegalArgumentException("Found null entry in updateExclusions");
        }
        for (String s : this.classPath) {
            if (s != null) continue;
            throw new IllegalArgumentException("Found null entry in classPath");
        }
        for (String s : this.jvmArgs) {
            if (s != null) continue;
            throw new IllegalArgumentException("Found null entry in jvmArgs");
        }
        for (String s : this.clientArgs) {
            if (s != null) continue;
            throw new IllegalArgumentException("Found null entry in clientArgs");
        }
        for (OptionalFile f : this.updateOptional) {
            if (f == null) {
                throw new IllegalArgumentException("Found null entry in updateOptional");
            }
            if (f.name == null) {
                throw new IllegalArgumentException("Optional: name must not be null");
            }
            if (f.list == null) {
                throw new IllegalArgumentException("Optional: list must not be null");
            }
            for (String string : f.list) {
                if (string != null) continue;
                throw new IllegalArgumentException(String.format("Found null entry in updateOptional.%s.list", f.name));
            }
            if (f.conflictFile != null) {
                for (OptionalDepend optionalDepend : f.conflictFile) {
                    if (optionalDepend != null) continue;
                    throw new IllegalArgumentException(String.format("Found null entry in updateOptional.%s.conflictFile", f.name));
                }
            }
            if (f.dependenciesFile == null) continue;
            for (OptionalDepend optionalDepend : f.dependenciesFile) {
                if (optionalDepend != null) continue;
                throw new IllegalArgumentException(String.format("Found null entry in updateOptional.%s.dependenciesFile", f.name));
            }
        }
    }

    @FunctionalInterface
    public static interface pushOptionalClassPathCallback {
        public void run(String[] var1) throws IOException;
    }

    public static enum ClassLoaderConfig {
        AGENT,
        LAUNCHER;

    }

    public static enum SecurityManagerConfig {
        NONE,
        CLIENT,
        LAUNCHER,
        MIXED;

    }

    public static enum Version {
        MC125("1.2.5", 29),
        MC147("1.4.7", 51),
        MC152("1.5.2", 61),
        MC164("1.6.4", 78),
        MC172("1.7.2", 4),
        MC1710("1.7.10", 5),
        MC189("1.8.9", 47),
        MC19("1.9", 107),
        MC192("1.9.2", 109),
        MC194("1.9.4", 110),
        MC1102("1.10.2", 210),
        MC111("1.11", 315),
        MC1112("1.11.2", 316),
        MC112("1.12", 335),
        MC1121("1.12.1", 338),
        MC1122("1.12.2", 340),
        MC113("1.13", 393),
        MC1131("1.13.1", 401),
        MC1132("1.13.2", 402),
        MC114("1.14", 477),
        MC1141("1.14.1", 480),
        MC1142("1.14.2", 485),
        MC1143("1.14.3", 490),
        MC1144("1.14.4", 498),
        MC115("1.15", 573),
        MC1151("1.15.1", 575),
        MC1152("1.15.2", 578);

        private static final Map<String, Version> VERSIONS;
        public final String name;
        public final int protocol;

        public static Version byName(String name) {
            return (Version)((Object)VerifyHelper.getMapValue(VERSIONS, (Object)name, (String)String.format("Unknown client version: '%s'", name)));
        }

        private Version(String name, int protocol) {
            this.name = name;
            this.protocol = protocol;
        }

        public String toString() {
            return "Minecraft " + this.name;
        }

        static {
            Version[] versionsValues = Version.values();
            VERSIONS = new HashMap<String, Version>(versionsValues.length);
            for (Version version : versionsValues) {
                VERSIONS.put(version.name, version);
            }
        }
    }
}

