/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.profiles;

import java.io.IOException;
import java.util.Objects;
import java.util.UUID;
import pro.gravit.launcher.profiles.Texture;
import pro.gravit.launcher.serialize.HInput;
import pro.gravit.launcher.serialize.HOutput;
import pro.gravit.launcher.serialize.stream.StreamObject;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.VerifyHelper;

public final class PlayerProfile
extends StreamObject {
    public final UUID uuid;
    public final String username;
    public final Texture skin;
    public final Texture cloak;

    public static PlayerProfile newOfflineProfile(String username) {
        return new PlayerProfile(PlayerProfile.offlineUUID(username), username, null, null);
    }

    public static UUID offlineUUID(String username) {
        return UUID.nameUUIDFromBytes(IOHelper.encodeASCII((String)("OfflinePlayer:" + username)));
    }

    public PlayerProfile(HInput input) throws IOException {
        this.uuid = input.readUUID();
        this.username = VerifyHelper.verifyUsername((String)input.readString(64));
        this.skin = input.readBoolean() ? new Texture(input) : null;
        this.cloak = input.readBoolean() ? new Texture(input) : null;
    }

    public PlayerProfile(UUID uuid, String username, Texture skin, Texture cloak) {
        this.uuid = Objects.requireNonNull(uuid, "uuid");
        this.username = VerifyHelper.verifyUsername((String)username);
        this.skin = skin;
        this.cloak = cloak;
    }

    public void write(HOutput output) throws IOException {
        output.writeUUID(this.uuid);
        output.writeString(this.username, 64);
        output.writeBoolean(this.skin != null);
        if (this.skin != null) {
            this.skin.write(output);
        }
        output.writeBoolean(this.cloak != null);
        if (this.cloak != null) {
            this.cloak.write(output);
        }
    }
}

