/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.request.auth;

import java.util.function.Predicate;
import pro.gravit.launcher.LauncherNetworkAPI;
import pro.gravit.launcher.events.request.AuthRequestEvent;
import pro.gravit.launcher.hwid.HWID;
import pro.gravit.launcher.request.Request;
import pro.gravit.launcher.request.auth.password.AuthECPassword;
import pro.gravit.launcher.request.auth.password.AuthPlainPassword;
import pro.gravit.launcher.request.websockets.WebSocketRequest;
import pro.gravit.utils.ProviderMap;
import pro.gravit.utils.helper.VerifyHelper;

public final class AuthRequest
extends Request<AuthRequestEvent>
implements WebSocketRequest {
    public static final ProviderMap<AuthPasswordInterface> providers = new ProviderMap();
    @LauncherNetworkAPI
    private final String login;
    @LauncherNetworkAPI
    private final AuthPasswordInterface password;
    @LauncherNetworkAPI
    private final String auth_id;
    @LauncherNetworkAPI
    private final HWID hwid;
    @LauncherNetworkAPI
    private final String customText;
    @LauncherNetworkAPI
    private final boolean getSession;
    @LauncherNetworkAPI
    private final ConnectTypes authType;
    @LauncherNetworkAPI
    public boolean initProxy;
    private static boolean registerProviders = false;

    public AuthRequest(String login, byte[] password, HWID hwid) {
        this.login = (String)VerifyHelper.verify((Object)login, (Predicate)VerifyHelper.NOT_EMPTY, (String)"Login can't be empty");
        this.password = new AuthECPassword((byte[])password.clone());
        this.hwid = hwid;
        this.customText = "";
        this.auth_id = "";
        this.getSession = true;
        this.authType = ConnectTypes.CLIENT;
    }

    public AuthRequest(String login, byte[] password, HWID hwid, String auth_id) {
        this.login = (String)VerifyHelper.verify((Object)login, (Predicate)VerifyHelper.NOT_EMPTY, (String)"Login can't be empty");
        this.password = new AuthECPassword((byte[])password.clone());
        this.hwid = hwid;
        this.auth_id = auth_id;
        this.customText = "";
        this.getSession = true;
        this.authType = ConnectTypes.CLIENT;
    }

    public AuthRequest(String login, byte[] password, HWID hwid, String customText, String auth_id) {
        this.login = (String)VerifyHelper.verify((Object)login, (Predicate)VerifyHelper.NOT_EMPTY, (String)"Login can't be empty");
        this.password = new AuthECPassword((byte[])password.clone());
        this.hwid = hwid;
        this.auth_id = auth_id;
        this.customText = customText;
        this.getSession = true;
        this.authType = ConnectTypes.CLIENT;
    }

    public AuthRequest(String login, byte[] encryptedPassword, String auth_id, ConnectTypes authType) {
        this.login = login;
        this.password = new AuthECPassword((byte[])encryptedPassword.clone());
        this.auth_id = auth_id;
        this.authType = authType;
        this.hwid = null;
        this.customText = "";
        this.getSession = false;
    }

    public AuthRequest(String login, String password, String auth_id, ConnectTypes authType) {
        this.login = login;
        this.password = new AuthPlainPassword(password);
        this.auth_id = auth_id;
        this.authType = authType;
        this.hwid = null;
        this.customText = "";
        this.getSession = false;
    }

    @Override
    public String getType() {
        return "auth";
    }

    public static void registerProviders() {
        if (!registerProviders) {
            providers.register("plain", AuthPlainPassword.class);
            providers.register("rsa", AuthECPassword.class);
            registerProviders = true;
        }
    }

    public static enum ConnectTypes {
        SERVER,
        CLIENT,
        API;

    }

    public static interface AuthPasswordInterface {
        public boolean check();
    }
}

