/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.request.update;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import pro.gravit.launcher.Launcher;
import pro.gravit.launcher.LauncherNetworkAPI;
import pro.gravit.launcher.events.request.LauncherRequestEvent;
import pro.gravit.launcher.request.Request;
import pro.gravit.launcher.request.websockets.StdWebSocketService;
import pro.gravit.launcher.request.websockets.WebSocketRequest;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.helper.LogHelper;
import pro.gravit.utils.helper.SecurityHelper;

public final class LauncherRequest
extends Request<LauncherRequestEvent>
implements WebSocketRequest {
    @LauncherNetworkAPI
    public byte[] digest;
    @LauncherNetworkAPI
    public final String secureHash;
    @LauncherNetworkAPI
    public final String secureSalt;
    @LauncherNetworkAPI
    public int launcher_type = EXE_BINARY ? 2 : 1;
    public static final Path BINARY_PATH = IOHelper.getCodeSource(Launcher.class);
    public static final Path C_BINARY_PATH = BINARY_PATH.getParent().resolve(IOHelper.getFileName((Path)BINARY_PATH) + ".tmp");
    public static final boolean EXE_BINARY = IOHelper.hasExtension((Path)BINARY_PATH, (String)"exe");

    public static void update(LauncherRequestEvent result) throws IOException {
        ArrayList<String> args = new ArrayList<String>(8);
        args.add(IOHelper.resolveJavaBin(null).toString());
        if (LogHelper.isDebugEnabled()) {
            args.add(JVMHelper.jvmProperty((String)"launcher.debug", (String)Boolean.toString(LogHelper.isDebugEnabled())));
        }
        args.add("-jar");
        args.add(BINARY_PATH.toString());
        ProcessBuilder builder = new ProcessBuilder(args.toArray(new String[0]));
        builder.inheritIO();
        if (result.binary != null) {
            IOHelper.write((Path)BINARY_PATH, (byte[])result.binary);
        } else {
            try {
                Files.deleteIfExists(C_BINARY_PATH);
                URL url = new URL(result.url);
                URLConnection connection = url.openConnection();
                try (InputStream in = connection.getInputStream();){
                    IOHelper.transfer((InputStream)in, (Path)C_BINARY_PATH);
                }
                in = IOHelper.newInput((Path)C_BINARY_PATH);
                try {
                    IOHelper.transfer((InputStream)in, (Path)BINARY_PATH);
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                }
                Files.deleteIfExists(C_BINARY_PATH);
            }
            catch (Throwable e) {
                LogHelper.error((Throwable)e);
            }
        }
        builder.start();
        JVMHelper.RUNTIME.exit(255);
        throw new AssertionError((Object)"Why Launcher wasn't restarted?!");
    }

    @Override
    public LauncherRequestEvent requestDo(StdWebSocketService service) throws Exception {
        LauncherRequestEvent result = (LauncherRequestEvent)super.request(service);
        if (result.needUpdate) {
            LauncherRequest.update(result);
        }
        return result;
    }

    public LauncherRequest() {
        Path launcherPath = IOHelper.getCodeSource(LauncherRequest.class);
        try {
            this.digest = SecurityHelper.digest((SecurityHelper.DigestAlgorithm)SecurityHelper.DigestAlgorithm.SHA512, (Path)launcherPath);
        }
        catch (IOException e) {
            LogHelper.error((Throwable)e);
        }
        this.secureHash = Launcher.getConfig().secureCheckHash;
        this.secureSalt = Launcher.getConfig().secureCheckSalt;
    }

    @Override
    public String getType() {
        return "launcher";
    }
}

