/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.request.websockets;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import java.net.URI;
import javax.net.ssl.SSLException;
import pro.gravit.launcher.request.websockets.WebSocketClientHandler;
import pro.gravit.utils.helper.LogHelper;

public abstract class ClientJSONPoint {
    private final URI uri;
    protected Channel ch;
    private static final EventLoopGroup group = new NioEventLoopGroup();
    protected WebSocketClientHandler webSocketClientHandler;
    protected final Bootstrap bootstrap = new Bootstrap();
    protected boolean ssl = false;
    protected int port;
    public boolean isClosed;

    public ClientJSONPoint(String uri) throws SSLException {
        this(URI.create(uri));
    }

    public ClientJSONPoint(final URI uri) throws SSLException {
        this.uri = uri;
        String protocol = uri.getScheme();
        if (!"ws".equals(protocol) && !"wss".equals(protocol)) {
            throw new IllegalArgumentException("Unsupported protocol: " + protocol);
        }
        if ("wss".equals(protocol)) {
            this.ssl = true;
        }
        this.port = uri.getPort() == -1 ? ("ws".equals(protocol) ? 80 : 443) : uri.getPort();
        final SslContext sslCtx = this.ssl ? SslContextBuilder.forClient().build() : null;
        ((Bootstrap)((Bootstrap)this.bootstrap.group(group)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) {
                ChannelPipeline pipeline = ch.pipeline();
                if (sslCtx != null) {
                    pipeline.addLast(new ChannelHandler[]{sslCtx.newHandler(ch.alloc(), uri.getHost(), ClientJSONPoint.this.port)});
                }
                pipeline.addLast("http-codec", (ChannelHandler)new HttpClientCodec());
                pipeline.addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(65536));
                pipeline.addLast("ws-handler", (ChannelHandler)ClientJSONPoint.this.webSocketClientHandler);
            }
        });
    }

    public void open() throws Exception {
        this.webSocketClientHandler = new WebSocketClientHandler(WebSocketClientHandshakerFactory.newHandshaker((URI)this.uri, (WebSocketVersion)WebSocketVersion.V13, null, (boolean)false, (HttpHeaders)EmptyHttpHeaders.INSTANCE, (int)12800000), this);
        this.ch = this.bootstrap.connect(this.uri.getHost(), this.port).sync().channel();
        this.webSocketClientHandler.handshakeFuture().sync();
    }

    public void openAsync(Runnable onConnect) {
        this.webSocketClientHandler = new WebSocketClientHandler(WebSocketClientHandshakerFactory.newHandshaker((URI)this.uri, (WebSocketVersion)WebSocketVersion.V13, null, (boolean)false, (HttpHeaders)EmptyHttpHeaders.INSTANCE, (int)12800000), this);
        ChannelFuture future = this.bootstrap.connect(this.uri.getHost(), this.port);
        future.addListener(e -> {
            this.ch = future.channel();
            this.webSocketClientHandler.handshakeFuture().addListener(e1 -> onConnect.run());
        });
    }

    public ChannelFuture send(String text) {
        LogHelper.dev((String)"Send: %s", (Object[])new Object[]{text});
        return this.ch.writeAndFlush((Object)new TextWebSocketFrame(text), this.ch.voidPromise());
    }

    abstract void onMessage(String var1);

    abstract void onDisconnect();

    abstract void onOpen();

    public void close() throws InterruptedException {
        this.isClosed = true;
        if (this.ch != null && this.ch.isActive()) {
            this.ch.writeAndFlush((Object)new CloseWebSocketFrame(), this.ch.voidPromise());
            this.ch.closeFuture().sync();
        }
        group.shutdownGracefully();
    }

    public void eval(String text) {
        this.ch.writeAndFlush((Object)new TextWebSocketFrame(text), this.ch.voidPromise());
    }
}

