/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.modules;

import java.util.HashMap;
import java.util.Map;
import pro.gravit.launcher.LauncherTrustManager;
import pro.gravit.launcher.modules.LauncherInitContext;
import pro.gravit.launcher.modules.LauncherModuleInfo;
import pro.gravit.launcher.modules.LauncherModulesContext;
import pro.gravit.launcher.modules.LauncherModulesManager;
import pro.gravit.launcher.modules.ModulesConfigManager;

public abstract class LauncherModule {
    protected final LauncherModuleInfo moduleInfo;
    private final Map<Class<? extends Event>, EventHandler> eventMap = new HashMap<Class<? extends Event>, EventHandler>();
    protected LauncherModulesManager modulesManager;
    protected ModulesConfigManager modulesConfigManager;
    protected InitStatus initStatus = InitStatus.CREATED;
    private LauncherModulesContext context;
    private LauncherTrustManager.CheckClassResult checkResult;

    protected LauncherModule() {
        this.moduleInfo = new LauncherModuleInfo("UnknownModule");
    }

    protected LauncherModule(LauncherModuleInfo info) {
        this.moduleInfo = info;
    }

    public LauncherModuleInfo getModuleInfo() {
        return this.moduleInfo;
    }

    public InitStatus getInitStatus() {
        return this.initStatus;
    }

    public LauncherModule setInitStatus(InitStatus initStatus) {
        this.initStatus = initStatus;
        return this;
    }

    public final void setContext(LauncherModulesContext context) {
        if (this.context != null) {
            throw new IllegalStateException("Module already set context");
        }
        this.context = context;
        this.modulesManager = context.getModulesManager();
        this.modulesConfigManager = context.getModulesConfigManager();
        this.setInitStatus(InitStatus.PRE_INIT_WAIT);
    }

    public final void setCheckResult(LauncherTrustManager.CheckClassResult result) {
        if (this.checkResult != null) {
            throw new IllegalStateException("Module already set check result");
        }
        this.checkResult = result;
    }

    public final LauncherTrustManager.CheckClassResultType getCheckStatus() {
        if (this.checkResult == null) {
            return null;
        }
        return this.checkResult.type;
    }

    public final LauncherTrustManager.CheckClassResult getCheckResult() {
        if (this.checkResult == null) {
            return null;
        }
        return new LauncherTrustManager.CheckClassResult(this.checkResult);
    }

    public void preInitAction() {
    }

    public LauncherModule preInit() {
        if (!this.initStatus.equals((Object)InitStatus.PRE_INIT_WAIT)) {
            throw new IllegalStateException("PreInit not allowed in current state");
        }
        this.initStatus = InitStatus.PRE_INIT;
        this.preInitAction();
        this.initStatus = InitStatus.INIT_WAIT;
        return this;
    }

    public abstract void init(LauncherInitContext var1);

    protected <T extends Event> boolean registerEvent(EventHandler<T> handle, Class<T> tClass) {
        this.eventMap.put(tClass, handle);
        return true;
    }

    public final <T extends Event> void callEvent(T event) {
        Class<?> tClass = event.getClass();
        for (Map.Entry<Class<? extends Event>, EventHandler> e : this.eventMap.entrySet()) {
            if (!e.getKey().isAssignableFrom(tClass)) continue;
            e.getValue().event(event);
            if (!event.isCancel()) continue;
            return;
        }
    }

    public static class Event {
        protected boolean cancel = false;

        public boolean isCancel() {
            return this.cancel;
        }

        public Event cancel() {
            this.cancel = true;
            return this;
        }
    }

    @FunctionalInterface
    public static interface EventHandler<T extends Event> {
        public void event(T var1);
    }

    public static enum InitStatus {
        CREATED(false),
        PRE_INIT_WAIT(true),
        PRE_INIT(false),
        INIT_WAIT(true),
        INIT(false),
        FINISH(true);

        private final boolean isAvailable;

        private InitStatus(boolean b) {
            this.isAvailable = b;
        }

        public boolean isAvailable() {
            return this.isAvailable;
        }
    }
}

