/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.modules.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.jar.JarFile;
import pro.gravit.launcher.LauncherTrustManager;
import pro.gravit.launcher.managers.SimpleModulesConfigManager;
import pro.gravit.launcher.modules.LauncherInitContext;
import pro.gravit.launcher.modules.LauncherModule;
import pro.gravit.launcher.modules.LauncherModuleInfo;
import pro.gravit.launcher.modules.LauncherModulesManager;
import pro.gravit.launcher.modules.ModulesConfigManager;
import pro.gravit.launcher.modules.impl.SimpleModuleContext;
import pro.gravit.utils.PublicURLClassLoader;
import pro.gravit.utils.Version;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.LogHelper;

public class SimpleModuleManager
implements LauncherModulesManager {
    private static final MethodType VOID_TYPE = MethodType.methodType(Void.TYPE);
    protected final List<LauncherModule> modules = new ArrayList<LauncherModule>();
    protected final List<String> moduleNames = new ArrayList<String>();
    protected final SimpleModuleContext context;
    protected final ModulesConfigManager modulesConfigManager;
    protected final Path modulesDir;
    protected final LauncherTrustManager trustManager;
    protected final PublicURLClassLoader classLoader = new PublicURLClassLoader(new URL[0]);
    protected LauncherInitContext initContext;
    @Deprecated
    protected LauncherTrustManager.CheckMode checkMode = LauncherTrustManager.CheckMode.WARN_IN_NOT_SIGNED;

    public SimpleModuleManager(Path modulesDir, Path configDir) {
        this.modulesConfigManager = new SimpleModulesConfigManager(configDir);
        this.context = new SimpleModuleContext(this, this.modulesConfigManager);
        this.modulesDir = modulesDir;
        this.trustManager = null;
    }

    public SimpleModuleManager(Path modulesDir, Path configDir, LauncherTrustManager trustManager) {
        this.modulesConfigManager = new SimpleModulesConfigManager(configDir);
        this.context = new SimpleModuleContext(this, this.modulesConfigManager);
        this.modulesDir = modulesDir;
        this.trustManager = trustManager;
    }

    private static X509Certificate[] getCertificates(Class<?> clazz) {
        Object[] signers = clazz.getSigners();
        if (signers == null) {
            return null;
        }
        return (X509Certificate[])Arrays.stream(signers).filter(c -> c instanceof X509Certificate).map(c -> (X509Certificate)c).toArray(X509Certificate[]::new);
    }

    public void autoload() throws IOException {
        this.autoload(this.modulesDir);
    }

    public void autoload(Path dir) throws IOException {
        if (Files.notExists(dir, new LinkOption[0])) {
            Files.createDirectory(dir, new FileAttribute[0]);
        } else {
            IOHelper.walk((Path)dir, (FileVisitor)new ModulesVisitor(), (boolean)true);
        }
    }

    public void initModules(LauncherInitContext initContext) {
        boolean isAnyModuleLoad = true;
        this.modules.sort((m1, m2) -> {
            int priority1 = m1.getModuleInfo().priority;
            int priority2 = m2.getModuleInfo().priority;
            return Integer.compare(priority1, priority2);
        });
        while (isAnyModuleLoad) {
            isAnyModuleLoad = false;
            for (LauncherModule module : this.modules) {
                if (!module.getInitStatus().equals((Object)LauncherModule.InitStatus.INIT_WAIT) || !this.checkDepend(module)) continue;
                isAnyModuleLoad = true;
                module.setInitStatus(LauncherModule.InitStatus.INIT);
                module.init(initContext);
                module.setInitStatus(LauncherModule.InitStatus.FINISH);
            }
        }
        for (LauncherModule module : this.modules) {
            LauncherModuleInfo info;
            if (module.getInitStatus().equals((Object)LauncherModule.InitStatus.INIT_WAIT)) {
                info = module.getModuleInfo();
                LogHelper.warning((String)"Module %s required %s. Cyclic dependencies?", (Object[])new Object[]{info.name, Arrays.toString(info.dependencies)});
                module.setInitStatus(LauncherModule.InitStatus.INIT);
                module.init(initContext);
                module.setInitStatus(LauncherModule.InitStatus.FINISH);
                continue;
            }
            if (!module.getInitStatus().equals((Object)LauncherModule.InitStatus.PRE_INIT_WAIT)) continue;
            info = module.getModuleInfo();
            LogHelper.error((String)"Module %s skip pre-init phase. This module NOT finish loading", (Object[])new Object[]{info.name, Arrays.toString(info.dependencies)});
        }
    }

    private boolean checkDepend(LauncherModule module) {
        LauncherModuleInfo info = module.getModuleInfo();
        for (String dep : info.dependencies) {
            LauncherModule depModule = this.getModule(dep);
            if (depModule == null) {
                throw new RuntimeException(String.format("Module %s required %s. %s not found", info.name, dep, dep));
            }
            if (depModule.getInitStatus().equals((Object)LauncherModule.InitStatus.FINISH)) continue;
            return false;
        }
        return true;
    }

    @Override
    public LauncherModule loadModule(LauncherModule module) {
        if (this.modules.contains(module)) {
            return module;
        }
        if (module.getCheckStatus() == null) {
            LauncherTrustManager.CheckClassResult result = this.checkModuleClass(module.getClass());
            this.verifyClassCheckResult(result);
            module.setCheckResult(result);
        }
        this.modules.add(module);
        LauncherModuleInfo info = module.getModuleInfo();
        this.moduleNames.add(info.name);
        module.setContext(this.context);
        module.preInit();
        if (this.initContext != null) {
            module.setInitStatus(LauncherModule.InitStatus.INIT);
            module.init(this.initContext);
            module.setInitStatus(LauncherModule.InitStatus.FINISH);
        }
        return module;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public LauncherModule loadModule(Path file) throws IOException {
        try (JarFile f = new JarFile(file.toFile());){
            LauncherModule module;
            String moduleClass;
            String string = moduleClass = f.getManifest() != null ? f.getManifest().getMainAttributes().getValue("Module-Main-Class") : null;
            if (moduleClass == null) {
                LogHelper.error((String)"In module %s Module-Main-Class not found", (Object[])new Object[]{file.toString()});
                LauncherModule launcherModule = null;
                return launcherModule;
            }
            this.classLoader.addURL(file.toUri().toURL());
            Class<?> clazz = Class.forName(moduleClass, false, (ClassLoader)this.classLoader);
            LauncherTrustManager.CheckClassResult result = this.checkModuleClass(clazz);
            try {
                this.verifyClassCheckResultExceptional(result);
            }
            catch (Exception e) {
                LogHelper.error((Throwable)e);
                LogHelper.error((String)"In module %s signature check failed", (Object[])new Object[]{file.toString()});
                LauncherModule launcherModule = null;
                f.close();
                return launcherModule;
            }
            if (!LauncherModule.class.isAssignableFrom(clazz)) {
                throw new ClassNotFoundException("Invalid module class... Not contains LauncherModule in hierarchy.");
            }
            try {
                module = (LauncherModule)MethodHandles.publicLookup().findConstructor(clazz, VOID_TYPE).invokeWithArguments(Collections.emptyList());
                module.setCheckResult(result);
            }
            catch (Throwable e) {
                throw (InstantiationException)new InstantiationException("Error on instancing...").initCause(e);
            }
            this.loadModule(module);
            LauncherModule launcherModule = module;
            return launcherModule;
        }
        catch (ClassNotFoundException | InstantiationException e) {
            LogHelper.error((Throwable)e);
            LogHelper.error((String)"In module %s Module-Main-Class incorrect", (Object[])new Object[]{file.toString()});
            return null;
        }
    }

    @Deprecated
    public void checkModuleClass(Class<? extends LauncherModule> clazz, LauncherTrustManager.CheckMode mode) throws SecurityException {
        if (this.trustManager == null) {
            return;
        }
        X509Certificate[] certificates = SimpleModuleManager.getCertificates(clazz);
        if (certificates == null) {
            if (mode == LauncherTrustManager.CheckMode.EXCEPTION_IN_NOT_SIGNED) {
                throw new SecurityException(String.format("Class %s not signed", clazz.getName()));
            }
            if (mode == LauncherTrustManager.CheckMode.WARN_IN_NOT_SIGNED) {
                LogHelper.warning((String)"Class %s not signed", (Object[])new Object[]{clazz.getName()});
            }
            return;
        }
        try {
            this.trustManager.checkCertificatesSuccess(certificates, (arg_0, arg_1, arg_2) -> ((LauncherTrustManager)this.trustManager).stdCertificateChecker(arg_0, arg_1, arg_2));
        }
        catch (Exception e) {
            throw new SecurityException(e);
        }
    }

    public LauncherTrustManager.CheckClassResult checkModuleClass(Class<? extends LauncherModule> clazz) {
        if (this.trustManager == null) {
            return null;
        }
        X509Certificate[] certificates = SimpleModuleManager.getCertificates(clazz);
        return this.trustManager.checkCertificates(certificates, (arg_0, arg_1, arg_2) -> ((LauncherTrustManager)this.trustManager).stdCertificateChecker(arg_0, arg_1, arg_2));
    }

    public boolean verifyClassCheckResult(LauncherTrustManager.CheckClassResult result) {
        if (result == null) {
            return false;
        }
        return result.type == LauncherTrustManager.CheckClassResultType.SUCCESS;
    }

    public void verifyClassCheckResultExceptional(LauncherTrustManager.CheckClassResult result) throws Exception {
        if (this.verifyClassCheckResult(result)) {
            return;
        }
        if (result.exception != null) {
            throw result.exception;
        }
        throw new SecurityException(result.type.name());
    }

    @Override
    public LauncherModule getModule(String name) {
        for (LauncherModule module : this.modules) {
            LauncherModuleInfo info = module.getModuleInfo();
            if (!info.name.equals(name) && (info.providers.length <= 0 || !Arrays.asList(info.providers).contains(name))) continue;
            return module;
        }
        return null;
    }

    @Override
    public LauncherModule getCoreModule() {
        return null;
    }

    @Override
    public ClassLoader getModuleClassLoader() {
        return this.classLoader;
    }

    @Override
    public <T extends LauncherModule> T getModule(Class<? extends T> clazz) {
        for (LauncherModule module : this.modules) {
            if (!clazz.isAssignableFrom(module.getClass())) continue;
            return (T)module;
        }
        return null;
    }

    @Override
    public <T> T getModuleByInterface(Class<T> clazz) {
        for (LauncherModule module : this.modules) {
            if (!clazz.isAssignableFrom(module.getClass())) continue;
            return (T)module;
        }
        return null;
    }

    @Override
    public <T> List<T> getModulesByInterface(Class<T> clazz) {
        ArrayList<LauncherModule> list = new ArrayList<LauncherModule>();
        for (LauncherModule module : this.modules) {
            if (!clazz.isAssignableFrom(module.getClass())) continue;
            list.add(module);
        }
        return list;
    }

    @Override
    public <T extends LauncherModule> T findModule(Class<? extends T> clazz, Predicate<Version> versionPredicate) {
        for (LauncherModule module : this.modules) {
            LauncherModuleInfo info = module.getModuleInfo();
            if (!versionPredicate.test(info.version) || !clazz.isAssignableFrom(module.getClass())) continue;
            return (T)module;
        }
        return null;
    }

    @Override
    public <T extends LauncherModule.Event> void invokeEvent(T event) {
        for (LauncherModule module : this.modules) {
            module.callEvent(event);
            if (!event.isCancel()) continue;
            return;
        }
    }

    @Override
    public ModulesConfigManager getConfigManager() {
        return this.modulesConfigManager;
    }

    protected final class ModulesVisitor
    extends SimpleFileVisitor<Path> {
        private ModulesVisitor() {
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            if (file.toFile().getName().endsWith(".jar")) {
                SimpleModuleManager.this.loadModule(file);
            }
            return super.visitFile(file, attrs);
        }
    }
}

