/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.profiles.optional;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import pro.gravit.launcher.profiles.ClientProfile;
import pro.gravit.launcher.profiles.optional.OptionalFile;
import pro.gravit.launcher.profiles.optional.actions.OptionalAction;

public class OptionalView {
    public Set<OptionalFile> enabled = new HashSet<OptionalFile>();
    public Map<OptionalFile, Set<OptionalFile>> dependenciesCountMap = new HashMap<OptionalFile, Set<OptionalFile>>();
    public Set<OptionalFile> all;

    public <T extends OptionalAction> Set<T> getActionsByClass(Class<T> clazz) {
        HashSet<OptionalAction> results = new HashSet<OptionalAction>();
        for (OptionalFile e : this.enabled) {
            if (e.actions == null) continue;
            for (OptionalAction a : e.actions) {
                if (!clazz.isAssignableFrom(a.getClass())) continue;
                results.add(a);
            }
        }
        return results;
    }

    public Set<OptionalAction> getEnabledActions() {
        HashSet<OptionalAction> results = new HashSet<OptionalAction>();
        for (OptionalFile e : this.enabled) {
            if (e.actions == null) continue;
            results.addAll(e.actions);
        }
        return results;
    }

    public Set<OptionalAction> getDisabledActions() {
        HashSet<OptionalAction> results = new HashSet<OptionalAction>();
        for (OptionalFile e : this.all) {
            if (this.enabled.contains(e) || e.actions == null) continue;
            results.addAll(e.actions);
        }
        return results;
    }

    public void enable(OptionalFile file) {
        if (this.enabled.contains(file)) {
            return;
        }
        this.enabled.add(file);
        file.watchEvent(true);
        if (file.dependencies != null) {
            for (OptionalFile dep : file.dependencies) {
                Set dependenciesCount = this.dependenciesCountMap.computeIfAbsent(dep, k -> new HashSet());
                dependenciesCount.add(file);
                this.enable(dep);
            }
        }
        if (file.conflict != null) {
            for (OptionalFile conflict : file.conflict) {
                this.disable(conflict);
            }
        }
    }

    public void disable(OptionalFile file) {
        if (!this.enabled.remove(file)) {
            return;
        }
        file.watchEvent(false);
        Set<OptionalFile> dependenciesCount = this.dependenciesCountMap.get(file);
        if (dependenciesCount != null) {
            for (OptionalFile f : dependenciesCount) {
                if (f.isPreset) continue;
                this.disable(f);
            }
            dependenciesCount.clear();
        }
        if (file.dependencies != null) {
            for (OptionalFile f : file.dependencies) {
                if (!this.enabled.contains(f)) continue;
                dependenciesCount = this.dependenciesCountMap.get(f);
                if (dependenciesCount == null) {
                    this.disable(f);
                    continue;
                }
                if (dependenciesCount.size() > 1) continue;
                dependenciesCount.clear();
                this.disable(f);
            }
        }
    }

    public OptionalView(ClientProfile profile) {
        this.all = profile.getOptional();
        for (OptionalFile f : this.all) {
            if (!f.mark) continue;
            this.enable(f);
        }
    }

    public OptionalView(OptionalView view) {
        this.enabled = new HashSet<OptionalFile>(view.enabled);
        this.dependenciesCountMap = new HashMap<OptionalFile, Set<OptionalFile>>(view.dependenciesCountMap);
        this.all = view.all;
    }
}

