/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.request;

import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import pro.gravit.launcher.Launcher;
import pro.gravit.launcher.LauncherNetworkAPI;
import pro.gravit.launcher.request.RequestException;
import pro.gravit.launcher.request.WebSocketEvent;
import pro.gravit.launcher.request.websockets.StdWebSocketService;
import pro.gravit.launcher.request.websockets.WebSocketRequest;
import pro.gravit.utils.helper.SecurityHelper;

public abstract class Request<R extends WebSocketEvent>
implements WebSocketRequest {
    public static StdWebSocketService service;
    private static long session;
    @LauncherNetworkAPI
    public final UUID requestUUID = UUID.randomUUID();
    private final transient AtomicBoolean started = new AtomicBoolean(false);

    public static long getSession() {
        return session;
    }

    public static void setSession(long session) {
        Request.session = session;
    }

    public static void requestError(String message) throws RequestException {
        throw new RequestException(message);
    }

    public R request() throws Exception {
        if (!this.started.compareAndSet(false, true)) {
            throw new IllegalStateException("Request already started");
        }
        if (service == null) {
            service = StdWebSocketService.initWebSockets(Launcher.getConfig().address, false);
        }
        return this.requestDo(service);
    }

    public R request(StdWebSocketService service) throws Exception {
        if (!this.started.compareAndSet(false, true)) {
            throw new IllegalStateException("Request already started");
        }
        return this.requestDo(service);
    }

    protected R requestDo(StdWebSocketService service) throws Exception {
        return (R)service.requestSync(this);
    }

    static {
        session = SecurityHelper.secureRandom.nextLong();
    }
}

