/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.profiles.optional;

import pro.gravit.launcher.profiles.optional.triggers.JavaTrigger;
import pro.gravit.launcher.profiles.optional.triggers.OSTrigger;
import pro.gravit.utils.helper.JVMHelper;

@Deprecated
public class OptionalTrigger {
    public TriggerType type;
    public boolean need = true;
    public long value;
    public long compareMode = 0L;

    public OptionalTrigger() {
    }

    public OptionalTrigger(TriggerType type, long value) {
        this.type = type;
        this.value = value;
    }

    public OptionalTrigger(TriggerType type, boolean need, long value, long compareMode) {
        this.type = type;
        this.need = need;
        this.value = value;
        this.compareMode = compareMode;
    }

    public boolean isTriggered() {
        long test;
        block0 : switch (this.type) {
            case JAVA_VERSION: {
                test = JVMHelper.JVM_VERSION;
                break;
            }
            case JAVA_BITS: {
                test = JVMHelper.JVM_BITS;
                break;
            }
            case OS_BITS: {
                test = JVMHelper.OS_BITS;
                break;
            }
            case OS_TYPE: {
                switch (JVMHelper.OS_TYPE) {
                    case MUSTDIE: {
                        test = 0L;
                        break block0;
                    }
                    case LINUX: {
                        test = 1L;
                        break block0;
                    }
                    case MACOSX: {
                        test = 2L;
                        break block0;
                    }
                }
                return false;
            }
            default: {
                return false;
            }
        }
        if (this.compareMode == 0L) {
            return test == this.value;
        }
        if (this.compareMode < 0L) {
            return test < this.value;
        }
        return test > this.value;
    }

    public pro.gravit.launcher.profiles.optional.triggers.OptionalTrigger toTrigger() {
        switch (this.type) {
            case JAVA_VERSION: {
                JavaTrigger trigger = new JavaTrigger((int)this.value, (int)this.value);
                trigger.required = this.need;
                if (this.compareMode > 0L) {
                    trigger.maxVersion = 999;
                } else if (this.compareMode < 0L) {
                    trigger.minVersion = 0;
                }
                return trigger;
            }
            case JAVA_BITS: 
            case OS_BITS: {
                return null;
            }
            case OS_TYPE: {
                JVMHelper.OS os;
                if (this.value == 0L) {
                    os = JVMHelper.OS.MUSTDIE;
                } else if (this.value == 1L) {
                    os = JVMHelper.OS.LINUX;
                } else if (this.value == 2L) {
                    os = JVMHelper.OS.MUSTDIE;
                } else {
                    throw new IllegalArgumentException(String.format("Os version %d unknown", this.value));
                }
                OSTrigger trigger = new OSTrigger(os);
                trigger.required = this.need;
                if (this.compareMode != 0L) {
                    trigger.inverted = true;
                }
                return trigger;
            }
        }
        return null;
    }

    public static enum TriggerType {
        JAVA_VERSION,
        JAVA_BITS,
        OS_BITS,
        OS_TYPE;

    }
}

