/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import pro.gravit.launcher.LauncherNetworkAPI;
import pro.gravit.launcher.serialize.HInput;

public class ClientPermissions {
    public static final ClientPermissions DEFAULT = new ClientPermissions();
    @Deprecated
    @LauncherNetworkAPI
    public long permissions;
    @Deprecated
    @LauncherNetworkAPI
    public long flags;
    @LauncherNetworkAPI
    private List<String> roles;
    @LauncherNetworkAPI
    private List<String> perms;
    private transient List<PermissionPattern> available;

    public ClientPermissions(HInput input) throws IOException {
        this(input.readLong());
    }

    public ClientPermissions() {
    }

    public ClientPermissions(long permissions) {
        this.permissions = permissions;
    }

    public ClientPermissions(long permissions, long flags) {
        this.permissions = permissions;
        this.flags = flags;
    }

    public static ClientPermissions getSuperuserAccount() {
        ClientPermissions perm = new ClientPermissions();
        perm.setPermission(PermissionConsts.ADMIN, true);
        perm.addPerm("*");
        return perm;
    }

    public long toLong() {
        return this.permissions;
    }

    public boolean hasRole(String role) {
        return this.roles != null && this.roles.contains(role);
    }

    public synchronized void compile() {
        if (this.available != null) {
            return;
        }
        if (this.perms == null) {
            this.perms = new ArrayList<String>(0);
        }
        this.available = new ArrayList<PermissionPattern>(this.perms.size());
        for (String a : this.perms) {
            this.available.add(new PermissionPattern(a));
        }
        if (this.permissions != 0L && this.isPermission(PermissionConsts.ADMIN)) {
            this.roles.add("ADMIN");
            this.available.add(new PermissionPattern("*"));
        }
    }

    public boolean hasPerm(String action) {
        if (this.available == null) {
            this.compile();
        }
        for (PermissionPattern p : this.available) {
            if (!p.match(action)) continue;
            return true;
        }
        return false;
    }

    public void addRole(String role) {
        if (this.roles == null) {
            this.roles = new ArrayList<String>(1);
        }
        this.roles.add(role);
    }

    public void addPerm(String perm) {
        if (this.perms == null) {
            this.perms = new ArrayList<String>(1);
        }
        this.perms.add(perm);
        if (this.available == null) {
            this.available = new ArrayList<PermissionPattern>(1);
        }
        this.available.add(new PermissionPattern(perm));
    }

    public void removePerm(String action) {
        if (this.perms == null) {
            return;
        }
        if (this.available == null) {
            return;
        }
        this.perms.remove(action);
        this.available.remove(new PermissionPattern(action));
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public List<String> getPerms() {
        return this.perms;
    }

    @Deprecated
    public final boolean isPermission(PermissionConsts con) {
        return (this.permissions & con.mask) != 0L;
    }

    @Deprecated
    public final boolean isPermission(long mask) {
        return (this.permissions & mask) != 0L;
    }

    @Deprecated
    public final boolean isFlag(FlagConsts con) {
        return (this.flags & con.mask) != 0L;
    }

    @Deprecated
    public final boolean isFlag(long mask) {
        return (this.flags & mask) != 0L;
    }

    @Deprecated
    public final void setPermission(PermissionConsts con, boolean value) {
        this.permissions = value ? (this.permissions |= con.mask) : (this.permissions &= con.mask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @Deprecated
    public final void setPermission(long mask, boolean value) {
        this.permissions = value ? (this.permissions |= mask) : (this.permissions &= mask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @Deprecated
    public final void setFlag(FlagConsts con, boolean value) {
        this.flags = value ? (this.flags |= con.mask) : (this.flags &= con.mask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @Deprecated
    public final void setFlag(long mask, boolean value) {
        this.flags = value ? (this.flags |= mask) : (this.flags &= mask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public String toString() {
        return "ClientPermissions{roles=" + String.join((CharSequence)", ", this.roles == null ? Collections.emptyList() : this.roles) + ", actions=" + String.join((CharSequence)", ", this.perms == null ? Collections.emptyList() : this.perms) + '}';
    }

    @Deprecated
    public static enum PermissionConsts {
        ADMIN(1L),
        MANAGEMENT(2L);

        public final long mask;

        private PermissionConsts(long mask) {
            this.mask = mask;
        }
    }

    public static class PermissionPattern {
        private final String[] parts;
        private final int priority;

        public PermissionPattern(String pattern) {
            int pos;
            ArrayList<String> prepare = new ArrayList<String>();
            int i = 0;
            while ((pos = pattern.indexOf("*", i)) >= 0) {
                prepare.add(pattern.substring(i, pos));
                i = pos + 1;
            }
            prepare.add(pattern.substring(i));
            this.priority = prepare.size() - 1;
            this.parts = prepare.toArray(new String[0]);
        }

        public int getPriority() {
            return this.priority;
        }

        public boolean match(String str) {
            if (this.parts.length == 0) {
                return true;
            }
            if (this.parts.length == 1) {
                return this.parts[0].equals(str);
            }
            int offset = 0;
            if (!str.startsWith(this.parts[0])) {
                return false;
            }
            if (!str.endsWith(this.parts[this.parts.length - 1])) {
                return false;
            }
            for (int i = 1; i < this.parts.length - 1; ++i) {
                int pos = str.indexOf(this.parts[i], offset);
                if (pos < 0) {
                    return false;
                }
                offset = pos + 1;
            }
            return true;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PermissionPattern that = (PermissionPattern)o;
            return this.priority == that.priority && Arrays.equals(this.parts, that.parts);
        }

        public int hashCode() {
            int result = Objects.hash(this.priority);
            result = 31 * result + Arrays.hashCode(this.parts);
            return result;
        }
    }

    @Deprecated
    public static enum FlagConsts {
        SYSTEM(1L),
        BANNED(2L),
        UNTRUSTED(4L),
        HIDDEN(8L);

        public final long mask;

        private FlagConsts(long mask) {
            this.mask = mask;
        }
    }
}

