/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.profiles;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import pro.gravit.launcher.LauncherNetworkAPI;
import pro.gravit.launcher.hasher.FileNameMatcher;
import pro.gravit.launcher.profiles.optional.OptionalDepend;
import pro.gravit.launcher.profiles.optional.OptionalFile;
import pro.gravit.launcher.profiles.optional.triggers.OptionalTrigger;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.VerifyHelper;

public final class ClientProfile
implements Comparable<ClientProfile> {
    private static final FileNameMatcher ASSET_MATCHER = new FileNameMatcher(new String[0], new String[]{"indexes", "objects"}, new String[0]);
    @LauncherNetworkAPI
    private String title;
    @LauncherNetworkAPI
    private UUID uuid;
    @LauncherNetworkAPI
    private String version;
    @LauncherNetworkAPI
    private String info;
    @LauncherNetworkAPI
    private String dir;
    @LauncherNetworkAPI
    private int sortIndex;
    @LauncherNetworkAPI
    private String assetIndex;
    @LauncherNetworkAPI
    private String assetDir;
    @LauncherNetworkAPI
    private List<String> update;
    @LauncherNetworkAPI
    private List<String> updateExclusions;
    @LauncherNetworkAPI
    private List<String> updateShared;
    @LauncherNetworkAPI
    private List<String> updateVerify;
    @LauncherNetworkAPI
    private Set<OptionalFile> updateOptional;
    @LauncherNetworkAPI
    private List<String> jvmArgs;
    @LauncherNetworkAPI
    private List<String> classPath;
    @LauncherNetworkAPI
    private List<String> modulePath = new ArrayList<String>();
    @LauncherNetworkAPI
    private List<String> modules = new ArrayList<String>();
    @LauncherNetworkAPI
    private List<String> altClassPath;
    @LauncherNetworkAPI
    private List<String> clientArgs;
    @LauncherNetworkAPI
    private List<String> compatClasses;
    @LauncherNetworkAPI
    private Map<String, String> properties;
    @LauncherNetworkAPI
    private List<ServerProfile> servers;
    @LauncherNetworkAPI
    private SecurityManagerConfig securityManagerConfig;
    @LauncherNetworkAPI
    private ClassLoaderConfig classLoaderConfig;
    @LauncherNetworkAPI
    private SignedClientConfig signedClientConfig;
    @LauncherNetworkAPI
    private RuntimeInClientConfig runtimeInClientConfig;
    @LauncherNetworkAPI
    private int recommendJavaVersion = 8;
    @LauncherNetworkAPI
    private int minJavaVersion = 8;
    @LauncherNetworkAPI
    private int maxJavaVersion = 999;
    @LauncherNetworkAPI
    private boolean warnMissJavaVersion = true;
    @LauncherNetworkAPI
    private ProfileDefaultSettings settings = new ProfileDefaultSettings();
    @LauncherNetworkAPI
    private boolean updateFastCheck;
    @LauncherNetworkAPI
    private boolean limited;
    @LauncherNetworkAPI
    private String mainClass;

    public ClientProfile() {
        this.update = new ArrayList<String>();
        this.updateExclusions = new ArrayList<String>();
        this.updateShared = new ArrayList<String>();
        this.updateVerify = new ArrayList<String>();
        this.updateOptional = new HashSet<OptionalFile>();
        this.jvmArgs = new ArrayList<String>();
        this.classPath = new ArrayList<String>();
        this.modulePath = new ArrayList<String>();
        this.altClassPath = new ArrayList<String>();
        this.clientArgs = new ArrayList<String>();
        this.compatClasses = new ArrayList<String>();
        this.properties = new HashMap<String, String>();
        this.servers = new ArrayList<ServerProfile>(1);
        this.securityManagerConfig = SecurityManagerConfig.CLIENT;
        this.classLoaderConfig = ClassLoaderConfig.LAUNCHER;
        this.signedClientConfig = SignedClientConfig.NONE;
        this.runtimeInClientConfig = RuntimeInClientConfig.NONE;
    }

    public ClientProfile(List<String> update, List<String> updateExclusions, List<String> updateShared, List<String> updateVerify, Set<OptionalFile> updateOptional, List<String> jvmArgs, List<String> classPath, List<String> modulePath, List<String> modules, List<String> altClassPath, List<String> clientArgs, List<String> compatClasses, Map<String, String> properties, List<ServerProfile> servers, SecurityManagerConfig securityManagerConfig, ClassLoaderConfig classLoaderConfig, SignedClientConfig signedClientConfig, RuntimeInClientConfig runtimeInClientConfig, String version, String assetIndex, String dir, String assetDir, int recommendJavaVersion, int minJavaVersion, int maxJavaVersion, boolean warnMissJavaVersion, ProfileDefaultSettings settings, int sortIndex, UUID uuid, String title, String info, boolean updateFastCheck, String mainClass) {
        this.update = update;
        this.updateExclusions = updateExclusions;
        this.updateShared = updateShared;
        this.updateVerify = updateVerify;
        this.updateOptional = updateOptional;
        this.jvmArgs = jvmArgs;
        this.classPath = classPath;
        this.modulePath = modulePath;
        this.modules = modules;
        this.altClassPath = altClassPath;
        this.clientArgs = clientArgs;
        this.compatClasses = compatClasses;
        this.properties = properties;
        this.servers = servers;
        this.securityManagerConfig = securityManagerConfig;
        this.classLoaderConfig = classLoaderConfig;
        this.signedClientConfig = signedClientConfig;
        this.runtimeInClientConfig = runtimeInClientConfig;
        this.version = version;
        this.assetIndex = assetIndex;
        this.dir = dir;
        this.assetDir = assetDir;
        this.recommendJavaVersion = recommendJavaVersion;
        this.minJavaVersion = minJavaVersion;
        this.maxJavaVersion = maxJavaVersion;
        this.warnMissJavaVersion = warnMissJavaVersion;
        this.settings = settings;
        this.sortIndex = sortIndex;
        this.uuid = uuid;
        this.title = title;
        this.info = info;
        this.updateFastCheck = updateFastCheck;
        this.mainClass = mainClass;
    }

    public ServerProfile getDefaultServerProfile() {
        for (ServerProfile profile : this.servers) {
            if (!profile.isDefault) continue;
            return profile;
        }
        return null;
    }

    @Override
    public int compareTo(ClientProfile o) {
        return Integer.compare(this.getSortIndex(), o.getSortIndex());
    }

    public String getAssetIndex() {
        return this.assetIndex;
    }

    public FileNameMatcher getAssetUpdateMatcher() {
        return this.getVersion().compareTo(Version.MC1710) >= 0 ? ASSET_MATCHER : null;
    }

    public String[] getClassPath() {
        return this.classPath.toArray(new String[0]);
    }

    public List<String> getModulePath() {
        return Collections.unmodifiableList(this.modulePath);
    }

    public List<String> getModules() {
        return Collections.unmodifiableList(this.modules);
    }

    public String[] getAlternativeClassPath() {
        return this.altClassPath.toArray(new String[0]);
    }

    public String[] getClientArgs() {
        return this.clientArgs.toArray(new String[0]);
    }

    public String getDir() {
        return this.dir;
    }

    public void setDir(String dir) {
        this.dir = dir;
    }

    public String getAssetDir() {
        return this.assetDir;
    }

    public List<String> getUpdateExclusions() {
        return Collections.unmodifiableList(this.updateExclusions);
    }

    public FileNameMatcher getClientUpdateMatcher() {
        String[] updateArray = this.update.toArray(new String[0]);
        String[] verifyArray = this.updateVerify.toArray(new String[0]);
        List<String> excludeList = this.updateExclusions;
        String[] exclusionsArray = excludeList.toArray(new String[0]);
        return new FileNameMatcher(updateArray, verifyArray, exclusionsArray);
    }

    public String[] getJvmArgs() {
        return this.jvmArgs.toArray(new String[0]);
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public List<ServerProfile> getServers() {
        return this.servers;
    }

    public String getServerAddress() {
        ServerProfile profile = this.getDefaultServerProfile();
        return profile == null ? "localhost" : profile.serverAddress;
    }

    public Set<OptionalFile> getOptional() {
        return this.updateOptional;
    }

    public int getRecommendJavaVersion() {
        return this.recommendJavaVersion;
    }

    public int getMinJavaVersion() {
        return this.minJavaVersion;
    }

    public int getMaxJavaVersion() {
        return this.maxJavaVersion;
    }

    public boolean isWarnMissJavaVersion() {
        return this.warnMissJavaVersion;
    }

    public ProfileDefaultSettings getSettings() {
        return this.settings;
    }

    public void updateOptionalGraph() {
        for (OptionalFile file : this.updateOptional) {
            int i;
            if (file.dependenciesFile != null) {
                file.dependencies = new OptionalFile[file.dependenciesFile.length];
                for (i = 0; i < file.dependenciesFile.length; ++i) {
                    file.dependencies[i] = this.getOptionalFile(file.dependenciesFile[i].name);
                }
            }
            if (file.conflictFile == null) continue;
            file.conflict = new OptionalFile[file.conflictFile.length];
            for (i = 0; i < file.conflictFile.length; ++i) {
                file.conflict[i] = this.getOptionalFile(file.conflictFile[i].name);
            }
        }
    }

    public OptionalFile getOptionalFile(String file) {
        for (OptionalFile f : this.updateOptional) {
            if (!f.name.equals(file)) continue;
            return f;
        }
        return null;
    }

    public Collection<String> getShared() {
        return this.updateShared;
    }

    public int getServerPort() {
        ServerProfile profile = this.getDefaultServerProfile();
        return profile == null ? 25565 : profile.serverPort;
    }

    public int getSortIndex() {
        return this.sortIndex;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getInfo() {
        return this.info;
    }

    public void setInfo(String info) {
        this.info = info;
    }

    public Version getVersion() {
        return Version.byName(this.version);
    }

    public void setVersion(Version version) {
        this.version = version.name;
    }

    public boolean isUpdateFastCheck() {
        return this.updateFastCheck;
    }

    public String toString() {
        return String.format("%s (%s)", this.title, this.uuid);
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public void setUUID(UUID uuid) {
        this.uuid = uuid;
    }

    public void verify() {
        this.getVersion();
        IOHelper.verifyFileName((String)this.getAssetIndex());
        VerifyHelper.verify((Object)this.getTitle(), (Predicate)VerifyHelper.NOT_EMPTY, (String)"Profile title can't be empty");
        VerifyHelper.verify((Object)this.getInfo(), (Predicate)VerifyHelper.NOT_EMPTY, (String)"Profile info can't be empty");
        VerifyHelper.verify((Object)this.getTitle(), (Predicate)VerifyHelper.NOT_EMPTY, (String)"Main class can't be empty");
        if (this.getUUID() == null) {
            throw new IllegalArgumentException("Profile UUID can't be null");
        }
        for (String s : this.update) {
            if (s != null) continue;
            throw new IllegalArgumentException("Found null entry in update");
        }
        for (String s : this.updateVerify) {
            if (s != null) continue;
            throw new IllegalArgumentException("Found null entry in updateVerify");
        }
        for (String s : this.updateExclusions) {
            if (s != null) continue;
            throw new IllegalArgumentException("Found null entry in updateExclusions");
        }
        for (String s : this.classPath) {
            if (s != null) continue;
            throw new IllegalArgumentException("Found null entry in classPath");
        }
        for (String s : this.jvmArgs) {
            if (s != null) continue;
            throw new IllegalArgumentException("Found null entry in jvmArgs");
        }
        for (String s : this.clientArgs) {
            if (s != null) continue;
            throw new IllegalArgumentException("Found null entry in clientArgs");
        }
        for (String s : this.compatClasses) {
            if (s != null) continue;
            throw new IllegalArgumentException("Found null entry in compatClasses");
        }
        for (OptionalFile f : this.updateOptional) {
            if (f == null) {
                throw new IllegalArgumentException("Found null entry in updateOptional");
            }
            if (f.name == null) {
                throw new IllegalArgumentException("Optional: name must not be null");
            }
            if (f.conflictFile != null) {
                for (OptionalDepend optionalDepend : f.conflictFile) {
                    if (optionalDepend != null) continue;
                    throw new IllegalArgumentException(String.format("Found null entry in updateOptional.%s.conflictFile", f.name));
                }
            }
            if (f.dependenciesFile != null) {
                for (OptionalDepend optionalDepend : f.dependenciesFile) {
                    if (optionalDepend != null) continue;
                    throw new IllegalArgumentException(String.format("Found null entry in updateOptional.%s.dependenciesFile", f.name));
                }
            }
            if (f.triggersList == null) continue;
            for (OptionalTrigger trigger : f.triggersList) {
                if (trigger != null) continue;
                throw new IllegalArgumentException(String.format("Found null entry in updateOptional.%s.triggers", f.name));
            }
        }
    }

    public String getProperty(String name) {
        return this.properties.get(name);
    }

    public void putProperty(String name, String value) {
        this.properties.put(name, value);
    }

    public boolean containsProperty(String name) {
        return this.properties.containsKey(name);
    }

    public void clearProperties() {
        this.properties.clear();
    }

    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public List<String> getCompatClasses() {
        return Collections.unmodifiableList(this.compatClasses);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientProfile profile = (ClientProfile)o;
        return Objects.equals(this.uuid, profile.uuid);
    }

    public int hashCode() {
        return Objects.hash(this.uuid);
    }

    public ClassLoaderConfig getClassLoaderConfig() {
        return this.classLoaderConfig;
    }

    public void setClassLoaderConfig(ClassLoaderConfig classLoaderConfig) {
        this.classLoaderConfig = classLoaderConfig;
    }

    public RuntimeInClientConfig getRuntimeInClientConfig() {
        return this.runtimeInClientConfig;
    }

    public void setRuntimeInClientConfig(RuntimeInClientConfig runtimeInClientConfig) {
        this.runtimeInClientConfig = runtimeInClientConfig;
    }

    public boolean isLimited() {
        return this.limited;
    }

    public static class ProfileDefaultSettings {
        public int ram;
        public boolean autoEnter;
        public boolean fullScreen;
    }

    public static enum SecurityManagerConfig {
        NONE,
        CLIENT,
        LAUNCHER,
        MIXED;

    }

    public static enum ClassLoaderConfig {
        AGENT,
        LAUNCHER,
        MODULE,
        SYSTEM_ARGS;

    }

    public static enum SignedClientConfig {
        NONE,
        SIGNED;

    }

    public static enum RuntimeInClientConfig {
        NONE,
        BASIC,
        FULL;

    }

    public static class ServerProfile {
        public String name;
        public String serverAddress;
        public int serverPort;
        public boolean isDefault = true;
        public boolean socketPing = true;

        public ServerProfile() {
        }

        public ServerProfile(String name, String serverAddress, int serverPort) {
            this.name = name;
            this.serverAddress = serverAddress;
            this.serverPort = serverPort;
        }

        public ServerProfile(String name, String serverAddress, int serverPort, boolean isDefault) {
            this.name = name;
            this.serverAddress = serverAddress;
            this.serverPort = serverPort;
            this.isDefault = isDefault;
        }

        public InetSocketAddress toSocketAddress() {
            return InetSocketAddress.createUnresolved(this.serverAddress, this.serverPort);
        }
    }

    public static enum Version {
        MC125("1.2.5", 29),
        MC147("1.4.7", 51),
        MC152("1.5.2", 61),
        MC164("1.6.4", 78),
        MC172("1.7.2", 4),
        MC1710("1.7.10", 5),
        MC189("1.8.9", 47),
        MC19("1.9", 107),
        MC192("1.9.2", 109),
        MC194("1.9.4", 110),
        MC1102("1.10.2", 210),
        MC111("1.11", 315),
        MC1112("1.11.2", 316),
        MC112("1.12", 335),
        MC1121("1.12.1", 338),
        MC1122("1.12.2", 340),
        MC113("1.13", 393),
        MC1131("1.13.1", 401),
        MC1132("1.13.2", 402),
        MC114("1.14", 477),
        MC1141("1.14.1", 480),
        MC1142("1.14.2", 485),
        MC1143("1.14.3", 490),
        MC1144("1.14.4", 498),
        MC115("1.15", 573),
        MC1151("1.15.1", 575),
        MC1152("1.15.2", 578),
        MC1161("1.16.1", 736),
        MC1162("1.16.2", 751),
        MC1163("1.16.3", 753),
        MC1164("1.16.4", 754),
        MC1165("1.16.5", 754),
        MC117("1.17", 755),
        MC1171("1.17.1", 756),
        MC118("1.18", 757),
        MC1181("1.18.1", 757),
        MC1182("1.18.2", 758);

        private static final Map<String, Version> VERSIONS;
        public final String name;
        public final int protocol;

        private Version(String name, int protocol) {
            this.name = name;
            this.protocol = protocol;
        }

        public static Version byName(String name) {
            return (Version)((Object)VerifyHelper.getMapValue(VERSIONS, (Object)name, (String)String.format("Unknown client version: '%s'", name)));
        }

        public String toString() {
            return "Minecraft " + this.name;
        }

        static {
            Version[] versionsValues = Version.values();
            VERSIONS = new HashMap<String, Version>(versionsValues.length);
            for (Version version : versionsValues) {
                VERSIONS.put(version.name, version);
            }
        }
    }

    @FunctionalInterface
    public static interface pushOptionalClassPathCallback {
        public void run(String[] var1) throws IOException;
    }
}

