/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.profiles;

import java.util.Objects;
import java.util.UUID;
import pro.gravit.launcher.profiles.Texture;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.VerifyHelper;

public final class PlayerProfile {
    public final UUID uuid;
    public final String username;
    public final Texture skin;
    public final Texture cloak;

    public PlayerProfile(UUID uuid, String username, Texture skin, Texture cloak) {
        this.uuid = Objects.requireNonNull(uuid, "uuid");
        this.username = VerifyHelper.verifyUsername((String)username);
        this.skin = skin;
        this.cloak = cloak;
    }

    public static PlayerProfile newOfflineProfile(String username) {
        return new PlayerProfile(PlayerProfile.offlineUUID(username), username, null, null);
    }

    public static UUID offlineUUID(String username) {
        return UUID.nameUUIDFromBytes(IOHelper.encodeASCII((String)("OfflinePlayer:" + username)));
    }
}

