/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.request;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import pro.gravit.launcher.Launcher;
import pro.gravit.launcher.LauncherNetworkAPI;
import pro.gravit.launcher.events.request.AuthRequestEvent;
import pro.gravit.launcher.events.request.RefreshTokenRequestEvent;
import pro.gravit.launcher.events.request.RestoreRequestEvent;
import pro.gravit.launcher.request.RequestException;
import pro.gravit.launcher.request.WebSocketEvent;
import pro.gravit.launcher.request.auth.RefreshTokenRequest;
import pro.gravit.launcher.request.auth.RestoreRequest;
import pro.gravit.launcher.request.auth.RestoreSessionRequest;
import pro.gravit.launcher.request.websockets.StdWebSocketService;
import pro.gravit.launcher.request.websockets.WebSocketRequest;
import pro.gravit.utils.helper.LogHelper;

public abstract class Request<R extends WebSocketEvent>
implements WebSocketRequest {
    private static final List<ExtendedTokenCallback> extendedTokenCallbacks = new ArrayList<ExtendedTokenCallback>(4);
    private static final List<BiConsumer<String, AuthRequestEvent.OAuthRequestEvent>> oauthChangeHandlers = new ArrayList<BiConsumer<String, AuthRequestEvent.OAuthRequestEvent>>(4);
    public static StdWebSocketService service;
    private static UUID session;
    private static AuthRequestEvent.OAuthRequestEvent oauth;
    private static Map<String, String> extendedTokens;
    private static String authId;
    private static long tokenExpiredTime;
    @LauncherNetworkAPI
    public final UUID requestUUID = UUID.randomUUID();
    private final transient AtomicBoolean started = new AtomicBoolean(false);

    public static UUID getSession() {
        return session;
    }

    public static void setSession(UUID session) {
        Request.session = session;
    }

    public static void setOAuth(String authId, AuthRequestEvent.OAuthRequestEvent event) {
        oauth = event;
        Request.authId = authId;
        tokenExpiredTime = oauth != null && Request.oauth.expire != 0L ? System.currentTimeMillis() + Request.oauth.expire : 0L;
        for (BiConsumer<String, AuthRequestEvent.OAuthRequestEvent> handler : oauthChangeHandlers) {
            handler.accept(authId, event);
        }
    }

    public static AuthRequestEvent.OAuthRequestEvent getOAuth() {
        return oauth;
    }

    public static String getAuthId() {
        return authId;
    }

    public static Map<String, String> getExtendedTokens() {
        if (extendedTokens != null) {
            return Collections.unmodifiableMap(extendedTokens);
        }
        return null;
    }

    public static void clearExtendedTokens() {
        if (extendedTokens != null) {
            extendedTokens.clear();
        }
    }

    public static void addExtendedToken(String name, String token) {
        if (extendedTokens == null) {
            extendedTokens = new HashMap<String, String>();
        }
        extendedTokens.put(name, token);
    }

    public static void addAllExtendedToken(Map<String, String> map) {
        if (extendedTokens == null) {
            extendedTokens = new HashMap<String, String>();
        }
        extendedTokens.putAll(map);
    }

    public static void setOAuth(String authId, AuthRequestEvent.OAuthRequestEvent event, long tokenExpiredTime) {
        oauth = event;
        Request.authId = authId;
        Request.tokenExpiredTime = tokenExpiredTime;
    }

    public static boolean isTokenExpired() {
        if (oauth == null) {
            return true;
        }
        if (tokenExpiredTime == 0L) {
            return false;
        }
        return System.currentTimeMillis() > tokenExpiredTime;
    }

    public static long getTokenExpiredTime() {
        return tokenExpiredTime;
    }

    public static String getAccessToken() {
        return oauth == null ? null : Request.oauth.accessToken;
    }

    public static String getRefreshToken() {
        return oauth == null ? null : Request.oauth.refreshToken;
    }

    public static RequestRestoreReport reconnect() throws Exception {
        service.open();
        return Request.restore();
    }

    public static RequestRestoreReport restore() throws Exception {
        RestoreRequest request;
        if (session != null) {
            RestoreSessionRequest request2 = new RestoreSessionRequest(session);
            request2.request();
            return new RequestRestoreReport(true, false, null);
        }
        boolean refreshed = false;
        if (oauth != null) {
            if (Request.isTokenExpired() || Request.oauth.accessToken == null) {
                RefreshTokenRequest refreshRequest = new RefreshTokenRequest(authId, Request.oauth.refreshToken);
                RefreshTokenRequestEvent event = (RefreshTokenRequestEvent)refreshRequest.request();
                Request.setOAuth(authId, event.oauth);
                refreshed = true;
            }
            request = new RestoreRequest(authId, Request.oauth.accessToken, extendedTokens, false);
        } else {
            request = new RestoreRequest(authId, null, extendedTokens, false);
        }
        RestoreRequestEvent event = (RestoreRequestEvent)request.request();
        List<String> invalidTokens = null;
        if (event.invalidTokens != null && event.invalidTokens.size() > 0) {
            boolean needRequest = false;
            HashMap<String, String> tokens = new HashMap<String, String>();
            for (ExtendedTokenCallback cb : extendedTokenCallbacks) {
                for (String tokenName : event.invalidTokens) {
                    String newToken = cb.tryGetNewToken(tokenName);
                    if (newToken == null) continue;
                    needRequest = true;
                    tokens.put(tokenName, newToken);
                    Request.addExtendedToken(tokenName, newToken);
                }
            }
            if (needRequest) {
                request = new RestoreRequest(authId, null, tokens, false);
                event = (RestoreRequestEvent)request.request();
                if (event.invalidTokens != null && event.invalidTokens.size() > 0) {
                    LogHelper.warning((String)"Tokens %s not restored", (Object[])new Object[]{String.join((CharSequence)",", event.invalidTokens)});
                }
            }
            invalidTokens = event.invalidTokens;
        }
        return new RequestRestoreReport(false, refreshed, invalidTokens);
    }

    public static void requestError(String message) throws RequestException {
        throw new RequestException(message);
    }

    public void addExtendedTokenCallback(ExtendedTokenCallback cb) {
        extendedTokenCallbacks.add(cb);
    }

    public void removeExtendedTokenCallback(ExtendedTokenCallback cb) {
        extendedTokenCallbacks.remove(cb);
    }

    public void addOAuthChangeHandler(BiConsumer<String, AuthRequestEvent.OAuthRequestEvent> eventHandler) {
        oauthChangeHandlers.add(eventHandler);
    }

    public void removeOAuthChangeHandler(BiConsumer<String, AuthRequestEvent.OAuthRequestEvent> eventHandler) {
        oauthChangeHandlers.remove(eventHandler);
    }

    public R request() throws Exception {
        if (!this.started.compareAndSet(false, true)) {
            throw new IllegalStateException("Request already started");
        }
        if (service == null) {
            service = StdWebSocketService.initWebSockets(Launcher.getConfig().address, false);
        }
        return this.requestDo(service);
    }

    public R request(StdWebSocketService service) throws Exception {
        if (!this.started.compareAndSet(false, true)) {
            throw new IllegalStateException("Request already started");
        }
        return this.requestDo(service);
    }

    protected R requestDo(StdWebSocketService service) throws Exception {
        return (R)service.requestSync(this);
    }

    public static class RequestRestoreReport {
        public final boolean legacySession;
        public final boolean refreshed;
        public final List<String> invalidExtendedTokens;

        public RequestRestoreReport(boolean legacySession, boolean refreshed, List<String> invalidExtendedTokens) {
            this.legacySession = legacySession;
            this.refreshed = refreshed;
            this.invalidExtendedTokens = invalidExtendedTokens;
        }
    }

    public static interface ExtendedTokenCallback {
        public String tryGetNewToken(String var1);
    }
}

